/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.QuickTemplate;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.platform.GeoServerExtensions;

public class ProxifyingURLMangler
implements URLMangler {
    GeoServer geoServer;
    public static String TEMPLATE_SEPARATOR = " ";
    public static String TEMPLATE_PREFIX = "${";
    public static String TEMPLATE_POSTFIX = "}";
    public static Map<String, Pattern> FORWARDED_PATTERNS = new HashMap<String, Pattern>();

    public ProxifyingURLMangler(GeoServer geoServer) {
        Arrays.asList(ForwardedComponents.values()).forEach(comp -> FORWARDED_PATTERNS.put(comp.asString(), Pattern.compile(String.format("(.*)%s=([^;^ ]+)(.*)", comp.asString()))));
        this.geoServer = geoServer;
    }

    public void mangleURL(StringBuilder baseURL, StringBuilder path, Map<String, String> kvp, URLMangler.URLType type) {
        String proxyBase = GeoServerExtensions.getProperty((String)"PROXY_BASE_URL") != null ? GeoServerExtensions.getProperty((String)"PROXY_BASE_URL") : this.geoServer.getSettings().getProxyBaseUrl();
        baseURL = this.geoServer.getGlobal().isUseHeadersProxyURL() == true && proxyBase != null ? this.mangleURLHeaders(baseURL, proxyBase) : this.mangleURLFixedURL(baseURL, proxyBase);
    }

    private StringBuilder mangleURLFixedURL(StringBuilder baseURL, String proxyBase) {
        if (proxyBase != null && proxyBase.trim().length() > 0) {
            baseURL.setLength(0);
            baseURL.append(proxyBase);
        }
        return baseURL;
    }

    private StringBuilder mangleURLHeaders(StringBuilder baseURL, String proxyBase) {
        if (Dispatcher.REQUEST.get() == null) {
            return baseURL;
        }
        if (!proxyBase.contains(TEMPLATE_PREFIX)) {
            return this.mangleURLFixedURL(baseURL, proxyBase);
        }
        Map<String, String> headers = this.compileHeadersMap();
        for (String template : Arrays.asList(proxyBase.split(TEMPLATE_SEPARATOR))) {
            String candidate = QuickTemplate.replaceVariables(template, headers);
            if (candidate.contains(TEMPLATE_PREFIX)) continue;
            baseURL.setLength(0);
            baseURL.append(candidate);
            break;
        }
        return baseURL;
    }

    private Map<String, String> compileHeadersMap() {
        HashMap<String, String> headers = new HashMap<String, String>();
        HttpServletRequest owsRequest = ((Request)Dispatcher.REQUEST.get()).getHttpRequest();
        Arrays.asList(Headers.values()).forEach(header -> {
            if (owsRequest.getHeader(header.asString()) != null) {
                if (header == Headers.FORWARDED) {
                    FORWARDED_PATTERNS.forEach((comp, pattern) -> {
                        Matcher m = pattern.matcher(owsRequest.getHeader(header.asString()));
                        if (m.matches()) {
                            headers.put(String.format("%s%s%s", TEMPLATE_PREFIX, Headers.FORWARDED.asString() + "." + comp, TEMPLATE_POSTFIX), m.group(2));
                        }
                    });
                } else {
                    headers.put(String.format("%s%s%s", TEMPLATE_PREFIX, header.asString(), TEMPLATE_POSTFIX), owsRequest.getHeader(header.asString()));
                }
            }
        });
        return headers;
    }

    public static enum ForwardedComponents {
        FOR("for"),
        BY("by"),
        PROTO("proto"),
        HOST("host"),
        PATH("path");

        private String comp;

        private ForwardedComponents(String c) {
            this.comp = c;
        }

        public String asString() {
            return this.comp;
        }
    }

    public static enum Headers {
        FORWARDED("Forwarded"),
        FORWARDED_PROTO("X-Forwarded-Proto"),
        FORWARDED_HOST("X-Forwarded-Host"),
        FORWARDED_PATH("X-Forwarded-Path"),
        FORWARDED_FOR("X-Forwarded-For"),
        HOST("Host");

        private String header;

        private Headers(String h) {
            this.header = h;
        }

        public String asString() {
            return this.header;
        }
    }
}

