/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.logging.LegacyLoggingImporter;
import org.geoserver.logging.LoggingUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geotools.util.logging.CommonsLoggerFactory;
import org.geotools.util.logging.Log4JLoggerFactory;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.Logging;

public class LoggingStartupContextListener
implements ServletContextListener {
    private static Logger LOGGER;

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        LoggingUtils.GeoToolsLoggingRedirection logging = LoggingUtils.GeoToolsLoggingRedirection.findValue(GeoServerExtensions.getProperty((String)"GT2_LOGGING_REDIRECTION", (ServletContext)context));
        try {
            if (logging != LoggingUtils.GeoToolsLoggingRedirection.JavaLogging) {
                if (logging == LoggingUtils.GeoToolsLoggingRedirection.CommonsLogging) {
                    Logging.ALL.setLoggerFactory((LoggerFactory)CommonsLoggerFactory.getInstance());
                } else {
                    Logging.ALL.setLoggerFactory((LoggerFactory)Log4JLoggerFactory.getInstance());
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Could not configure log4j logging redirection", e);
        }
        String relinquishLoggingControl = GeoServerExtensions.getProperty((String)"RELINQUISH_LOG4J_CONTROL", (ServletContext)context);
        if (Boolean.valueOf(relinquishLoggingControl).booleanValue()) {
            this.getLogger().info("RELINQUISH_LOG4J_CONTROL on, won't attempt to reconfigure LOG4J loggers");
        } else {
            try {
                File baseDir = new File(GeoServerResourceLoader.lookupGeoServerDataDirectory((ServletContext)context));
                GeoServerResourceLoader loader = new GeoServerResourceLoader(baseDir);
                LoggingInfo loginfo = LoggingStartupContextListener.getLogging((ResourceStore)loader);
                if (loginfo != null) {
                    String location = LoggingUtils.getLogFileLocation(loginfo.getLocation(), event.getServletContext());
                    LoggingUtils.initLogging(loader, loginfo.getLevel(), !loginfo.isStdOutLogging(), location);
                } else {
                    File f = loader.find("services.xml");
                    if (f != null) {
                        LegacyLoggingImporter loggingImporter = new LegacyLoggingImporter();
                        loggingImporter.imprt(baseDir);
                        String location = LoggingUtils.getLogFileLocation(loggingImporter.getLogFile(), null);
                        LoggingUtils.initLogging(loader, loggingImporter.getConfigFileName(), loggingImporter.getSuppressStdOutLogging(), location);
                    } else {
                        this.getLogger().log(Level.WARNING, "Could not find configuration file for logging");
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Could not configure log4j overrides", e);
            }
        }
    }

    @Deprecated
    @Nullable
    public static LoggingInfo getLogging(ResourceStore store) throws IOException {
        Resource f = store.get("logging.xml");
        if (f != null) {
            XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
            try (BufferedInputStream in = new BufferedInputStream(f.in());){
                LoggingInfo loginfo;
                LoggingInfo loggingInfo = loginfo = xp.load(in, LoggingInfo.class);
                return loggingInfo;
            }
        }
        return null;
    }

    Logger getLogger() {
        if (LOGGER == null) {
            LOGGER = Logging.getLogger((String)"org.geoserver.logging");
        }
        return LOGGER;
    }
}

