/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature.retype;

import org.geotools.data.Join;
import org.geotools.data.Query;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class FeatureTypeMap {
    String originalName;
    String name;
    SimpleFeatureType originalFeatureType;
    SimpleFeatureType featureType;

    public FeatureTypeMap(String originalName, String name) {
        this.originalName = originalName;
        this.name = name;
    }

    public FeatureTypeMap(SimpleFeatureType originalFeatureType, SimpleFeatureType featureType) {
        this.originalFeatureType = originalFeatureType;
        this.featureType = featureType;
        this.originalName = originalFeatureType.getTypeName();
        this.name = featureType.getTypeName();
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getName() {
        return this.name;
    }

    public SimpleFeatureType getOriginalFeatureType() {
        return this.originalFeatureType;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public SimpleFeatureType getFeatureType(Query query) {
        SimpleFeatureType result = query.getPropertyNames() != Query.ALL_NAMES ? SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.featureType, (String[])query.getPropertyNames()) : this.featureType;
        if (!query.getJoins().isEmpty()) {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.init(result);
            for (Join join : query.getJoins()) {
                String joinedFeatureAttribute = join.getAlias();
                if (joinedFeatureAttribute == null) {
                    joinedFeatureAttribute = join.getTypeName();
                }
                tb.add(joinedFeatureAttribute, SimpleFeature.class);
            }
            result = tb.buildFeatureType();
        }
        return result;
    }

    public boolean isUnchanged() {
        return this.originalName.equals(this.name);
    }

    public void setFeatureTypes(SimpleFeatureType original, SimpleFeatureType transformed) {
        this.originalFeatureType = original;
        this.featureType = transformed;
    }
}

