/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class FlatteningFeatureCollection
extends DecoratingSimpleFeatureCollection {
    private SimpleFeatureType flattenedType;

    private FlatteningFeatureCollection(SimpleFeatureCollection delegate, SimpleFeatureType flattenedType) {
        super(delegate);
        this.flattenedType = flattenedType;
    }

    public static SimpleFeatureCollection flatten(SimpleFeatureCollection collection) {
        SimpleFeatureType schema = (SimpleFeatureType)collection.getSchema();
        ArrayList<AttributeDescriptor> attributeDescriptors = new ArrayList<AttributeDescriptor>();
        FlatteningFeatureCollection.scanAttributeDescriptors(attributeDescriptors, schema, null);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(schema.getName());
        for (AttributeDescriptor desc : attributeDescriptors) {
            builder.add(desc);
        }
        SimpleFeatureType flattenedType = builder.buildFeatureType();
        if (((SimpleFeatureType)collection.getSchema()).getAttributeCount() == flattenedType.getAttributeCount()) {
            return collection;
        }
        return new FlatteningFeatureCollection(collection, flattenedType);
    }

    private static void scanAttributeDescriptors(List<AttributeDescriptor> attributeDescriptors, SimpleFeatureType featureType, String attrAlias) {
        List descriptors = featureType.getAttributeDescriptors();
        for (int i = 0; i < descriptors.size(); ++i) {
            AttributeDescriptor ad = (AttributeDescriptor)descriptors.get(i);
            SimpleFeatureType joinedSchema = (SimpleFeatureType)ad.getUserData().get("JoinedFeatureType");
            String name = (attrAlias != null ? attrAlias + "." : "") + ad.getLocalName();
            if (joinedSchema != null) {
                FlatteningFeatureCollection.scanAttributeDescriptors(attributeDescriptors, joinedSchema, name);
                continue;
            }
            AttributeTypeBuilder build = new AttributeTypeBuilder();
            build.init(ad);
            AttributeDescriptor descriptor = build.buildDescriptor(name);
            attributeDescriptors.add(descriptor);
        }
    }

    public SimpleFeatureType getSchema() {
        return this.flattenedType;
    }

    public SimpleFeatureIterator features() {
        return new FlatteningFeatureIterator(this.delegate.features(), this.flattenedType);
    }

    class FlatteningFeatureIterator
    implements SimpleFeatureIterator {
        private SimpleFeatureIterator delegate;
        private SimpleFeatureBuilder builder;

        public FlatteningFeatureIterator(SimpleFeatureIterator delegate, SimpleFeatureType flattenedType) {
            this.delegate = delegate;
            this.builder = new SimpleFeatureBuilder(flattenedType);
        }

        public void close() {
            this.delegate.close();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature next = (SimpleFeature)this.delegate.next();
            this.accumulateAttributes(next);
            return this.builder.buildFeature(next.getID());
        }

        private void accumulateAttributes(SimpleFeature feature) {
            for (int i = 0; i < feature.getAttributes().size(); ++i) {
                Object attr = feature.getAttribute(i);
                if (attr instanceof SimpleFeature) {
                    this.accumulateAttributes((SimpleFeature)attr);
                    continue;
                }
                this.builder.add(attr);
            }
        }
    }
}

