/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.geotools.data.CloseableIterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CompositeFeatureCollection
extends DataFeatureCollection {
    List<FeatureCollection> collections;
    SimpleFeatureType schema;

    public CompositeFeatureCollection(List collections) {
        this.collections = collections;
    }

    public CompositeFeatureCollection(List collections, SimpleFeatureType schema) {
        this.collections = collections;
        this.schema = schema;
    }

    protected Iterator openIterator() throws IOException {
        return new CompositeIterator();
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public ReferencedEnvelope getBounds() {
        Function<FeatureCollection, ReferencedEnvelope> mapper = c -> {
            ReferencedEnvelope envelope = c.getBounds();
            if (envelope == null) {
                return DataUtilities.bounds((FeatureCollection)c);
            }
            return envelope;
        };
        return this.collections.stream().map(mapper).reduce((e1, e2) -> {
            CoordinateReferenceSystem crs2;
            CoordinateReferenceSystem crs1 = e1.getCoordinateReferenceSystem();
            if (crs1 != (crs2 = e2.getCoordinateReferenceSystem()) && !CRS.equalsIgnoreMetadata((Object)crs1, (Object)crs2)) {
                throw new RuntimeException("Two collections are returning different CRSs, cannot perform this accumulation (yet): \n" + crs1 + "\n" + crs2);
            }
            e1.expandToInclude((Envelope)e2);
            return e1;
        }).orElse(null);
    }

    public int getCount() throws IOException {
        return this.collections.stream().mapToInt(c -> {
            int size = c.size();
            if (size < 0) {
                size = DataUtilities.count((FeatureCollection)c);
            }
            return size;
        }).sum();
    }

    public Object[] toArray(Object[] arg0) {
        ArrayList<FeatureCollection> list2 = new ArrayList<FeatureCollection>();
        Iterator<FeatureCollection> it = this.collections.iterator();
        while (it.hasNext()) {
            FeatureCollection col = it.next();
            FeatureIterator it2 = col.features();
            while (it2.hasNext()) {
                list2.add(it.next());
            }
            it2.close();
        }
        return list2.toArray(arg0);
    }

    public FeatureId getIdentifier() {
        throw new RuntimeException("Can't get the id for a composite featurecollection; you need to identify the consituent collections directly.");
    }

    public List<FeatureCollection> getCollections() {
        return this.collections;
    }

    class CompositeIterator
    implements CloseableIterator {
        int index = 0;
        FeatureIterator iterator;

        public void remove() {
        }

        public boolean hasNext() {
            if (this.iterator != null && this.iterator.hasNext()) {
                return true;
            }
            while (this.index < CompositeFeatureCollection.this.collections.size()) {
                if (this.iterator != null) {
                    this.iterator.close();
                }
                this.iterator = CompositeFeatureCollection.this.collections.get(this.index++).features();
                if (!this.iterator.hasNext()) continue;
                return true;
            }
            if (this.iterator != null) {
                this.iterator.close();
            }
            return false;
        }

        public Object next() {
            return this.iterator.next();
        }

        public void close() throws IOException {
            if (this.iterator instanceof Closeable) {
                this.iterator.close();
            }
        }
    }
}

