/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.geotools.data.jdbc.datasource.UnWrapper;
import org.springframework.jdbc.support.nativejdbc.C3P0NativeJdbcExtractor;
import org.springframework.jdbc.support.nativejdbc.CommonsDbcpNativeJdbcExtractor;
import org.springframework.jdbc.support.nativejdbc.JBossNativeJdbcExtractor;
import org.springframework.jdbc.support.nativejdbc.Jdbc4NativeJdbcExtractor;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.jdbc.support.nativejdbc.SimpleNativeJdbcExtractor;
import org.springframework.jdbc.support.nativejdbc.WebLogicNativeJdbcExtractor;
import org.springframework.jdbc.support.nativejdbc.WebSphereNativeJdbcExtractor;

public class SpringUnWrapper
implements UnWrapper {
    static final List<NativeJdbcExtractor> EXTRACTORS;

    public boolean canUnwrap(Connection conn) {
        Connection unwrapped = this.unwrapInternal(conn);
        return unwrapped != null;
    }

    public Connection unwrap(Connection conn) {
        Connection unwrapped = this.unwrapInternal(conn);
        if (unwrapped != null) {
            return unwrapped;
        }
        throw new IllegalArgumentException("This connection is not unwrappable, check canUnwrap before calling unwrap");
    }

    private Connection unwrapInternal(Connection conn) {
        for (int i = 0; i < EXTRACTORS.size(); ++i) {
            NativeJdbcExtractor extractor = EXTRACTORS.get(i);
            try {
                Connection unwrapped = extractor.getNativeConnection(conn);
                if (conn == unwrapped) continue;
                if (i != 0) {
                    EXTRACTORS.add(0, extractor);
                    EXTRACTORS.remove(i);
                }
                return unwrapped;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean canUnwrap(Statement st) {
        Statement unwrapped = this.unwrapInternal(st);
        return unwrapped != null;
    }

    public Statement unwrap(Statement statement) {
        Statement unwrapped = this.unwrapInternal(statement);
        if (unwrapped != null) {
            return unwrapped;
        }
        throw new IllegalArgumentException("This statement is not unwrappable, check canUnwrap before calling unwrap");
    }

    private Statement unwrapInternal(Statement st) {
        for (int i = 0; i < EXTRACTORS.size(); ++i) {
            NativeJdbcExtractor extractor = EXTRACTORS.get(i);
            try {
                Statement unwrapped = extractor.getNativeStatement(st);
                if (st == unwrapped) continue;
                if (i != 0) {
                    EXTRACTORS.add(0, extractor);
                    EXTRACTORS.remove(i);
                }
                return unwrapped;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        ArrayList<Object> extractors = new ArrayList<Object>();
        try {
            extractors.add(new CommonsDbcpNativeJdbcExtractor());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            extractors.add(new JBossNativeJdbcExtractor());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            extractors.add(new Jdbc4NativeJdbcExtractor());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            extractors.add(new SimpleNativeJdbcExtractor());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            extractors.add(new WebLogicNativeJdbcExtractor());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            extractors.add(new WebSphereNativeJdbcExtractor());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            extractors.add(new C3P0NativeJdbcExtractor());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EXTRACTORS = new CopyOnWriteArrayList<NativeJdbcExtractor>(extractors);
    }
}

