/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.coverage;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.CoverageAccessInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.impl.CoverageAccessInfoImpl;
import org.geoserver.platform.ExtensionPriority;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.image.io.ImageIOExt;

public class CoverageAccessInitializer
implements GeoServerInitializer,
ExtensionPriority {
    GeoServer gs;

    @Override
    public void initialize(GeoServer geoServer) throws Exception {
        this.gs = geoServer;
        GeoServerInfo geoserverInfo = geoServer.getGlobal();
        CoverageAccessInfo coverageAccess = geoserverInfo.getCoverageAccess();
        if (coverageAccess == null) {
            coverageAccess = new CoverageAccessInfoImpl();
            geoserverInfo.setCoverageAccess(coverageAccess);
        }
        this.initCoverage(coverageAccess);
        geoServer.addListener(new ConfigurationListenerAdapter(){

            @Override
            public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                if (propertyNames.contains("coverageAccess")) {
                    CoverageAccessInitializer.this.initCoverage(global.getCoverageAccess());
                }
            }

            @Override
            public void handlePostGlobalChange(GeoServerInfo global) {
            }
        });
    }

    void initCoverage(CoverageAccessInfo coverageAccess) {
        if (coverageAccess != null) {
            Hints defHints;
            ThreadPoolExecutor executor = coverageAccess.getThreadPoolExecutor();
            if (executor == null && (defHints = GeoTools.getDefaultHints()) != null && defHints.containsKey((Object)Hints.EXECUTOR_SERVICE)) {
                executor = (ThreadPoolExecutor)defHints.get((Object)Hints.EXECUTOR_SERVICE);
            }
            if (executor == null) {
                executor = new ThreadPoolExecutor(coverageAccess.getCorePoolSize(), coverageAccess.getMaxPoolSize(), coverageAccess.getKeepAliveTime(), TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)(coverageAccess.getQueueType() == CoverageAccessInfo.QueueType.UNBOUNDED ? new LinkedBlockingQueue() : new SynchronousQueue())));
                coverageAccess.setThreadPoolExecutor(executor);
            } else {
                BlockingQueue<Runnable> queue = executor.getQueue();
                CoverageAccessInfo.QueueType queueType = coverageAccess.getQueueType();
                if (queue instanceof LinkedBlockingQueue && queueType == CoverageAccessInfo.QueueType.UNBOUNDED || queue instanceof SynchronousQueue && queueType == CoverageAccessInfo.QueueType.DIRECT) {
                    executor.setCorePoolSize(coverageAccess.getCorePoolSize());
                    executor.setMaximumPoolSize(coverageAccess.getMaxPoolSize());
                    executor.setKeepAliveTime(coverageAccess.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                    coverageAccess.setThreadPoolExecutor(executor);
                } else {
                    executor.shutdown();
                    if (!executor.isTerminated()) {
                        executor.shutdownNow();
                    }
                    executor = new ThreadPoolExecutor(coverageAccess.getCorePoolSize(), coverageAccess.getMaxPoolSize(), coverageAccess.getKeepAliveTime(), TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)(coverageAccess.getQueueType() == CoverageAccessInfo.QueueType.DIRECT ? new SynchronousQueue() : new LinkedBlockingQueue())));
                    coverageAccess.setThreadPoolExecutor(executor);
                }
            }
            this.gs.getCatalog().getResourcePool().setCoverageExecutor(executor);
            ImageIOExt.setFilesystemThreshold((Long)(coverageAccess.getImageIOCacheThreshold() * 1024L));
        }
    }

    public int getPriority() {
        return 0;
    }
}

