/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.impl;

import java.io.Serializable;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import org.geoserver.config.JAIEXTInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.config.impl.JAIEXTInfoImpl;

public class JAIInfoImpl
implements Serializable,
JAIInfo {
    public static final String KEY = "jai.info";
    private static final long serialVersionUID = 7121137497699361776L;
    boolean allowInterpolation;
    public static final boolean DEFAULT_Recycling = false;
    boolean recycling = false;
    public static final int DEFAULT_TilePriority = 5;
    int tilePriority = 5;
    public static final int DEFAULT_TileThreads = 7;
    int tileThreads = 7;
    public static final double DEFAULT_MemoryCapacity = 0.5;
    double memoryCapacity = 0.5;
    public static final double DEFAULT_MemoryThreshold = 0.75;
    double memoryThreshold = 0.75;
    public static final boolean DEFAULT_ImageIOCache = false;
    boolean imageIOCache = false;
    public static final boolean DEFAULT_PNGNative = false;
    boolean pngAcceleration = false;
    public static final boolean DEFAULT_JPEGNative = false;
    boolean jpegAcceleration = false;
    public static final boolean DEFAULT_MosaicNative = false;
    boolean allowNativeMosaic = false;
    public static final boolean DEFAULT_WarpNative = false;
    boolean allowNativeWarp = false;
    JAIInfo.PngEncoderType pngEncoderType = JAIInfo.PngEncoderType.PNGJ;
    JAIEXTInfo jaiext = new JAIEXTInfoImpl();

    @Override
    public boolean getAllowInterpolation() {
        return this.allowInterpolation;
    }

    @Override
    public void setAllowInterpolation(boolean allowInterpolation) {
        this.allowInterpolation = allowInterpolation;
    }

    @Override
    public boolean isRecycling() {
        return this.recycling;
    }

    @Override
    public void setRecycling(boolean recycling) {
        this.recycling = recycling;
    }

    @Override
    public int getTilePriority() {
        return this.tilePriority;
    }

    @Override
    public void setTilePriority(int tilePriority) {
        this.tilePriority = tilePriority;
    }

    @Override
    public int getTileThreads() {
        return this.tileThreads;
    }

    @Override
    public void setTileThreads(int tileThreads) {
        this.tileThreads = tileThreads;
    }

    @Override
    public double getMemoryCapacity() {
        return this.memoryCapacity;
    }

    @Override
    public void setMemoryCapacity(double memoryCapacity) {
        this.memoryCapacity = memoryCapacity;
    }

    @Override
    public double getMemoryThreshold() {
        return this.memoryThreshold;
    }

    @Override
    public void setMemoryThreshold(double memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    @Override
    public boolean isPngAcceleration() {
        return this.pngAcceleration;
    }

    @Override
    public void setPngAcceleration(boolean pngAcceleration) {
        this.pngAcceleration = pngAcceleration;
    }

    @Override
    public boolean isJpegAcceleration() {
        return this.jpegAcceleration;
    }

    @Override
    public void setJpegAcceleration(boolean jpegAcceleration) {
        this.jpegAcceleration = jpegAcceleration;
    }

    @Override
    public void setImageIOCache(boolean imageIOCache) {
        this.imageIOCache = imageIOCache;
    }

    @Override
    public boolean isImageIOCache() {
        return this.imageIOCache;
    }

    @Override
    public JAI getJAI() {
        return JAI.getDefaultInstance();
    }

    @Override
    public void setJAI(JAI jai) {
    }

    @Override
    public TileCache getTileCache() {
        return this.getJAI().getTileCache();
    }

    @Override
    public void setTileCache(TileCache tileCache) {
    }

    @Override
    public boolean isAllowNativeMosaic() {
        return this.allowNativeMosaic;
    }

    @Override
    public void setAllowNativeMosaic(boolean allowNativeMosaic) {
        this.allowNativeMosaic = allowNativeMosaic;
    }

    @Override
    public boolean isAllowNativeWarp() {
        return this.allowNativeWarp;
    }

    @Override
    public void setAllowNativeWarp(boolean allowNativeWarp) {
        this.allowNativeWarp = allowNativeWarp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowInterpolation ? 1231 : 1237);
        result = 31 * result + (this.allowNativeMosaic ? 1231 : 1237);
        result = 31 * result + (this.allowNativeWarp ? 1231 : 1237);
        result = 31 * result + (this.imageIOCache ? 1231 : 1237);
        result = 31 * result + (this.jpegAcceleration ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.memoryCapacity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.memoryThreshold);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.pngAcceleration ? 1231 : 1237);
        result = 31 * result + (this.recycling ? 1231 : 1237);
        result = 31 * result + this.tilePriority;
        result = 31 * result + this.tileThreads;
        result = 31 * result + this.getPngEncoderType().hashCode();
        result = 31 * result + this.getPngEncoderType().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JAIInfoImpl other = (JAIInfoImpl)obj;
        if (this.allowInterpolation != other.allowInterpolation) {
            return false;
        }
        if (this.allowNativeMosaic != other.allowNativeMosaic) {
            return false;
        }
        if (this.allowNativeWarp != other.allowNativeWarp) {
            return false;
        }
        if (this.imageIOCache != other.imageIOCache) {
            return false;
        }
        if (this.jpegAcceleration != other.jpegAcceleration) {
            return false;
        }
        if (Double.doubleToLongBits(this.memoryCapacity) != Double.doubleToLongBits(other.memoryCapacity)) {
            return false;
        }
        if (Double.doubleToLongBits(this.memoryThreshold) != Double.doubleToLongBits(other.memoryThreshold)) {
            return false;
        }
        if (this.pngAcceleration != other.pngAcceleration) {
            return false;
        }
        if (this.recycling != other.recycling) {
            return false;
        }
        if (this.tilePriority != other.tilePriority) {
            return false;
        }
        if (this.tileThreads != other.tileThreads) {
            return false;
        }
        return this.getPngEncoderType() == other.getPngEncoderType();
    }

    @Override
    public JAIInfoImpl clone() {
        try {
            return (JAIInfoImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JAIInfo.PngEncoderType getPngEncoderType() {
        if (this.pngEncoderType == null) {
            return JAIInfo.PngEncoderType.PNGJ;
        }
        return this.pngEncoderType;
    }

    @Override
    public void setPngEncoderType(JAIInfo.PngEncoderType pngEncoderType) {
        this.pngEncoderType = pngEncoderType;
    }

    @Override
    public JAIEXTInfo getJAIEXTInfo() {
        if (this.jaiext == null) {
            this.jaiext = new JAIEXTInfoImpl();
        }
        return this.jaiext;
    }

    @Override
    public void setJAIEXTInfo(JAIEXTInfo jaiext) {
        this.jaiext = jaiext;
    }
}

