/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.Wrapper;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.LocalWorkspaceCatalog;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFacade;
import org.geoserver.config.GeoServerFactory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerLoaderProxy;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.DefaultGeoServerFacade;
import org.geoserver.config.impl.GeoServerFactoryImpl;
import org.geoserver.config.impl.GeoServerLifecycleHandler;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GeoServerImpl
implements GeoServer,
ApplicationContextAware {
    private static final Logger LOGGER = Logging.getLogger(GeoServerImpl.class);
    GeoServerFactory factory = new GeoServerFactoryImpl(this);
    Catalog catalog;
    GeoServerFacade facade;
    List<ConfigurationListener> listeners = new ArrayList<ConfigurationListener>();

    public GeoServerImpl() {
        this.facade = new DefaultGeoServerFacade(this);
    }

    @Override
    public GeoServerFacade getFacade() {
        return this.facade;
    }

    public void setFacade(GeoServerFacade facade) {
        this.facade = facade;
        facade.setGeoServer(this);
    }

    @Override
    public GeoServerFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(GeoServerFactory factory) {
        this.factory = factory;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
        if (catalog instanceof LocalWorkspaceCatalog) {
            LocalWorkspaceCatalog lwCatalog = (LocalWorkspaceCatalog)catalog;
            lwCatalog.setGeoServer(this);
        }
    }

    @Override
    public GeoServerInfo getGlobal() {
        return this.facade.getGlobal();
    }

    @Override
    public void setGlobal(GeoServerInfo global) {
        this.facade.setGlobal(global);
        this.fireGlobalPostModified();
    }

    @Override
    public SettingsInfo getSettings() {
        SettingsInfo settings = null;
        if (LocalWorkspace.get() != null) {
            settings = this.getSettings(LocalWorkspace.get());
        }
        return settings != null ? settings : this.getGlobal().getSettings();
    }

    @Override
    public SettingsInfo getSettings(WorkspaceInfo workspace) {
        return this.facade.getSettings(workspace);
    }

    @Override
    public void add(SettingsInfo settings) {
        this.validate(settings);
        this.resolve(settings);
        WorkspaceInfo workspace = settings.getWorkspace();
        if (this.facade.getSettings(workspace) != null) {
            throw new IllegalArgumentException("Settings already exist for workspace '" + workspace.getName() + "'");
        }
        this.facade.add(settings);
        this.fireSettingsAdded(settings);
    }

    @Override
    public void save(SettingsInfo settings) {
        this.validate(settings);
        this.facade.save(settings);
        this.fireSettingsPostModified(settings);
    }

    @Override
    public void remove(SettingsInfo settings) {
        this.facade.remove(settings);
        this.fireSettingsRemoved(settings);
    }

    void validate(SettingsInfo settings) {
        WorkspaceInfo workspace = settings.getWorkspace();
        if (workspace == null) {
            throw new IllegalArgumentException("Settings must be part of a workspace");
        }
    }

    void resolve(SettingsInfo settings) {
        OwsUtils.resolveCollections((Object)settings);
    }

    void fireSettingsAdded(SettingsInfo settings) {
        for (ConfigurationListener l : this.listeners) {
            try {
                l.handleSettingsAdded(settings);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    @Override
    public void fireSettingsModified(SettingsInfo settings, List<String> changed, List oldValues, List newValues) {
        for (ConfigurationListener l : this.listeners) {
            try {
                l.handleSettingsModified(settings, changed, oldValues, newValues);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    void fireSettingsPostModified(SettingsInfo settings) {
        for (ConfigurationListener l : this.listeners) {
            try {
                l.handleSettingsPostModified(settings);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    void fireSettingsRemoved(SettingsInfo settings) {
        for (ConfigurationListener l : this.listeners) {
            try {
                l.handleSettingsRemoved(settings);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    @Override
    public LoggingInfo getLogging() {
        return this.facade.getLogging();
    }

    @Override
    public void setLogging(LoggingInfo logging) {
        this.facade.setLogging(logging);
        this.fireLoggingPostModified();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (this.factory instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.factory).setApplicationContext(context);
        }
    }

    @Override
    public void add(ServiceInfo service) {
        if (service.getId() != null && this.facade.getService(service.getId(), ServiceInfo.class) != null) {
            throw new IllegalArgumentException("service with id '" + service.getId() + "' already exists");
        }
        this.resolve(service);
        WorkspaceInfo workspace = service.getWorkspace();
        if (workspace != null && this.facade.getServiceByName(service.getName(), workspace, ServiceInfo.class) != null) {
            throw new IllegalArgumentException("service with name '" + service.getName() + "' already exists in workspace '" + workspace.getName() + "'");
        }
        this.facade.add(service);
        this.firePostServiceModified(service);
    }

    void resolve(ServiceInfo service) {
        OwsUtils.resolveCollections((Object)service);
    }

    public static <T> T unwrap(T obj) {
        return DefaultGeoServerFacade.unwrap(obj);
    }

    @Override
    public <T extends ServiceInfo> T getService(Class<T> clazz) {
        WorkspaceInfo ws = LocalWorkspace.get();
        T service = ws != null ? (T)this.facade.getService(ws, clazz) : null;
        T t = service = service != null ? service : (T)this.facade.getService(clazz);
        if (service == null) {
            LOGGER.log(Level.SEVERE, "Could not locate service of type " + clazz + ", local workspace is " + ws);
        }
        return service;
    }

    @Override
    public <T extends ServiceInfo> T getService(WorkspaceInfo workspace, Class<T> clazz) {
        return this.facade.getService(workspace, clazz);
    }

    @Override
    public <T extends ServiceInfo> T getService(String id, Class<T> clazz) {
        return this.facade.getService(id, clazz);
    }

    @Override
    public <T extends ServiceInfo> T getServiceByName(String name, Class<T> clazz) {
        T service = LocalWorkspace.get() != null ? (T)this.facade.getServiceByName(name, LocalWorkspace.get(), clazz) : null;
        return service != null ? service : (T)this.facade.getServiceByName(name, clazz);
    }

    @Override
    public <T extends ServiceInfo> T getServiceByName(WorkspaceInfo workspace, String name, Class<T> clazz) {
        return this.facade.getServiceByName(name, workspace, clazz);
    }

    @Override
    public Collection<? extends ServiceInfo> getServices() {
        Collection<? extends ServiceInfo> services = LocalWorkspace.get() != null ? this.facade.getServices(LocalWorkspace.get()) : null;
        return services != null ? services : this.facade.getServices();
    }

    @Override
    public Collection<? extends ServiceInfo> getServices(WorkspaceInfo workspace) {
        return this.facade.getServices(workspace);
    }

    @Override
    public void remove(ServiceInfo service) {
        this.facade.remove(service);
        this.fireServiceRemoved(service);
    }

    @Override
    public void save(GeoServerInfo geoServer) {
        this.facade.save(geoServer);
        this.fireGlobalPostModified();
    }

    @Override
    public void save(LoggingInfo logging) {
        this.facade.save(logging);
        this.fireLoggingPostModified();
    }

    void fireGlobalPostModified() {
        for (ConfigurationListener l : this.listeners) {
            try {
                l.handlePostGlobalChange(this.facade.getGlobal());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    @Override
    public void fireGlobalModified(GeoServerInfo global, List<String> changed, List oldValues, List newValues) {
        for (ConfigurationListener l : this.getListeners()) {
            try {
                l.handleGlobalChange(global, changed, oldValues, newValues);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    @Override
    public void fireLoggingModified(LoggingInfo logging, List<String> changed, List oldValues, List newValues) {
        for (ConfigurationListener l : this.getListeners()) {
            try {
                l.handleLoggingChange(logging, changed, oldValues, newValues);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    void fireLoggingPostModified() {
        for (ConfigurationListener l : this.listeners) {
            try {
                l.handlePostLoggingChange(this.facade.getLogging());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    @Override
    public void save(ServiceInfo service) {
        this.validate(service);
        this.facade.save(service);
        this.firePostServiceModified(service);
    }

    void validate(ServiceInfo service) {
        CatalogImpl.validateKeywords(service.getKeywords());
    }

    @Override
    public void fireServiceModified(ServiceInfo service, List<String> changed, List oldValues, List newValues) {
        for (ConfigurationListener l : this.getListeners()) {
            try {
                l.handleServiceChange(service, changed, oldValues, newValues);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    void firePostServiceModified(ServiceInfo service) {
        for (ConfigurationListener l : this.listeners) {
            try {
                l.handlePostServiceChange(service);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    void fireServiceRemoved(ServiceInfo service) {
        for (ConfigurationListener l : this.getListeners()) {
            try {
                l.handleServiceRemove(service);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    @Override
    public void addListener(ConfigurationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ConfigurationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Collection<ConfigurationListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void dispose() {
        for (GeoServerLifecycleHandler handler : GeoServerExtensions.extensions(GeoServerLifecycleHandler.class)) {
            try {
                handler.onDispose();
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "A GeoServer lifecycle handler threw an exception during dispose", t);
            }
        }
        if (this.catalog != null) {
            this.catalog.dispose();
        }
        if (this.facade != null) {
            this.facade.dispose();
        }
    }

    @Override
    public void reload() throws Exception {
        this.reload(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload(Catalog newCatalog) throws Exception {
        List handlers = GeoServerExtensions.extensions(GeoServerLifecycleHandler.class);
        for (Object handler : handlers) {
            try {
                handler.beforeReload();
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "A GeoServer lifecycle handler threw an exception during reload", t);
            }
        }
        try {
            Object handler;
            this.reset();
            GeoServerLoaderProxy loader = (GeoServerLoaderProxy)GeoServerExtensions.bean(GeoServerLoaderProxy.class);
            handler = GeoServer.CONFIGURATION_LOCK;
            synchronized (handler) {
                this.getCatalog().getResourcePool().dispose();
                if (newCatalog != null) {
                    this.dispose();
                    Catalog catalog = this.getCatalog();
                    if (catalog instanceof Wrapper) {
                        catalog = (Catalog)((Wrapper)((Object)this.getCatalog())).unwrap(Catalog.class);
                    }
                    ((CatalogImpl)catalog).sync((CatalogImpl)newCatalog);
                    ((CatalogImpl)catalog).resolve();
                } else {
                    loader.reload();
                }
            }
        }
        finally {
            for (Object handler : handlers) {
                try {
                    handler.onReload();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "A GeoServer lifecycle handler threw an exception during reload", t);
                }
            }
        }
    }

    @Override
    public void reset() {
        this.catalog.getResourcePool().dispose();
        CRS.reset((String)"all");
        for (GeoServerLifecycleHandler handler : GeoServerExtensions.extensions(GeoServerLifecycleHandler.class)) {
            try {
                handler.onReset();
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "A GeoServer lifecycle handler threw an exception during reset", t);
            }
        }
    }
}

