/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.Wrapper;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.util.LegacyCatalogImporter;
import org.geoserver.catalog.util.LegacyCatalogReader;
import org.geoserver.catalog.util.LegacyFeatureTypeInfoReader;
import org.geoserver.config.AsynchResourceIterator;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerConfigPersister;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.GeoServerReinitializer;
import org.geoserver.config.GeoServerResourcePersister;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.util.LegacyConfigurationImporter;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.util.Filter;
import org.geoserver.util.IOUtils;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public abstract class GeoServerLoader {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver");
    static final ResourceLayerMapper FEATURE_LAYER_MAPPER = new ResourceLayerMapper("featuretype.xml", "feature type");
    static final ResourceLayerMapper COVERAGE_LAYER_MAPPER = new ResourceLayerMapper("coverage.xml", "coverage");
    static final ResourceLayerMapper WMS_LAYER_MAPPER = new ResourceLayerMapper("wmslayer.xml", "wms layer");
    static final ResourceLayerMapper WMTS_LAYER_MAPPER = new ResourceLayerMapper("wmtslayer.xml", "wmts layer");
    static final Resources.ExtensionFilter XML_FILTER = new Resources.ExtensionFilter(new String[]{"XML"});
    protected GeoServerResourceLoader resourceLoader;
    GeoServer geoserver;
    XStreamPersisterFactory xpf = new XStreamPersisterFactory();
    static boolean legacy = false;

    public GeoServerLoader(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }

    public void setXStreamPeristerFactory(XStreamPersisterFactory xpf) {
        this.xpf = xpf;
    }

    public static void setLegacy(boolean legacy) {
        GeoServerLoader.legacy = legacy;
    }

    public final Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public final Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Catalog) {
            if (bean instanceof Wrapper && ((Wrapper)bean).isWrapperFor(Catalog.class)) {
                return bean;
            }
            try {
                Catalog catalog = (Catalog)bean;
                XStreamPersister xp = this.xpf.createXMLPersister();
                xp.setCatalog(catalog);
                this.loadCatalog(catalog, xp);
                this.initializeStyles(catalog, xp);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (bean instanceof GeoServer) {
            this.geoserver = (GeoServer)bean;
            try {
                XStreamPersister xp = this.xpf.createXMLPersister();
                xp.setCatalog(this.geoserver.getCatalog());
                this.loadGeoServer(this.geoserver, xp);
                this.loadInitializers(this.geoserver);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return bean;
    }

    protected abstract void loadCatalog(Catalog var1, XStreamPersister var2) throws Exception;

    protected abstract void loadGeoServer(GeoServer var1, XStreamPersister var2) throws Exception;

    protected void loadInitializers(GeoServer geoServer) throws Exception {
        List initializers = GeoServerExtensions.extensions(GeoServerInitializer.class);
        for (GeoServerInitializer initer : initializers) {
            try {
                initer.initialize(geoServer);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "Failed to run initializer " + initer, t);
            }
        }
    }

    protected void reloadInitializers(GeoServer geoServer) throws Exception {
        List initializers = GeoServerExtensions.extensions(GeoServerReinitializer.class);
        for (GeoServerReinitializer initer : initializers) {
            try {
                initer.reinitialize(geoServer);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "Failed to run initializer " + initer, t);
            }
        }
    }

    protected void initializeStyles(Catalog catalog, XStreamPersister xp) throws IOException {
        if (catalog.getStyleByName("point") == null) {
            this.initializeStyle(catalog, "point", "default_point.sld");
        }
        if (catalog.getStyleByName("line") == null) {
            this.initializeStyle(catalog, "line", "default_line.sld");
        }
        if (catalog.getStyleByName("polygon") == null) {
            this.initializeStyle(catalog, "polygon", "default_polygon.sld");
        }
        if (catalog.getStyleByName("raster") == null) {
            this.initializeStyle(catalog, "raster", "default_raster.sld");
        }
        if (catalog.getStyleByName("generic") == null) {
            this.initializeStyle(catalog, "generic", "default_generic.sld");
        }
    }

    void initializeStyle(Catalog catalog, String styleName, String sld) throws IOException {
        Resource styleResource = this.resourceLoader.get(Paths.path((String[])new String[]{"styles", sld}));
        if (!Resources.exists((Resource)styleResource)) {
            try (InputStream in = GeoServerLoader.class.getResourceAsStream(sld);
                 OutputStream out = styleResource.out();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        StyleInfo s = catalog.getFactory().createStyle();
        s.setName(styleName);
        s.setFilename(sld);
        catalog.add(s);
    }

    public void reload() throws Exception {
        this.destroy();
        Catalog catalog = this.geoserver.getCatalog();
        if (catalog instanceof Wrapper) {
            catalog = (Catalog)((Wrapper)((Object)this.geoserver.getCatalog())).unwrap(Catalog.class);
        }
        XStreamPersister xp = this.xpf.createXMLPersister();
        xp.setCatalog(catalog);
        this.loadCatalog(catalog, xp);
        this.loadGeoServer(this.geoserver, xp);
        this.reloadInitializers(this.geoserver);
    }

    protected void readCatalog(Catalog catalog, XStreamPersister xp) throws Exception {
        CatalogImpl catalog2;
        catalog.removeListeners(ResourcePool.CacheClearingListener.class);
        catalog.removeListeners(GeoServerConfigPersister.class);
        catalog.removeListeners(GeoServerResourcePersister.class);
        ArrayList<CatalogListener> listeners = new ArrayList<CatalogListener>(catalog.getListeners());
        Resource f = this.resourceLoader.get("catalog.xml");
        if (!Resources.exists((Resource)f)) {
            catalog2 = (CatalogImpl)this.readCatalog(xp);
            ((CatalogImpl)catalog).sync(catalog2);
        } else {
            catalog2 = (CatalogImpl)this.readLegacyCatalog(f, xp);
            ((CatalogImpl)catalog).sync(catalog2);
        }
        for (CatalogListener listener : listeners) {
            catalog.addListener(listener);
        }
    }

    boolean checkStoresOnStartup(XStreamPersister xp) {
        Resource f = this.resourceLoader.get("global.xml");
        if (Resources.exists((Resource)f)) {
            try {
                GeoServerInfo global = this.depersist(xp, f, GeoServerInfo.class);
                ResourceErrorHandling resourceErrorHandling = global.getResourceErrorHandling();
                return resourceErrorHandling != null && !ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)resourceErrorHandling);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Failed to determine the capabilities resource error handling", e);
            }
        }
        return true;
    }

    Catalog readCatalog(XStreamPersister xp) throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        catalog.setResourceLoader(this.resourceLoader);
        xp.setCatalog(catalog);
        xp.setUnwrapNulls(false);
        boolean checkStores = this.checkStoresOnStartup(xp);
        if (!checkStores) {
            catalog.setExtendedValidation(false);
        }
        this.loadStyles(this.resourceLoader.get("styles"), catalog, xp);
        Resource workspaces = this.resourceLoader.get("workspaces");
        if (Resources.exists((Resource)workspaces)) {
            Resource dws = workspaces.get("default.xml");
            WorkspaceInfo defaultWorkspace = null;
            if (Resources.exists((Resource)dws)) {
                try {
                    defaultWorkspace = this.depersist(xp, dws, WorkspaceInfo.class);
                    LOGGER.info("Loaded default workspace " + defaultWorkspace.getName());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to load default workspace", e);
                }
            } else {
                LOGGER.warning("No default workspace was found.");
            }
            List workspaceList = workspaces.list().parallelStream().filter(r -> Resources.DirectoryFilter.INSTANCE.accept(r)).collect(Collectors.toList());
            AsynchResourceIterator<WorkspaceContents> it = new AsynchResourceIterator<WorkspaceContents>(workspaces, (Filter<Resource>)Resources.DirectoryFilter.INSTANCE, new WorkspaceMapper());
            Object object = null;
            try {
                while (it.hasNext()) {
                    Resource styles;
                    WorkspaceInfo ws;
                    Resource workspaceResource;
                    WorkspaceContents wc;
                    block51: {
                        wc = it.next();
                        workspaceResource = wc.resource;
                        try {
                            ws = GeoServerLoader.depersist(xp, wc.contents, WorkspaceInfo.class);
                            catalog.add(ws);
                            if (!LOGGER.isLoggable(Level.INFO)) break block51;
                            LOGGER.info("Loaded workspace '" + ws.getName() + "'");
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Failed to load workspace '" + workspaceResource.name() + "'", e);
                            continue;
                        }
                    }
                    NamespaceInfo ns = null;
                    try {
                        ns = GeoServerLoader.depersist(xp, wc.nsContents, NamespaceInfo.class);
                        catalog.add(ns);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Failed to load namespace for '" + workspaceResource.name() + "'", e);
                    }
                    if (defaultWorkspace != null) {
                        if (ws.getName().equals(defaultWorkspace.getName())) {
                            catalog.setDefaultWorkspace(ws);
                            if (ns != null) {
                                catalog.setDefaultNamespace(ns);
                            }
                        }
                    } else {
                        defaultWorkspace = catalog.getDefaultWorkspace();
                        if (defaultWorkspace != null) {
                            try {
                                this.persist(xp, defaultWorkspace, dws);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.WARNING, "Failed to persist default workspace '" + workspaceResource.name() + "'", e);
                            }
                        }
                    }
                    if ((styles = workspaceResource.get("styles")) == null) continue;
                    this.loadStyles(styles, catalog, xp);
                }
            }
            catch (Throwable wc) {
                object = wc;
                throw wc;
            }
            finally {
                if (it != null) {
                    if (object != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable wc) {
                            ((Throwable)object).addSuppressed(wc);
                        }
                    } else {
                        it.close();
                    }
                }
            }
            AsynchResourceIterator.ResourceMapper<StoreContents> storeMapper = sd -> {
                Resource f = sd.get("datastore.xml");
                if (Resources.exists((Resource)f)) {
                    return new StoreContents(f, f.getContents());
                }
                f = sd.get("coveragestore.xml");
                if (Resources.exists((Resource)f)) {
                    return new StoreContents(f, f.getContents());
                }
                f = sd.get("wmsstore.xml");
                if (Resources.exists((Resource)f)) {
                    return new StoreContents(f, f.getContents());
                }
                f = sd.get("wmtsstore.xml");
                if (Resources.exists((Resource)f)) {
                    return new StoreContents(f, f.getContents());
                }
                if (!this.isConfigDirectory(sd)) {
                    LOGGER.warning("Ignoring store directory '" + sd.name() + "'");
                }
                return null;
            };
            for (Resource wsd : workspaceList) {
                try (AsynchResourceIterator<StoreContents> it2 = new AsynchResourceIterator<StoreContents>(wsd, (Filter<Resource>)Resources.DirectoryFilter.INSTANCE, storeMapper);){
                    while (it2.hasNext()) {
                        StoreContents storeContents = it2.next();
                        String resourceName = storeContents.resource.name();
                        if ("datastore.xml".equals(resourceName)) {
                            this.loadDataStore(storeContents, catalog, xp, checkStores);
                            continue;
                        }
                        if ("coveragestore.xml".equals(resourceName)) {
                            this.loadCoverageStore(storeContents, catalog, xp);
                            continue;
                        }
                        if ("wmsstore.xml".equals(resourceName)) {
                            this.loadWmsStore(storeContents, catalog, xp);
                            continue;
                        }
                        if ("wmtsstore.xml".equals(resourceName)) {
                            this.loadWmtsStore(storeContents, catalog, xp);
                            continue;
                        }
                        if (this.isConfigDirectory(storeContents.resource)) continue;
                        LOGGER.warning("Ignoring store directory '" + storeContents.resource.name() + "'");
                    }
                }
                Resource layergroups = wsd.get("layergroups");
                if (layergroups == null) continue;
                this.loadLayerGroups(layergroups, catalog, xp);
            }
        } else {
            LOGGER.warning("No 'workspaces' directory found, unable to load any stores.");
        }
        Resource layergroups = this.resourceLoader.get("layergroups");
        if (layergroups != null) {
            this.loadLayerGroups(layergroups, catalog, xp);
        }
        xp.setUnwrapNulls(true);
        catalog.resolve();
        if (!checkStores) {
            catalog.setExtendedValidation(true);
        }
        return catalog;
    }

    private void loadWmsStore(StoreContents storeContents, CatalogImpl catalog, XStreamPersister xp) {
        Resource storeResource = storeContents.resource;
        WMSStoreInfo wms = null;
        try {
            wms = GeoServerLoader.depersist(xp, storeContents.contents, WMSStoreInfo.class);
            catalog.add(wms);
            LOGGER.info("Loaded wmsstore '" + wms.getName() + "', " + (wms.isEnabled() ? "enabled" : "disabled"));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to load wms store '" + storeResource.name() + "'", e);
            return;
        }
        LayerLoader<WMSLayerInfo> coverageLoader = new LayerLoader<WMSLayerInfo>(WMSLayerInfo.class, xp, catalog);
        try (AsynchResourceIterator<LayerContents> it = new AsynchResourceIterator<LayerContents>(storeResource.parent(), (Filter<Resource>)Resources.DirectoryFilter.INSTANCE, WMS_LAYER_MAPPER);){
            while (it.hasNext()) {
                LayerContents lc = it.next();
                coverageLoader.accept(lc);
            }
        }
    }

    private void loadWmtsStore(StoreContents storeContents, CatalogImpl catalog, XStreamPersister xp) {
        Resource storeResource = storeContents.resource;
        WMTSStoreInfo wmts = null;
        try {
            wmts = GeoServerLoader.depersist(xp, storeContents.contents, WMTSStoreInfo.class);
            catalog.add(wmts);
            LOGGER.info("Loaded wmtsstore '" + wmts.getName() + "'");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to load wmts store '" + storeResource.name() + "'", e);
            return;
        }
        LayerLoader<WMTSLayerInfo> coverageLoader = new LayerLoader<WMTSLayerInfo>(WMTSLayerInfo.class, xp, catalog);
        try (AsynchResourceIterator<LayerContents> it = new AsynchResourceIterator<LayerContents>(storeResource.parent(), (Filter<Resource>)Resources.DirectoryFilter.INSTANCE, WMTS_LAYER_MAPPER);){
            while (it.hasNext()) {
                LayerContents lc = it.next();
                coverageLoader.accept(lc);
            }
        }
    }

    private void loadCoverageStore(StoreContents storeContents, CatalogImpl catalog, XStreamPersister xp) {
        CoverageStoreInfo cs = null;
        Resource storeResource = storeContents.resource;
        try {
            cs = GeoServerLoader.depersist(xp, storeContents.contents, CoverageStoreInfo.class);
            catalog.add(cs);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Loaded coverage store '" + cs.getName() + "', " + (cs.isEnabled() ? "enabled" : "disabled"));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to load coverage store '" + storeResource.name() + "'", e);
            return;
        }
        LayerLoader<CoverageInfo> coverageLoader = new LayerLoader<CoverageInfo>(CoverageInfo.class, xp, catalog);
        try (AsynchResourceIterator<LayerContents> it = new AsynchResourceIterator<LayerContents>(storeResource.parent(), (Filter<Resource>)Resources.DirectoryFilter.INSTANCE, COVERAGE_LAYER_MAPPER);){
            while (it.hasNext()) {
                LayerContents lc = it.next();
                coverageLoader.accept(lc);
            }
        }
    }

    private void loadDataStore(StoreContents storeContents, CatalogImpl catalog, XStreamPersister xp, boolean checkStores) {
        Resource storeResource = storeContents.resource;
        try {
            DataStoreInfo ds = GeoServerLoader.depersist(xp, storeContents.contents, DataStoreInfo.class);
            catalog.add(ds);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Loaded data store '" + ds.getName() + "', " + (ds.isEnabled() ? "enabled" : "disabled"));
            }
            if (checkStores && ds.isEnabled()) {
                try {
                    ds.getDataStore(null);
                }
                catch (Throwable t) {
                    LOGGER.warning("Error connecting to '" + ds.getName() + "'. Disabling.");
                    LOGGER.log(Level.INFO, "", t);
                    ds.setError(t);
                    ds.setEnabled(false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to load data store '" + storeResource.parent().name() + "'", e);
            return;
        }
        LayerLoader<FeatureTypeInfo> featureLoader = new LayerLoader<FeatureTypeInfo>(FeatureTypeInfo.class, xp, catalog);
        try (AsynchResourceIterator<LayerContents> it = new AsynchResourceIterator<LayerContents>(storeResource.parent(), (Filter<Resource>)Resources.DirectoryFilter.INSTANCE, FEATURE_LAYER_MAPPER);){
            while (it.hasNext()) {
                LayerContents lc = it.next();
                featureLoader.accept(lc);
            }
        }
    }

    private boolean isConfigDirectory(Resource dir) {
        String name = dir.name();
        boolean result = "styles".equals(name) || "layergroups".equals(name);
        return result;
    }

    Catalog readLegacyCatalog(Resource f, XStreamPersister xp) throws Exception {
        CatalogImpl catalog2 = new CatalogImpl();
        catalog2.setResourceLoader(this.resourceLoader);
        GeoServerConfigPersister cp = new GeoServerConfigPersister(this.resourceLoader, xp);
        GeoServerResourcePersister rp = new GeoServerResourcePersister(this.resourceLoader);
        if (!legacy) {
            catalog2.addListener(cp);
            catalog2.addListener(rp);
        }
        LegacyCatalogImporter importer = new LegacyCatalogImporter(catalog2);
        importer.setResourceLoader(this.resourceLoader);
        importer.imprt(this.resourceLoader.getBaseDirectory());
        if (!legacy) {
            catalog2.removeListener(cp);
            catalog2.removeListener(rp);
        }
        if (!legacy) {
            Resource featureTypesDir = this.resourceLoader.get("featureTypes");
            if (featureTypesDir != null) {
                LegacyCatalogReader creader = new LegacyCatalogReader();
                creader.read(f);
                Map<String, Map<String, Object>> dataStores = creader.dataStores();
                for (Resource featureTypeDir : featureTypesDir.list()) {
                    Resource featureTypeInfo;
                    if (featureTypeDir.getType() != Resource.Type.DIRECTORY || !Resources.exists((Resource)(featureTypeInfo = featureTypeDir.get("info.xml")))) continue;
                    LegacyFeatureTypeInfoReader reader = new LegacyFeatureTypeInfoReader();
                    reader.read(featureTypeInfo);
                    Map<String, Object> dataStore = dataStores.get(reader.dataStore());
                    if (dataStore == null) continue;
                    String namespace = (String)dataStore.get("namespace");
                    Resource destFeatureTypeDir = this.resourceLoader.get(Paths.path((String[])new String[]{"workspaces", namespace, reader.dataStore(), reader.name()}));
                    if (destFeatureTypeDir == null) continue;
                    for (Resource file : featureTypeDir.list()) {
                        if (file.getType() != Resource.Type.RESOURCE || featureTypeInfo.equals(file)) continue;
                        IOUtils.copy((InputStream)file.in(), (OutputStream)destFeatureTypeDir.get(file.name()).out());
                    }
                }
            }
            f.renameTo(f.parent().get("catalog.xml.old"));
        }
        return catalog2;
    }

    protected void readConfiguration(GeoServer geoServer, XStreamPersister xp) throws Exception {
        Resource f = this.resourceLoader.get("services.xml");
        if (!Resources.exists((Resource)f)) {
            Resource workspaces;
            f = this.resourceLoader.get("global.xml");
            if (Resources.exists((Resource)f)) {
                try {
                    GeoServerInfo global = this.depersist(xp, f, GeoServerInfo.class);
                    geoServer.setGlobal(global);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to load global configuration file '" + f.name() + "'", e);
                }
            }
            if (Resources.exists((Resource)(f = this.resourceLoader.get("logging.xml")))) {
                try {
                    LoggingInfo logging = this.depersist(xp, f, LoggingInfo.class);
                    geoServer.setLogging(logging);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to load logging configuration file '" + f.name() + "'", e);
                }
            }
            if (Resources.exists((Resource)(workspaces = this.resourceLoader.get("workspaces")))) {
                for (Resource dir : workspaces.list()) {
                    if (dir.getType() != Resource.Type.DIRECTORY || !Resources.exists((Resource)(f = dir.get("settings.xml")))) continue;
                    try {
                        SettingsInfo settings = this.depersist(xp, f, SettingsInfo.class);
                        geoServer.add(settings);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Failed to load configuration file '" + f.name() + "' for workspace " + dir.name(), e);
                    }
                }
            }
            List loaders = GeoServerExtensions.extensions(XStreamServiceLoader.class);
            this.loadServices(this.resourceLoader.get(""), true, loaders, geoServer);
            if (workspaces != null) {
                for (Resource dir : workspaces.list()) {
                    if (dir.getType() != Resource.Type.DIRECTORY) continue;
                    this.loadServices(dir, false, loaders, geoServer);
                }
            }
        } else {
            GeoServerConfigPersister p = new GeoServerConfigPersister(this.resourceLoader, xp);
            geoServer.addListener(p);
            new LegacyConfigurationImporter(geoServer).imprt(this.resourceLoader.getBaseDirectory());
            geoServer.removeListener(p);
            f.renameTo(f.parent().get("services.xml.old"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loadStyles(Resource styles, Catalog catalog, XStreamPersister xp) throws IOException {
        Filter styleFilter = r -> XML_FILTER.accept(r) && !Resources.exists((Resource)styles.get(r.name() + ".xml"));
        try (AsynchResourceIterator<byte[]> it = new AsynchResourceIterator<byte[]>(styles, (Filter<Resource>)styleFilter, r -> r.getContents());){
            while (it.hasNext()) {
                try {
                    StyleInfo s = GeoServerLoader.depersist(xp, it.next(), StyleInfo.class);
                    catalog.add(s);
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Loaded style '" + s.getName() + "'");
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to load style", e);
                }
            }
            return;
        }
    }

    void loadLayerGroups(Resource layerGroups, Catalog catalog, XStreamPersister xp) {
        try (AsynchResourceIterator<byte[]> it = new AsynchResourceIterator<byte[]>(layerGroups, (Filter<Resource>)XML_FILTER, r -> r.getContents());){
            while (it.hasNext()) {
                try {
                    LayerGroupInfo lg = GeoServerLoader.depersist(xp, it.next(), LayerGroupInfo.class);
                    if (lg.getLayers() == null || lg.getLayers().size() == 0) {
                        LOGGER.warning("Skipping empty layer group '" + lg.getName() + "', it is invalid");
                        continue;
                    }
                    catalog.add(lg);
                    LOGGER.info("Loaded layer group '" + lg.getName() + "'");
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to load layer group", e);
                }
            }
        }
    }

    void loadServices(Resource directory, boolean global, List<XStreamServiceLoader> loaders, GeoServer geoServer) {
        for (XStreamServiceLoader l : loaders) {
            try {
                Object s = l.load(geoServer, directory);
                if (!global && s.getWorkspace() == null) continue;
                geoServer.add((ServiceInfo)s);
                LOGGER.info("Loaded service '" + s.getId() + "', " + (s.isEnabled() ? "enabled" : "disabled"));
            }
            catch (Throwable t) {
                if (Resources.exists((Resource)directory)) {
                    LOGGER.log(Level.SEVERE, "Failed to load the service configuration in directory: " + directory + " with loader for " + l.getServiceClass(), t);
                    continue;
                }
                LOGGER.log(Level.SEVERE, "Failed to load the root service configuration with loader for " + l.getServiceClass(), t);
            }
        }
    }

    void persist(XStreamPersister xp, Object obj, Resource f) throws Exception {
        BufferedOutputStream out = new BufferedOutputStream(f.out());
        xp.save(obj, out);
        out.flush();
        out.close();
    }

    <T> T depersist(XStreamPersister xp, Resource f, Class<T> clazz) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(f.getContents());){
            T t = xp.load(in, clazz);
            return t;
        }
    }

    static <T> T depersist(XStreamPersister xp, byte[] contents, Class<T> clazz) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(contents);){
            T t = xp.load(in, clazz);
            return t;
        }
    }

    public void destroy() throws Exception {
        this.geoserver.dispose();
    }

    static final class LayerLoader<T extends ResourceInfo>
    implements Consumer<LayerContents> {
        Class<T> clazz;
        XStreamPersister xp;
        Catalog catalog;

        public LayerLoader(Class<T> clazz, XStreamPersister xp, Catalog catalog) {
            this.clazz = clazz;
            this.xp = xp;
            this.catalog = catalog;
        }

        @Override
        public void accept(LayerContents lc) {
            ResourceInfo ft = null;
            try {
                ft = (ResourceInfo)GeoServerLoader.depersist(this.xp, lc.contents, this.clazz);
                this.catalog.add(ft);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to load resource", e);
                return;
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                String type = ft instanceof CoverageInfo ? "coverage" : (ft instanceof FeatureTypeInfo ? "feature type" : "resource");
                LOGGER.info("Loaded " + type + " '" + lc.resource.name() + "', " + (ft.isEnabled() ? "enabled" : "disabled"));
            }
            try {
                LayerInfo l = GeoServerLoader.depersist(this.xp, lc.layerContents, LayerInfo.class);
                this.catalog.add(l);
                LOGGER.info("Loaded layer '" + l.getName() + "'");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to load layer " + lc.resource.name(), e);
            }
        }
    }

    static final class ResourceLayerMapper
    implements AsynchResourceIterator.ResourceMapper<LayerContents> {
        private String resourceFileName;
        private String resourceType;

        public ResourceLayerMapper(String resourceFileName, String resourceType) {
            this.resourceFileName = resourceFileName;
            this.resourceType = resourceType;
        }

        @Override
        public LayerContents apply(Resource rd) throws IOException {
            Resource r = rd.get(this.resourceFileName);
            Resource lr = rd.get("layer.xml");
            if (Resources.exists((Resource)r) && Resources.exists((Resource)lr)) {
                byte[] contents = r.getContents();
                byte[] lrContents = lr.getContents();
                return new LayerContents(rd, contents, lrContents);
            }
            LOGGER.warning("Ignoring " + this.resourceType + " directory " + rd.path());
            return null;
        }
    }

    static final class LayerContents {
        Resource resource;
        byte[] contents;
        byte[] layerContents;

        public LayerContents(Resource resource, byte[] contents, byte[] layerContents) {
            this.resource = resource;
            this.contents = contents;
            this.layerContents = layerContents;
        }
    }

    static final class StoreContents {
        Resource resource;
        byte[] contents;

        public StoreContents(Resource resource, byte[] contents) {
            this.resource = resource;
            this.contents = contents;
        }
    }

    static final class WorkspaceMapper
    implements AsynchResourceIterator.ResourceMapper<WorkspaceContents> {
        WorkspaceMapper() {
        }

        @Override
        public WorkspaceContents apply(Resource rd) throws IOException {
            Resource wr = rd.get("workspace.xml");
            Resource nr = rd.get("namespace.xml");
            if (Resources.exists((Resource)wr) && Resources.exists((Resource)nr)) {
                byte[] contents = wr.getContents();
                byte[] nrContents = nr.getContents();
                return new WorkspaceContents(rd, contents, nrContents);
            }
            LOGGER.warning("Ignoring workspace directory " + rd.path());
            return null;
        }
    }

    static final class WorkspaceContents {
        Resource resource;
        byte[] contents;
        byte[] nsContents;

        public WorkspaceContents(Resource resource, byte[] contents, byte[] nsContents) {
            this.resource = resource;
            this.contents = contents;
            this.nsContents = nsContents;
        }
    }
}

