/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerConfigPersister;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.platform.resource.Resources;
import org.geoserver.util.EntityResolverProvider;
import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.DefaultResourceLocator;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Mark;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.URLs;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.xml.sax.EntityResolver;

public class GeoServerDataDirectory {
    GeoServerResourceLoader resourceLoader;
    EntityResolverProvider entityResolverProvider;
    static final String WORKSPACE_XML = "workspace.xml";
    static final String NAMESPACE_XML = "namespace.xml";
    static final String DATASTORE_XML = "datastore.xml";
    static final String COVERAGESTORE_XML = "coveragestore.xml";
    static final String WMSSTORE_XML = "wmsstore.xml";
    static final String WMTSSTORE_XML = "wmtsstore.xml";
    static final String FEATURETYPE_XML = "featuretype.xml";
    static final String COVERAGE_XML = "coverage.xml";
    static final String WMSLAYER_XML = "wmslayer.xml";
    static final String WMTSLAYER_XML = "wmtslayer.xml";
    static final String LAYER_XML = "layer.xml";
    static final String WORKSPACE_DIR = "workspaces";
    static final String LAYERGROUP_DIR = "layergroups";
    static final String STYLE_DIR = "styles";
    static final String SECURITY_DIR = "security";

    public GeoServerDataDirectory(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public GeoServerDataDirectory(File baseDirectory) {
        this(new GeoServerResourceLoader(baseDirectory));
    }

    public GeoServerResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Resource get(String path) {
        return this.resourceLoader.get(path);
    }

    public File root() {
        return this.resourceLoader.getBaseDirectory();
    }

    public File findOrCreateDir(String ... location) throws IOException {
        return this.get(Paths.path((String[])location)).dir();
    }

    public File findFile(String ... location) throws IOException {
        Resource resource = this.get(Paths.path((String[])location));
        return Resources.find((Resource)resource);
    }

    public File findDataRoot() throws IOException {
        Resource directory = this.get("data");
        return Resources.directory((Resource)directory);
    }

    public File findOrCreateDataRoot() throws IOException {
        Resource directory = this.get("data");
        return directory.dir();
    }

    public File findDataDir(String ... location) throws IOException {
        Resource resource = this.get(Paths.path((String[])new String[]{"data", Paths.path((String[])location)}));
        return Resources.directory((Resource)resource);
    }

    public File findOrCreateDataDir(String ... location) throws IOException {
        Resource resource = this.get(Paths.path((String[])new String[]{"data", Paths.path((String[])location)}));
        return resource.dir();
    }

    private File dataDir(boolean create, String ... location) throws IOException {
        Resource directory = this.get(Paths.path((String[])new String[]{"data", Paths.path((String[])location)}));
        if (create) {
            return directory.dir();
        }
        return Resources.directory((Resource)directory);
    }

    public File findDataFile(String ... location) throws IOException {
        Resource resource = this.get(Paths.path((String[])new String[]{"data", Paths.path((String[])location)}));
        return Resources.file((Resource)resource);
    }

    public File findOrResolveDataFile(String ... location) throws IOException {
        Resource resource = this.get(Paths.path((String[])new String[]{"data", Paths.path((String[])location)}));
        return resource.file();
    }

    private File dataFile(boolean create, String ... location) throws IOException {
        Resource resource = this.get(Paths.path((String[])new String[]{"data", Paths.path((String[])location)}));
        if (create) {
            return resource.file();
        }
        return Resources.file((Resource)resource);
    }

    @Deprecated
    public File findSecurityRoot() throws IOException {
        return Resources.directory((Resource)this.getSecurity(new String[0]));
    }

    @Deprecated
    public File findOrCreateSecurityRoot() throws IOException {
        return this.getSecurity(new String[0]).dir();
    }

    @Deprecated
    private File securityRoot(boolean create) throws IOException {
        Resource directory = this.getSecurity(new String[0]);
        File f = create ? directory.dir() : Resources.directory((Resource)directory);
        return f;
    }

    @Deprecated
    public File findSecurityDir(String ... location) throws IOException {
        return Resources.directory((Resource)this.getSecurity(location));
    }

    @Deprecated
    public File findOrCreateSecurityDir(String ... location) throws IOException {
        return this.getSecurity(location).dir();
    }

    @Deprecated
    public void copyToSecurityDir(File f) throws IOException {
        Resource resource = this.getSecurity(new String[0]);
        Resources.copy((File)f, (Resource)resource);
    }

    @Deprecated
    public void copyToSecurityDir(InputStream data, String filename) throws IOException {
        Resource resource = this.getSecurity(new String[0]);
        Resources.copy((InputStream)data, (Resource)resource, (String)filename);
    }

    @Deprecated
    public File findWorkspaceDir(WorkspaceInfo ws) throws IOException {
        Resource directory = this.get(ws, new String[0]);
        return Resources.directory((Resource)directory);
    }

    @Deprecated
    public File findOrCreateWorkspaceDir(WorkspaceInfo ws) throws IOException {
        Resource directory = this.get(ws, new String[0]);
        return directory.dir();
    }

    @Deprecated
    public File findWorkspaceFile(WorkspaceInfo ws) throws IOException {
        Resource workspaceFile = this.config(ws);
        return Resources.file((Resource)workspaceFile);
    }

    @Deprecated
    public File findOrResolveWorkspaceFile(WorkspaceInfo ws) throws IOException {
        Resource workspaceFile = this.config(ws);
        return workspaceFile.file();
    }

    @Deprecated
    public File findSuppWorkspaceFile(WorkspaceInfo ws, String filename) throws IOException {
        Resource resource = this.get(ws, filename);
        return Resources.file((Resource)resource);
    }

    @Deprecated
    public File findSuppWorkspacesFile(WorkspaceInfo ws, String filename) throws IOException {
        Resource resource = this.getWorkspaces(filename);
        return Resources.file((Resource)resource);
    }

    @Deprecated
    public void copyToWorkspaceDir(WorkspaceInfo ws, File file) throws IOException {
        Resource directory = this.get(ws, new String[0]);
        Resources.copy((File)file, (Resource)directory);
    }

    @Deprecated
    public void copyToWorkspaceDir(WorkspaceInfo ws, InputStream data, String filename) throws IOException {
        Resource directory = this.get(ws, new String[0]);
        Resources.copy((InputStream)data, (Resource)directory, (String)filename);
    }

    @Deprecated
    public void copyToWorkspacesDir(InputStream data, String filename) throws IOException {
        Resources.copy((InputStream)data, (Resource)this.getWorkspaces(new String[0]), (String)filename);
    }

    @Deprecated
    public File findStoreDir(StoreInfo store) throws IOException {
        Resource directory = this.get(store, new String[0]);
        return Resources.directory((Resource)directory);
    }

    @Deprecated
    private String path(StoreInfo store) {
        WorkspaceInfo workspace = store.getWorkspace();
        return Paths.path((String[])new String[]{WORKSPACE_DIR, workspace.getName(), store.getName()});
    }

    @Deprecated
    public File findOrCreateStoreDir(StoreInfo store) throws IOException {
        Resource resource = this.get(store, new String[0]);
        return resource.dir();
    }

    @Deprecated
    public File findStoreFile(StoreInfo store) throws IOException {
        Resource resource = this.config(store);
        return Resources.file((Resource)resource);
    }

    @Deprecated
    public File findOrResolveStoreFile(StoreInfo store) throws IOException {
        Resource resource = this.get(store, new String[0]);
        return resource.file();
    }

    @Deprecated
    public File findSuppStoreFile(StoreInfo store, String filename) throws IOException {
        Resource resource = this.get(store, filename);
        return Resources.file((Resource)resource);
    }

    @Deprecated
    public void copyToStoreDir(StoreInfo store, File file) throws IOException {
        Resource directory = this.get(this.path(store));
        Resources.copy((File)file, (Resource)directory);
    }

    public void copyToStoreDir(StoreInfo store, InputStream data, String filename) throws IOException {
        Resource directory = this.get(store, new String[0]);
        Resources.copy((InputStream)data, (Resource)directory, (String)filename);
    }

    @Deprecated
    public File findResourceDir(ResourceInfo resource) throws IOException {
        Resource directory = this.get(resource, new String[0]);
        return Resources.directory((Resource)directory);
    }

    public File findLegacyResourceDir(ResourceInfo resource) throws IOException {
        StoreInfo store = resource.getStore();
        String dirname = store.getName() + "_" + resource.getName();
        File dir = null;
        if (resource instanceof FeatureTypeInfo) {
            dir = this.resourceLoader.find(new String[]{"featureTypes", dirname});
        } else if (resource instanceof CoverageInfo) {
            dir = this.resourceLoader.find(new String[]{"coverages", dirname});
        }
        return dir != null ? dir : null;
    }

    public File findOrCreateResourceDir(ResourceInfo r) throws IOException {
        Resource directory = this.get(r, new String[0]);
        return directory.dir();
    }

    @Deprecated
    public File findResourceFile(ResourceInfo r) throws IOException {
        Resource resource = this.config(r);
        return Resources.file((Resource)resource);
    }

    @Deprecated
    public File findOrResolveResourceFile(ResourceInfo r) throws IOException {
        Resource resource = this.config(r);
        return resource.file();
    }

    @Deprecated
    public File findSuppResourceFile(ResourceInfo r, String filename) throws IOException {
        Resource resource = this.get(r, filename);
        return Resources.file((Resource)resource);
    }

    public File findSuppLegacyResourceFile(ResourceInfo r, String filename) throws IOException {
        File rdir = this.findLegacyResourceDir(r);
        if (rdir != null) {
            File file = new File(rdir, filename);
            return file.exists() ? file : null;
        }
        return null;
    }

    @Deprecated
    public void copyToResourceDir(ResourceInfo resource, File file) throws IOException {
        Resource directory = this.get(resource, new String[0]);
        Resources.copy((File)file, (Resource)directory);
    }

    @Deprecated
    public void copyToResourceDir(ResourceInfo resource, InputStream data, String filename) throws IOException {
        Resource directory = this.get(resource, new String[0]);
        Resources.copy((InputStream)data, (Resource)directory, (String)filename);
    }

    @Deprecated
    public File findNamespaceFile(WorkspaceInfo ws) throws IOException {
        Resource directory = this.get(ws, new String[0]);
        return Resources.directory((Resource)directory);
    }

    @Deprecated
    public File findOrResolveNamespaceFile(WorkspaceInfo ws) throws IOException {
        Resource directory = this.get(ws, new String[0]);
        return directory.dir();
    }

    @Deprecated
    public File findLayerFile(LayerInfo layer) throws IOException {
        Resource resource = this.get(layer, new String[0]);
        return Resources.file((Resource)resource);
    }

    public File findOrResolveLayerFile(LayerInfo layer) throws IOException {
        Resource resource = this.get(layer, new String[0]);
        return resource.file();
    }

    public File findStyleDir() throws IOException {
        Resource styles = this.get(STYLE_DIR);
        return Resources.directory((Resource)styles);
    }

    public File findOrCreateStyleDir() throws IOException {
        Resource styles = this.get(STYLE_DIR);
        return styles.dir();
    }

    File styleDir(boolean create, StyleInfo styleInfo) throws IOException {
        Resource styles = this.get(styleInfo, new String[0]);
        return Resources.directory((Resource)styles, (boolean)create);
    }

    File styleDir(boolean create, WorkspaceInfo workspaceInfo) throws IOException {
        Resource styles = this.get(workspaceInfo, STYLE_DIR);
        return Resources.directory((Resource)styles, (boolean)create);
    }

    public File findStyleFile(StyleInfo s) throws IOException {
        Resource resource = this.config(s);
        return Resources.file((Resource)resource);
    }

    public File findStyleSldFile(StyleInfo s) throws IOException {
        Resource resource = this.style(s);
        return Resources.file((Resource)resource);
    }

    public File findOrCreateStyleFile(StyleInfo s) throws IOException {
        Resource resource = this.config(s);
        return resource.file();
    }

    public File findOrCreateStyleSldFile(StyleInfo s) throws IOException {
        Resource resource = this.style(s);
        return resource.file();
    }

    @Nonnull
    public Resource getRoot(String ... path) {
        Resource r = this.get(Paths.path((String[])path));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource getSecurity(String ... path) {
        Resource r = this.get(Paths.path((String[])new String[]{SECURITY_DIR, Paths.path((String[])path)}));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource getWorkspaces(String ... path) {
        Resource r = this.get(Paths.path((String[])new String[]{WORKSPACE_DIR, Paths.path((String[])path)}));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource defaultWorkspaceConfig() {
        Resource r = this.getRoot("default.xml");
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(WorkspaceInfo ws, String ... path) {
        Resource r = ws == null ? this.get(Paths.path((String[])path)) : this.getWorkspaces(ws.getName(), Paths.path((String[])path));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(WorkspaceInfo ws) {
        Resource r = this.get(ws, WORKSPACE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(NamespaceInfo ns, String ... path) {
        Resource r = ns == null ? this.get(Paths.path((String[])path)) : this.getWorkspaces(ns.getPrefix(), Paths.path((String[])path));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(NamespaceInfo ns) {
        Resource r = this.get(ns, NAMESPACE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(StoreInfo store, String ... path) {
        Resource r = this.get(store.getWorkspace(), store.getName(), Paths.path((String[])path));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(DataStoreInfo ds) {
        Resource r = this.get(ds, DATASTORE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(CoverageStoreInfo cs) {
        Resource r = this.get(cs, COVERAGESTORE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(WMSStoreInfo wmss) {
        Resource r = this.get(wmss, WMSSTORE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(WMTSStoreInfo wmss) {
        Resource r = this.get(wmss, WMTSSTORE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    private Resource config(StoreInfo si) {
        Resource r;
        if (si instanceof DataStoreInfo) {
            r = this.config((DataStoreInfo)si);
        } else if (si instanceof CoverageStoreInfo) {
            r = this.config((CoverageStoreInfo)si);
        } else if (si instanceof WMTSStoreInfo) {
            r = this.config((WMTSStoreInfo)si);
        } else if (si instanceof WMSStoreInfo) {
            r = this.config((WMSStoreInfo)si);
        } else {
            throw new IllegalArgumentException("Only DataStoreInfo, CoverageStoreInfo, and WMS/WMTSStoreInfo are supported.");
        }
        assert (r != null);
        return r;
    }

    @Nonnull
    private Resource config(ResourceInfo si) {
        Resource r;
        if (si instanceof FeatureTypeInfo) {
            r = this.config((FeatureTypeInfo)si);
        } else if (si instanceof CoverageInfo) {
            r = this.config((CoverageInfo)si);
        } else if (si instanceof WMTSLayerInfo) {
            r = this.config((WMTSLayerInfo)si);
        } else if (si instanceof WMSLayerInfo) {
            r = this.config((WMSLayerInfo)si);
        } else {
            throw new IllegalArgumentException("Only FeatureTypeInfo, CoverageInfo, and WMS/WMTSLayerInfo are supported.");
        }
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(ResourceInfo ri, String ... path) {
        Resource r = this.get(ri.getStore(), ri.getName(), Paths.path((String[])path));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(FeatureTypeInfo fti) {
        Resource r = this.get(fti, FEATURETYPE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(CoverageInfo c) {
        Resource r = this.get(c, COVERAGE_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(WMSLayerInfo wmsl) {
        Resource r = this.get(wmsl, WMSLAYER_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(WMTSLayerInfo wmsl) {
        Resource r = this.get(wmsl, WMTSLAYER_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(LayerInfo l, String ... path) {
        Resource r;
        if (l.getResource() instanceof FeatureTypeInfo) {
            r = this.get(l.getResource(), path);
        } else if (l.getResource() instanceof CoverageInfo) {
            r = this.get(l.getResource(), path);
        } else if (l.getResource() instanceof WMTSLayerInfo) {
            r = this.get(l.getResource(), path);
        } else if (l.getResource() instanceof WMSLayerInfo) {
            r = this.get(l.getResource(), path);
        } else {
            throw new IllegalArgumentException("Only FeatureTypeInfo, CoverageInfo, and WMS/WMTSLayerInfo are supported.");
        }
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(LayerInfo li) {
        Resource r = this.get(li, LAYER_XML);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource getLayerGroups(String ... path) {
        Resource r = this.getLayerGroups((WorkspaceInfo)null, path);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource getLayerGroups(WorkspaceInfo wsi, String ... path) {
        Resource r = this.get(wsi, Paths.path((String[])new String[]{LAYERGROUP_DIR, Paths.path((String[])path)}));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(LayerGroupInfo lgi, String ... path) {
        WorkspaceInfo wsi = lgi.getWorkspace();
        Resource r = this.getLayerGroups(wsi, path);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(LayerGroupInfo lgi) {
        Resource r = this.get(lgi, String.format("%s.xml", lgi.getName()));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource getStyles(String ... path) {
        Resource r = this.getStyles((WorkspaceInfo)null, path);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource getStyles(WorkspaceInfo wsi, String ... path) {
        Resource r = this.get(wsi, Paths.path((String[])new String[]{STYLE_DIR, Paths.path((String[])path)}));
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource get(StyleInfo si, String ... path) {
        WorkspaceInfo workspace = si != null ? si.getWorkspace() : null;
        Resource r = this.getStyles(workspace, path);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(StyleInfo s) {
        String filename = s.getFilename() != null && s.getFilename().endsWith(".xml") && s.getFilename().startsWith(s.getName() + ".") ? s.getName() + ".xml.xml" : s.getName() + ".xml";
        Resource r = this.get(s, filename);
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource style(StyleInfo s) {
        String filename = s.getFilename();
        Resource r = this.get(s, filename);
        assert (r != null);
        return r;
    }

    @Nonnull
    protected Style parsedStyleResources(StyleInfo s) throws IOException {
        Resource styleResource = this.style(s);
        if (styleResource.getType() == Resource.Type.UNDEFINED) {
            throw new FileNotFoundException("No such resource: " + s.getFilename());
        }
        ResourceAwareResourceLocator locator = new ResourceAwareResourceLocator();
        locator.setSourceUrl(Resources.toURL((Resource)styleResource));
        StyledLayerDescriptor sld = Styles.handler(s.getFormat()).parse(styleResource, s.getFormatVersion(), (ResourceLocator)locator, null);
        Style style = Styles.style(sld);
        assert (style != null);
        return style;
    }

    @Nonnull
    public StyledLayerDescriptor parsedSld(StyleInfo s) throws IOException {
        Resource styleResource = this.style(s);
        if (styleResource.getType() == Resource.Type.UNDEFINED) {
            throw new IOException("No such resource: " + s.getFilename());
        }
        File input = styleResource.file();
        DefaultResourceLocator locator = new DefaultResourceLocator(){

            public URL locateResource(String uri) {
                URL url = super.locateResource(uri);
                if (url != null && url.getProtocol().equalsIgnoreCase("resource")) {
                    Resource resource = GeoServerDataDirectory.this.resourceLoader.fromURL(url);
                    File file = Resources.exists((Resource)resource) ? resource.file() : Paths.toFile((File)GeoServerDataDirectory.this.root(), (String)resource.path());
                    URL u = GeoServerDataDirectory.fileToUrlPreservingCqlTemplates(file);
                    if (url.getQuery() != null) {
                        try {
                            u = new URL(u.toString() + "?" + url.getQuery());
                        }
                        catch (MalformedURLException ex) {
                            GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error processing query string for resource with uri: " + uri, ex);
                            return null;
                        }
                    }
                    if (url.getRef() != null) {
                        try {
                            u = new URL(u.toString() + "#" + url.getRef());
                        }
                        catch (MalformedURLException ex) {
                            GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error processing # fragment for resource with uri: " + uri, ex);
                            return null;
                        }
                    }
                    return u;
                }
                return url;
            }

            protected URL validateRelativeURL(URL relativeUrl) {
                if (relativeUrl.getProtocol().equalsIgnoreCase("resource")) {
                    return relativeUrl;
                }
                return super.validateRelativeURL(relativeUrl);
            }
        };
        locator.setSourceUrl(Resources.toURL((Resource)styleResource));
        EntityResolver entityResolver = this.getEntityResolver();
        StyledLayerDescriptor sld = Styles.handler(s.getFormat()).parse(input, s.getFormatVersion(), (ResourceLocator)locator, this.getEntityResolver());
        return sld;
    }

    @Nonnull
    public Style parsedStyle(StyleInfo s) throws IOException {
        StyledLayerDescriptor sld = this.parsedSld(s);
        Style style = Styles.style(sld);
        assert (style != null);
        return style;
    }

    private EntityResolver getEntityResolver() {
        EntityResolver resolver = null;
        EntityResolverProvider provider = (EntityResolverProvider)GeoServerExtensions.bean(EntityResolverProvider.class);
        if (provider != null) {
            resolver = provider.getEntityResolver();
        }
        return resolver;
    }

    @Nonnull
    public Resource config(SettingsInfo s) {
        Resource r = this.get(s.getWorkspace(), "settings.xml");
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(LoggingInfo l) {
        Resource r = this.getRoot("logging.xml");
        assert (r != null);
        return r;
    }

    @Nonnull
    public Resource config(GeoServerInfo g) {
        Resource r = this.getRoot("global.xml");
        assert (r != null);
        return r;
    }

    @Deprecated
    public void copyToStyleDir(File file, StyleInfo style) throws IOException {
        Resource styles = this.get(style, new String[0]);
        FileUtils.copyFileToDirectory((File)file, (File)styles.dir());
    }

    public File findLayerGroupDir() throws IOException {
        Resource resource = this.getLayerGroups(new String[0]);
        return Resources.directory((Resource)resource);
    }

    List<Resource> additionalStyleResources(StyleInfo s) throws IOException {
        final ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource baseDir = this.get(s, new String[0]);
        try {
            Style parsedStyle = this.parsedStyleResources(s);
            parsedStyle.accept((StyleVisitor)new AbstractStyleVisitor(){

                public void visit(ExternalGraphic exgr) {
                    if (exgr.getOnlineResource() == null) {
                        return;
                    }
                    try {
                        String location = exgr.getURI();
                        Resource r = GeoServerDataDirectory.this.resourceLoader.fromURL(location);
                        if (r != null && r.getType() != Resource.Type.UNDEFINED) {
                            resources.add(r);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error attemping to process SLD resource", e);
                    }
                }

                public void visit(Mark mark) {
                    String name;
                    Expression wellKnownName = mark.getWellKnownName();
                    if (wellKnownName instanceof Literal && (name = (String)wellKnownName.evaluate(null, String.class)).startsWith("resource:/")) {
                        try {
                            Resource r = GeoServerDataDirectory.this.resourceLoader.fromURL(name);
                            if (r != null && r.getType() != Resource.Type.UNDEFINED) {
                                resources.add(r);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error attemping to process SLD resource", e);
                        }
                    }
                }

                public void visit(ChannelSelection cs) {
                    SelectedChannelType[] rgbChannels;
                    if (cs.getGrayChannel() != null) {
                        cs.getGrayChannel().accept((StyleVisitor)this);
                    }
                    for (SelectedChannelType ch : rgbChannels = cs.getRGBChannels()) {
                        if (ch == null) continue;
                        ch.accept((StyleVisitor)this);
                    }
                }
            });
        }
        catch (FileNotFoundException e) {
            GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error loading style:" + e);
        }
        catch (IOException e) {
            GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error loading style", e);
        }
        return resources;
    }

    public static URL fileToUrlPreservingCqlTemplates(File file) {
        URL url = URLs.fileToUrl((File)file);
        if (!file.getPath().contains("${")) {
            return url;
        }
        try {
            return new URL(url.toExternalForm().replace("%7B", "{").replace("%7D", "}"));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public ResourceStore getResourceStore() {
        return this.resourceLoader.getResourceStore();
    }

    public ResourceLocator getResourceLocator() {
        GeoServerResourceLocator locator = new GeoServerResourceLocator();
        locator.setSourceUrl(URLs.fileToUrl((File)this.getStyles(new String[0]).dir()));
        return locator;
    }

    private class GeoServerResourceLocator
    extends ResourceAwareResourceLocator {
        private GeoServerResourceLocator() {
        }

        public URL locateResource(String uri) {
            URL url = super.locateResource(uri);
            if (url != null && url.getProtocol().equalsIgnoreCase("resource")) {
                Resource resource = GeoServerDataDirectory.this.resourceLoader.fromURL(url);
                File file = Resources.exists((Resource)resource) ? resource.file() : Paths.toFile((File)GeoServerDataDirectory.this.root(), (String)resource.path());
                URL u = GeoServerDataDirectory.fileToUrlPreservingCqlTemplates(file);
                if (url.getQuery() != null) {
                    try {
                        u = new URL(u.toString() + "?" + url.getQuery());
                    }
                    catch (MalformedURLException ex) {
                        GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error processing query string for resource with uri: " + uri, ex);
                        return null;
                    }
                }
                if (url.getRef() != null) {
                    try {
                        u = new URL(u.toString() + "#" + url.getRef());
                    }
                    catch (MalformedURLException ex) {
                        GeoServerConfigPersister.LOGGER.log(Level.WARNING, "Error processing # fragment for resource with uri: " + uri, ex);
                        return null;
                    }
                }
                return u;
            }
            return url;
        }
    }

    private class ResourceAwareResourceLocator
    extends DefaultResourceLocator {
        private ResourceAwareResourceLocator() {
        }

        protected URL validateRelativeURL(URL relativeUrl) {
            if (relativeUrl.getProtocol().equalsIgnoreCase("resource")) {
                String path = relativeUrl.getPath();
                if (GeoServerDataDirectory.this.resourceLoader.get(path).getType() != Resource.Type.UNDEFINED) {
                    return relativeUrl;
                }
                return null;
            }
            return super.validateRelativeURL(relativeUrl);
        }

        protected URL makeRelativeURL(String uri, String query) {
            if (SystemUtils.IS_OS_WINDOWS && uri.contains("\\")) {
                uri = uri.replace('\\', '/');
            }
            return super.makeRelativeURL(uri, query);
        }
    }
}

