/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.ProxyBase;

public class ResolvingProxy
extends ProxyBase {
    static final Map<Class, Constructor> PROXY_CLASS_CONSTRUCTOR_CACHE = new ConcurrentHashMap<Class, Constructor>();
    String ref;
    String prefix;

    public static <T> T create(String ref, Class<T> clazz) {
        return ResolvingProxy.create(ref, null, clazz);
    }

    public static <T> T create(String ref, String prefix, Class<T> clazz) {
        Object proxy;
        ResolvingProxy h = new ResolvingProxy(ref, prefix);
        try {
            Constructor<?> constructor = PROXY_CLASS_CONSTRUCTOR_CACHE.get(clazz);
            if (constructor == null) {
                Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), clazz);
                constructor = proxyClass.getConstructor(InvocationHandler.class);
            }
            proxy = constructor.newInstance(h);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return proxy;
    }

    public static <T> T resolve(Catalog catalog, T object) {
        InvocationHandler h;
        if (object instanceof Proxy && (h = Proxy.getInvocationHandler(object)) instanceof ResolvingProxy) {
            String ref = ((ResolvingProxy)h).getRef();
            String pre = ((ResolvingProxy)h).getPrefix();
            if (object instanceof WorkspaceInfo) {
                WorkspaceInfo ws = catalog.getWorkspace(ref);
                if (ws == null) {
                    ws = catalog.getWorkspaceByName(ref);
                }
                return (T)ws;
            }
            if (object instanceof NamespaceInfo) {
                NamespaceInfo ns = catalog.getNamespace(ref);
                if (ns == null) {
                    ns = catalog.getNamespaceByPrefix(ref);
                }
                return (T)ns;
            }
            if (object instanceof StoreInfo) {
                if (object instanceof DataStoreInfo) {
                    return (T)catalog.getDataStore(ref);
                }
                if (object instanceof CoverageStoreInfo) {
                    return (T)catalog.getCoverageStore(ref);
                }
                StoreInfo resolved = catalog.getStore(ref, StoreInfo.class);
                if (resolved == null) {
                    if (ref.indexOf(":") > 0) {
                        String[] qualifiedName = ref.split(":");
                        resolved = catalog.getStoreByName(qualifiedName[0], qualifiedName[1], StoreInfo.class);
                    } else {
                        resolved = catalog.getStoreByName(ref, StoreInfo.class);
                    }
                }
                return (T)resolved;
            }
            if (object instanceof ResourceInfo) {
                if (object instanceof FeatureTypeInfo) {
                    FeatureTypeInfo r = catalog.getFeatureType(ref);
                    if (r == null) {
                        r = catalog.getFeatureTypeByName(ref);
                    }
                    return (T)r;
                }
                if (object instanceof CoverageInfo) {
                    CoverageInfo r = catalog.getCoverage(ref);
                    if (r == null) {
                        r = catalog.getCoverageByName(ref);
                    }
                    return (T)r;
                }
                ResourceInfo r = catalog.getResource(ref, ResourceInfo.class);
                if (r == null) {
                    r = catalog.getResourceByName(ref, ResourceInfo.class);
                }
                return (T)r;
            }
            if (object instanceof LayerInfo) {
                LayerInfo l = catalog.getLayer(ref);
                if (l == null) {
                    l = catalog.getLayerByName(ref);
                }
                return (T)l;
            }
            if (object instanceof LayerGroupInfo) {
                LayerGroupInfo g = catalog.getLayerGroup(ref);
                if (g == null) {
                    g = catalog.getLayerGroupByName(ref);
                }
                return (T)g;
            }
            if (object instanceof PublishedInfo && (null == ref || "".equals(ref))) {
                return null;
            }
            if (object instanceof StyleInfo) {
                StyleInfo s = catalog.getStyle(ref);
                if (s == null && pre != null) {
                    s = catalog.getStyleByName(pre, ref);
                }
                if (s == null) {
                    s = catalog.getStyleByName(ref);
                }
                return (T)s;
            }
        }
        return object;
    }

    public ResolvingProxy(String ref) {
        this(ref, null);
    }

    public ResolvingProxy(String ref, String prefix) {
        this.ref = ref;
        this.prefix = prefix;
    }

    public String getRef() {
        return this.ref;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    protected Object handleGetUnSet(Object proxy, Method method, String property) throws Throwable {
        if ("id".equalsIgnoreCase(property)) {
            return this.ref;
        }
        return null;
    }

    @Override
    protected Object handleOther(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("hashCode")) {
            return this.hashCode();
        }
        if (methodName.equals("equals")) {
            return args[0] == null || this.equals(args[0]);
        }
        return null;
    }
}

