/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geotools.util.logging.Logging;

public class LayerInfoImpl
implements LayerInfo {
    static final Logger LOGGER = Logging.getLogger(LayerInfoImpl.class);
    static final String KEY_ADVERTISED = "advertised";
    protected String id;
    protected transient String name;
    private String abstractTxt;
    protected String path;
    protected PublishedType type;
    protected StyleInfo defaultStyle;
    protected Set<StyleInfo> styles = new HashSet<StyleInfo>();
    protected ResourceInfo resource;
    protected LegendInfo legend;
    protected transient boolean enabled;
    protected transient Boolean advertised;
    protected Boolean queryable;
    protected Boolean opaque;
    protected MetadataMap metadata = new MetadataMap();
    protected AttributionInfo attribution;
    protected List<AuthorityURLInfo> authorityURLs = new ArrayList<AuthorityURLInfo>(1);
    protected List<LayerIdentifierInfo> identifiers = new ArrayList<LayerIdentifierInfo>(1);
    protected LayerInfo.WMSInterpolation defaultWMSInterpolationMethod;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        if (this.resource == null) {
            return this.name;
        }
        return this.resource.getName();
    }

    @Override
    public void setName(String name) {
        LOGGER.log(Level.FINE, "Warning, some code is setting the LayerInfo name, but that will be ignored");
        this.name = name;
        if (this.resource == null) {
            throw new NullPointerException("Layer name must not be set without an underlying resource");
        }
        this.resource.setName(name);
    }

    @Override
    public String prefixedName() {
        return this.getResource().getStore().getWorkspace().getName() + ":" + this.getName();
    }

    @Override
    public PublishedType getType() {
        return this.type;
    }

    @Override
    public void setType(PublishedType type) {
        this.type = type;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public StyleInfo getDefaultStyle() {
        return this.defaultStyle;
    }

    @Override
    public void setDefaultStyle(StyleInfo defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    @Override
    public Set<StyleInfo> getStyles() {
        return this.styles;
    }

    public void setStyles(Set<StyleInfo> styles) {
        this.styles = styles;
    }

    @Override
    public ResourceInfo getResource() {
        return this.resource;
    }

    @Override
    public void setResource(ResourceInfo resource) {
        this.resource = resource;
    }

    @Override
    public LegendInfo getLegend() {
        return this.legend;
    }

    @Override
    public void setLegend(LegendInfo legend) {
        this.legend = legend;
    }

    @Override
    public AttributionInfo getAttribution() {
        return this.attribution;
    }

    @Override
    public void setAttribution(AttributionInfo attribution) {
        this.attribution = attribution;
    }

    @Override
    public boolean isEnabled() {
        if (this.resource == null) {
            throw new NullPointerException("Unable to get Layer enabled flag without an underlying resource");
        }
        return this.resource.isEnabled();
    }

    @Override
    public boolean enabled() {
        ResourceInfo resource = this.getResource();
        boolean resourceEnabled = resource != null && resource.enabled();
        boolean thisEnabled = this.isEnabled();
        return resourceEnabled && thisEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        LOGGER.log(Level.FINE, "Warning, some code is setting the LayerInfo enabled flag, but that will be ignored");
        this.enabled = enabled;
        if (this.resource == null) {
            throw new NullPointerException("Layer enabled flag must not be set without an underlying resource");
        }
        this.resource.setEnabled(enabled);
    }

    @Override
    public MetadataMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataMap metadata) {
        this.metadata = metadata;
    }

    @Override
    public void accept(CatalogVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultStyle == null ? 0 : this.defaultStyle.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.legend == null ? 0 : this.legend.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.styles == null ? 0 : this.styles.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.attribution == null ? 0 : this.attribution.hashCode());
        result = 31 * result + (this.authorityURLs == null ? 0 : this.authorityURLs.hashCode());
        result = 31 * result + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerInfo)) {
            return false;
        }
        LayerInfo other = (LayerInfo)obj;
        if (this.defaultStyle == null ? other.getDefaultStyle() != null : !this.defaultStyle.equals(other.getDefaultStyle())) {
            return false;
        }
        if (this.id == null ? other.getId() != null : !this.id.equals(other.getId())) {
            return false;
        }
        if (this.legend == null ? other.getLegend() != null : !this.legend.equals(other.getLegend())) {
            return false;
        }
        if (this.path == null ? other.getPath() != null : !this.path.equals(other.getPath())) {
            return false;
        }
        if (this.resource == null ? other.getResource() != null : !this.resource.equals(other.getResource())) {
            return false;
        }
        if (this.styles == null ? other.getStyles() != null : !this.styles.equals(other.getStyles())) {
            return false;
        }
        if (this.type == null ? other.getType() != null : !this.type.equals((Object)other.getType())) {
            return false;
        }
        if (this.attribution == null ? other.getAttribution() != null : !this.attribution.equals(other.getAttribution())) {
            return false;
        }
        if (this.authorityURLs == null ? other.getAuthorityURLs() != null : !this.authorityURLs.equals(other.getAuthorityURLs())) {
            return false;
        }
        return !(this.identifiers == null ? other.getIdentifiers() != null : !this.identifiers.equals(other.getIdentifiers()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.getName() + ", resource:" + this.resource + ']';
    }

    @Override
    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }

    @Override
    public boolean isQueryable() {
        return this.queryable == null ? true : this.queryable;
    }

    @Override
    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    @Override
    public boolean isOpaque() {
        return this.opaque == null ? false : this.opaque;
    }

    @Override
    public boolean isAdvertised() {
        if (this.resource == null) {
            throw new NullPointerException("Unable to get Layer advertised flag without an underlying resource");
        }
        return this.resource.isAdvertised();
    }

    @Override
    public void setAdvertised(boolean advertised) {
        LOGGER.log(Level.FINE, "Warning, some code is setting the LayerInfo advertised flag, but that will be ignored");
        this.advertised = advertised;
        if (this.resource == null) {
            throw new NullPointerException("Layer advertised flag must not be set without an underlying resource");
        }
        this.resource.setAdvertised(advertised);
    }

    @Override
    public List<AuthorityURLInfo> getAuthorityURLs() {
        return this.authorityURLs;
    }

    public void setAuthorityURLs(List<AuthorityURLInfo> authorities) {
        this.authorityURLs = authorities;
    }

    @Override
    public List<LayerIdentifierInfo> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<LayerIdentifierInfo> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public String getTitle() {
        return this.resource.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.resource.setTitle(title);
    }

    @Override
    public String getAbstract() {
        return this.abstractTxt;
    }

    @Override
    public void setAbstract(String abstractTxt) {
        this.abstractTxt = abstractTxt;
    }

    @Override
    public String getPrefixedName() {
        return this.prefixedName();
    }

    @Override
    public LayerInfo.WMSInterpolation getDefaultWMSInterpolationMethod() {
        return this.defaultWMSInterpolationMethod;
    }

    @Override
    public void setDefaultWMSInterpolationMethod(LayerInfo.WMSInterpolation interpolationMethod) {
        this.defaultWMSInterpolationMethod = interpolationMethod;
    }
}

