/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerGroupVisibilityPolicy;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.AbstractDecorator;
import org.geoserver.catalog.impl.AbstractFilteredCatalog;
import org.geoserver.catalog.impl.FilteredList;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.security.decorators.DecoratingLayerGroupInfo;
import org.geotools.filter.expression.InternalVolatileFunction;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public class AdvertisedCatalog
extends AbstractFilteredCatalog {
    private static final long serialVersionUID = 3361872345280114573L;
    private LayerGroupVisibilityPolicy layerGroupPolicy = LayerGroupVisibilityPolicy.HIDE_NEVER;

    public AdvertisedCatalog(Catalog catalog) {
        super(catalog);
    }

    public void setLayerGroupVisibilityPolicy(LayerGroupVisibilityPolicy layerGroupPolicy) {
        this.layerGroupPolicy = layerGroupPolicy;
    }

    private boolean hideLayer(LayerInfo layer) {
        if (!layer.isAdvertised()) {
            return this.checkCapabilitiesRequest(layer.getResource());
        }
        return this.hideResource(layer.getResource());
    }

    private boolean hideResource(ResourceInfo resource) {
        if (!resource.isAdvertised()) {
            return this.checkCapabilitiesRequest(resource);
        }
        return false;
    }

    private boolean isOgcCapabilitiesRequest() {
        Request request = (Request)Dispatcher.REQUEST.get();
        return request != null && "GetCapabilities".equalsIgnoreCase(request.getRequest());
    }

    boolean checkCapabilitiesRequest(ResourceInfo resource) {
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request != null && "GetCapabilities".equalsIgnoreCase(request.getRequest())) {
            String resourceContext = resource.getNamespace().getPrefix() + "/" + resource.getName();
            return !resourceContext.equalsIgnoreCase(request.getContext());
        }
        return false;
    }

    @Override
    protected <T extends ResourceInfo> T checkAccess(T resource) {
        if (resource == null || this.hideResource(resource)) {
            return null;
        }
        return resource;
    }

    @Override
    protected LayerInfo checkAccess(LayerInfo layer) {
        if (layer == null || this.hideLayer(layer)) {
            return null;
        }
        return layer;
    }

    @Override
    protected LayerGroupInfo checkAccess(LayerGroupInfo group) {
        if (group == null) {
            return null;
        }
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request == null || !"GetCapabilities".equalsIgnoreCase(request.getRequest())) {
            return group;
        }
        List<PublishedInfo> layers = group.getLayers();
        List<StyleInfo> styles = group.getStyles();
        ArrayList<PublishedInfo> filteredLayers = new ArrayList<PublishedInfo>();
        ArrayList<StyleInfo> filteredStyles = new ArrayList<StyleInfo>();
        for (int i = 0; i < layers.size(); ++i) {
            PublishedInfo p = layers.get(i);
            StyleInfo style = styles != null && styles.size() > i ? styles.get(i) : null;
            if ((p = p instanceof LayerInfo ? this.checkAccess((LayerInfo)p) : this.checkAccess((LayerGroupInfo)p)) == null) continue;
            filteredLayers.add(p);
            filteredStyles.add(style);
        }
        if (this.layerGroupPolicy.hideLayerGroup(group, filteredLayers)) {
            return null;
        }
        if (!group.getLayers().equals(filteredLayers)) {
            return new AdvertisedLayerGroup(group, filteredLayers, filteredStyles);
        }
        return group;
    }

    @Override
    protected <T extends ResourceInfo> List<T> filterResources(List<T> resources) {
        ArrayList<ResourceInfo> filtered = new ArrayList<ResourceInfo>(resources.size());
        for (ResourceInfo resource : resources) {
            if ((resource = this.checkAccess(resource)) == null) continue;
            filtered.add(resource);
        }
        return filtered;
    }

    @Override
    protected List<LayerGroupInfo> filterGroups(List<LayerGroupInfo> groups) {
        ArrayList<LayerGroupInfo> filtered = new ArrayList<LayerGroupInfo>(groups.size());
        for (LayerGroupInfo group : groups) {
            if ((group = this.checkAccess(group)) == null) continue;
            filtered.add(group);
        }
        return filtered;
    }

    @Override
    protected List<LayerInfo> filterLayers(List<LayerInfo> layers) {
        ArrayList<LayerInfo> filtered = new ArrayList<LayerInfo>(layers.size());
        for (LayerInfo layer : layers) {
            if ((layer = this.checkAccess(layer)) == null) continue;
            filtered.add(layer);
        }
        return filtered;
    }

    @Override
    protected <T extends CatalogInfo> Filter securityFilter(Class<T> infoType, Filter filter) {
        if (!this.isOgcCapabilitiesRequest()) {
            return filter;
        }
        if (!(ResourceInfo.class.isAssignableFrom(infoType) || LayerInfo.class.isAssignableFrom(infoType) || LayerGroupInfo.class.isAssignableFrom(infoType))) {
            return filter;
        }
        InternalVolatileFunction visible = new InternalVolatileFunction(){

            public Boolean evaluate(Object info) {
                if (info instanceof ResourceInfo) {
                    return !AdvertisedCatalog.this.hideResource((ResourceInfo)info);
                }
                if (info instanceof LayerInfo) {
                    return !AdvertisedCatalog.this.hideLayer((LayerInfo)info);
                }
                if (info instanceof LayerGroupInfo) {
                    return AdvertisedCatalog.this.checkAccess((LayerGroupInfo)info) != null;
                }
                throw new IllegalArgumentException("Can't build filter for objects of type " + info.getClass().getName());
            }
        };
        FilterFactory factory = Predicates.factory;
        PropertyIsEqualTo securityFilter = factory.equals((Expression)factory.literal((Object)Boolean.TRUE), (Expression)visible);
        return Predicates.and(filter, (Filter)securityFilter);
    }

    @Override
    protected <T extends StoreInfo> T checkAccess(T store) {
        return store;
    }

    @Override
    protected <T extends NamespaceInfo> T checkAccess(T ns) {
        return ns;
    }

    @Override
    protected <T extends WorkspaceInfo> T checkAccess(T ws) {
        return ws;
    }

    @Override
    protected StyleInfo checkAccess(StyleInfo style) {
        return style;
    }

    @Override
    protected <T extends StoreInfo> List<T> filterStores(List<T> stores) {
        return stores;
    }

    @Override
    protected List<StyleInfo> filterStyles(List<StyleInfo> styles) {
        return styles;
    }

    @Override
    protected <T extends NamespaceInfo> List<T> filterNamespaces(List<T> namespaces) {
        return namespaces;
    }

    @Override
    protected <T extends WorkspaceInfo> List<T> filterWorkspaces(List<T> workspaces) {
        return workspaces;
    }

    @Override
    public void save(LayerGroupInfo layerGroup) {
        if (layerGroup instanceof AdvertisedLayerGroup) {
            AbstractDecorator decorator = (AbstractDecorator)((Object)layerGroup);
            LayerGroupInfo unwrapped = (LayerGroupInfo)decorator.unwrap(LayerGroupInfo.class);
            ((Catalog)this.delegate).save(unwrapped);
        } else {
            ((Catalog)this.delegate).save(layerGroup);
        }
    }

    public static final class AdvertisedLayerGroup
    extends DecoratingLayerGroupInfo {
        private static final long serialVersionUID = 1037043388874118840L;
        private List<PublishedInfo> filteredLayers;
        private List<StyleInfo> filteredStyles;

        public AdvertisedLayerGroup(LayerGroupInfo delegate, List<PublishedInfo> filteredLayers, List<StyleInfo> filteredStyles) {
            super(delegate);
            this.filteredLayers = filteredLayers;
            this.filteredStyles = filteredStyles;
        }

        @Override
        public List<PublishedInfo> getLayers() {
            return new FilteredList<PublishedInfo>(this.filteredLayers, ((LayerGroupInfo)this.delegate).getLayers());
        }

        @Override
        public List<StyleInfo> getStyles() {
            return new FilteredList<StyleInfo>(this.filteredStyles, ((LayerGroupInfo)this.delegate).getStyles());
        }

        public List<PublishedInfo> getOriginalLayers() {
            return ((LayerGroupInfo)this.delegate).getLayers();
        }

        public List<StyleInfo> getOriginalStyles() {
            return ((LayerGroupInfo)this.delegate).getStyles();
        }

        public LayerGroupInfo unwrap() {
            return (LayerGroupInfo)this.delegate;
        }
    }
}

