/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;

public interface LayerGroupInfo
extends PublishedInfo {
    public Mode getMode();

    public void setMode(Mode var1);

    public boolean isQueryDisabled();

    public void setQueryDisabled(boolean var1);

    public WorkspaceInfo getWorkspace();

    public LayerInfo getRootLayer();

    public void setRootLayer(LayerInfo var1);

    public StyleInfo getRootLayerStyle();

    public void setRootLayerStyle(StyleInfo var1);

    public List<PublishedInfo> getLayers();

    public List<StyleInfo> getStyles();

    public List<LayerInfo> layers();

    public List<StyleInfo> styles();

    public ReferencedEnvelope getBounds();

    public void setBounds(ReferencedEnvelope var1);

    public void setWorkspace(WorkspaceInfo var1);

    public List<MetadataLinkInfo> getMetadataLinks();

    default public List<KeywordInfo> getKeywords() {
        return new ArrayList<KeywordInfo>();
    }

    public static boolean equals(LayerGroupInfo lg, Object obj) {
        if (lg == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerGroupInfo)) {
            return false;
        }
        LayerGroupInfo other = (LayerGroupInfo)obj;
        if (lg.getBounds() == null ? other.getBounds() != null : !lg.getBounds().equals((Object)other.getBounds())) {
            return false;
        }
        if (lg.getId() == null ? other.getId() != null : !lg.getId().equals(other.getId())) {
            return false;
        }
        if (lg.getLayers() == null ? other.getLayers() != null : !lg.getLayers().equals(other.getLayers())) {
            return false;
        }
        if (lg.getMetadata() == null ? other.getMetadata() != null : !lg.getMetadata().equals(other.getMetadata())) {
            return false;
        }
        if (lg.getName() == null ? other.getName() != null : !lg.getName().equals(other.getName())) {
            return false;
        }
        if (lg.getMode() == null ? other.getMode() != null : !lg.getMode().equals((Object)other.getMode())) {
            return false;
        }
        if (lg.getTitle() == null ? other.getTitle() != null : !lg.getTitle().equals(other.getTitle())) {
            return false;
        }
        if (lg.getAbstract() == null ? other.getAbstract() != null : !lg.getAbstract().equals(other.getAbstract())) {
            return false;
        }
        if (lg.getWorkspace() == null ? other.getWorkspace() != null : !lg.getWorkspace().equals(other.getWorkspace())) {
            return false;
        }
        List<StyleInfo> styles = LayerGroupInfo.canonicalStyles(lg.getStyles(), lg.getLayers());
        List<StyleInfo> otherStyles = LayerGroupInfo.canonicalStyles(other.getStyles(), other.getLayers());
        if (styles == null ? otherStyles != null : !styles.equals(otherStyles)) {
            return false;
        }
        if (lg.getAuthorityURLs() == null ? other.getAuthorityURLs() != null : !lg.getAuthorityURLs().equals(other.getAuthorityURLs())) {
            return false;
        }
        if (lg.getIdentifiers() == null ? other.getIdentifiers() != null : !lg.getIdentifiers().equals(other.getIdentifiers())) {
            return false;
        }
        if (lg.getRootLayer() == null ? other.getRootLayer() != null : !lg.getRootLayer().equals(other.getRootLayer())) {
            return false;
        }
        if (lg.getRootLayerStyle() == null ? other.getRootLayerStyle() != null : !lg.getRootLayerStyle().equals(other.getRootLayerStyle())) {
            return false;
        }
        if (lg.getAttribution() == null ? other.getAttribution() != null : !lg.getAttribution().equals(other.getAttribution())) {
            return false;
        }
        if (lg.getMetadataLinks() == null ? other.getMetadataLinks() != null : !lg.getMetadataLinks().equals(other.getMetadataLinks())) {
            return false;
        }
        return !lg.isQueryDisabled() != other.isQueryDisabled();
    }

    public static List<StyleInfo> canonicalStyles(List<StyleInfo> styles, List<PublishedInfo> layers) {
        if (styles == null || styles.isEmpty()) {
            return null;
        }
        boolean allNull = true;
        for (StyleInfo s : styles) {
            if (s == null) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            return null;
        }
        if (styles.size() == layers.size()) {
            return styles;
        }
        ArrayList<StyleInfo> canonical = new ArrayList<StyleInfo>(layers.size());
        for (int i = 0; i < layers.size(); ++i) {
            StyleInfo s = styles.size() > i ? styles.get(i) : null;
            canonical.add(s);
        }
        return canonical;
    }

    public static int hashCode(LayerGroupInfo lg) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (lg.getBounds() == null ? 0 : lg.getBounds().hashCode());
        result = 31 * result + (lg.getId() == null ? 0 : lg.getId().hashCode());
        result = 31 * result + (lg.getLayers() == null ? 0 : lg.getLayers().hashCode());
        result = 31 * result + (lg.getMetadata() == null ? 0 : lg.getMetadata().hashCode());
        result = 31 * result + (lg.getName() == null ? 0 : lg.getName().hashCode());
        result = 31 * result + (lg.getMode() == null ? 0 : lg.getMode().hashCode());
        result = 31 * result + (lg.getTitle() == null ? 0 : lg.getTitle().hashCode());
        result = 31 * result + (lg.getAbstract() == null ? 0 : lg.getAbstract().hashCode());
        result = 31 * result + (lg.getWorkspace() == null ? 0 : lg.getWorkspace().hashCode());
        result = 31 * result + (lg.getStyles() == null ? 0 : lg.getStyles().hashCode());
        result = 31 * result + (lg.getRootLayer() == null ? 0 : lg.getRootLayer().hashCode());
        result = 31 * result + (lg.getRootLayerStyle() == null ? 0 : lg.getRootLayerStyle().hashCode());
        result = 31 * result + (lg.getAuthorityURLs() == null ? 0 : lg.getAuthorityURLs().hashCode());
        result = 31 * result + (lg.getIdentifiers() == null ? 0 : lg.getIdentifiers().hashCode());
        result = 31 * result + (lg.getAttribution() == null ? 0 : lg.getAttribution().hashCode());
        result = 31 * result + (lg.getMetadataLinks() == null ? 0 : lg.getMetadataLinks().hashCode());
        result = 31 * result + Boolean.hashCode(lg.isQueryDisabled());
        return result;
    }

    public static enum Mode {
        SINGLE{

            @Override
            public String getName() {
                return "Single";
            }

            @Override
            public Integer getCode() {
                return 0;
            }
        }
        ,
        OPAQUE_CONTAINER{

            @Override
            public String getName() {
                return "Opaque Container";
            }

            @Override
            public Integer getCode() {
                return 4;
            }
        }
        ,
        NAMED{

            @Override
            public String getName() {
                return "Named Tree";
            }

            @Override
            public Integer getCode() {
                return 1;
            }
        }
        ,
        CONTAINER{

            @Override
            public String getName() {
                return "Container Tree";
            }

            @Override
            public Integer getCode() {
                return 2;
            }
        }
        ,
        EO{

            @Override
            public String getName() {
                return "Earth Observation Tree";
            }

            @Override
            public Integer getCode() {
                return 3;
            }
        };


        public abstract String getName();

        public abstract Integer getCode();
    }
}

