/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;

public class GeoServerNodeData {
    public static final String GEOSERVER_NODE_OPTS = "GEOSERVER_NODE_OPTS";
    static final String DEFAULT_NODE_ID_TEMPLATE = "position:absolute; top:12px; left:12px; right:28px; width:auto; background:$background; padding: 1px; border: 1px solid #0076a1; color:$color; font-weight:bold";
    static final Logger LOGGER = Logging.getLogger(GeoServerNodeData.class);
    final String nodeId;
    final String nodeIdStyle;

    public GeoServerNodeData(String nodeId, String nodeIdStyle) {
        this.nodeId = nodeId;
        this.nodeIdStyle = nodeIdStyle;
    }

    public static GeoServerNodeData createFromString(String nodeOpts) {
        String nodeId = null;
        String nodeIdStyle = null;
        if (nodeOpts == null) {
            nodeId = null;
            nodeIdStyle = null;
        } else {
            try {
                Map<String, String> options = GeoServerNodeData.parseProperties(nodeOpts);
                String id = options.get("id");
                if (id != null) {
                    InetAddress address;
                    if (id.contains("$host_ip")) {
                        address = GeoServerNodeData.getLocalHostLANAddress();
                        id = id.replace("$host_ip", address.getHostAddress());
                    } else if (id.contains("$host_name")) {
                        address = GeoServerNodeData.getLocalHostLANAddress();
                        id = id.replace("$host_name", address.getHostName());
                    }
                }
                nodeId = id;
                String bgcolor = options.get("background");
                if (bgcolor == null) {
                    bgcolor = "#dadada";
                }
                String style = DEFAULT_NODE_ID_TEMPLATE.replace("$background", bgcolor);
                String color = options.get("color");
                if (color == null) {
                    color = "#0076a1";
                }
                nodeIdStyle = style.replace("$color", color);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to parse GEOSERVER_NODE_OPTS, expected syntax is id:<nodeid>;color:<css_color>, but got " + nodeOpts + " instead. Disabling NODE_ID GUI element");
                nodeId = null;
                nodeIdStyle = null;
            }
        }
        return new GeoServerNodeData(nodeId, nodeIdStyle);
    }

    public static GeoServerNodeData createFromEnvironment() {
        return GeoServerNodeData.createFromString(GeoServerExtensions.getProperty((String)GEOSERVER_NODE_OPTS));
    }

    static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> inetAddrs = ni.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address");
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    private static Map<String, String> parseProperties(String property) {
        HashMap<String, String> properties = new HashMap<String, String>();
        List kvps = KvpUtils.escapedTokens((String)property, (char)';');
        for (String kvp : kvps) {
            List kv = KvpUtils.escapedTokens((String)kvp, (char)':', (int)2);
            String key = ((String)kv.get(0)).toLowerCase();
            String value = kv.size() == 1 ? "true" : KvpUtils.unescape((String)((String)kv.get(1)));
            properties.put(key, value);
        }
        return properties;
    }

    public String getId() {
        return this.nodeId;
    }

    public String getIdStyle() {
        return this.nodeIdStyle;
    }
}

