/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event;

import java.util.Optional;
import java.util.function.Predicate;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import org.fxmisc.wellbehaved.event.KeyTypedCombination;

@FunctionalInterface
public interface EventPattern<T extends Event, U extends T> {
    public Optional<U> match(T var1);

    default public <V extends U> EventPattern<T, V> andThen(EventPattern<? super U, V> next) {
        return t -> this.match(t).flatMap(next::match);
    }

    default public EventPattern<T, U> and(Predicate<? super U> condition) {
        return t -> this.match(t).map(u -> condition.test((Object)u) ? u : null);
    }

    public static <T extends Event> EventPattern<Event, T> eventTypePattern(EventType<? extends T> eventType) {
        return event -> {
            EventType actualType = event.getEventType();
            do {
                if (!actualType.equals(eventType)) continue;
                Event res = event;
                return Optional.of(res);
            } while ((actualType = actualType.getSuperType()) != null);
            return Optional.empty();
        };
    }

    public static EventPattern<Event, KeyEvent> keyPressed() {
        return EventPattern.eventTypePattern(KeyEvent.KEY_PRESSED);
    }

    public static EventPattern<Event, KeyEvent> keyPressed(KeyCombination combination) {
        return EventPattern.keyPressed().and(arg_0 -> ((KeyCombination)combination).match(arg_0));
    }

    public static EventPattern<Event, KeyEvent> keyPressed(KeyCode code, KeyCombination.Modifier ... modifiers) {
        return EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(code, modifiers));
    }

    public static EventPattern<Event, KeyEvent> keyPressed(String character, KeyCombination.Modifier ... modifiers) {
        return EventPattern.keyPressed((KeyCombination)new KeyCharacterCombination(character, modifiers));
    }

    public static EventPattern<Event, KeyEvent> keyReleased() {
        return EventPattern.eventTypePattern(KeyEvent.KEY_RELEASED);
    }

    public static EventPattern<Event, KeyEvent> keyReleased(KeyCombination combination) {
        return EventPattern.keyReleased().and(arg_0 -> ((KeyCombination)combination).match(arg_0));
    }

    public static EventPattern<Event, KeyEvent> keyReleased(KeyCode code, KeyCombination.Modifier ... modifiers) {
        return EventPattern.keyReleased((KeyCombination)new KeyCodeCombination(code, modifiers));
    }

    public static EventPattern<Event, KeyEvent> keyReleased(String character, KeyCombination.Modifier ... modifiers) {
        return EventPattern.keyReleased((KeyCombination)new KeyCharacterCombination(character, modifiers));
    }

    public static EventPattern<Event, KeyEvent> keyTyped() {
        return EventPattern.eventTypePattern(KeyEvent.KEY_TYPED);
    }

    public static EventPattern<Event, KeyEvent> keyTyped(String character, KeyCombination.Modifier ... modifiers) {
        KeyTypedCombination combination = new KeyTypedCombination(character, modifiers);
        return EventPattern.keyTyped().and(combination::match);
    }
}

