/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import org.fxmisc.wellbehaved.event.CompositeEventHandler;
import org.fxmisc.wellbehaved.event.EmptyEventHandler;
import org.fxmisc.wellbehaved.event.EventPattern;

public final class EventHandlerHelper<T extends Event> {
    public static <T extends Event, U extends T> On<T, U> on(EventPattern<? super T, ? extends U> eventMatcher) {
        return Builder.empty().on(eventMatcher);
    }

    public static <T extends Event> On<Event, T> on(EventType<? extends T> eventType) {
        return Builder.empty().on(eventType);
    }

    public static <T extends Event> Builder<T> startWith(EventHandler<? super T> handler) {
        return Builder.empty().addHandler(handler);
    }

    static <T extends Event> EventHandler<T> empty() {
        return EmptyEventHandler.instance();
    }

    @SafeVarargs
    public static <T extends Event> EventHandler<? super T> chain(EventHandler<? super T> ... handlers) {
        ArrayList nonEmptyHandlers = new ArrayList(handlers.length);
        for (EventHandler<? super T> handler : handlers) {
            if (handler == EventHandlerHelper.empty()) continue;
            nonEmptyHandlers.add(handler);
        }
        if (nonEmptyHandlers.isEmpty()) {
            return EventHandlerHelper.empty();
        }
        if (nonEmptyHandlers.size() == 1) {
            return (EventHandler)nonEmptyHandlers.get(0);
        }
        nonEmptyHandlers.trimToSize();
        return new CompositeEventHandler(nonEmptyHandlers);
    }

    public static <T extends Event> EventHandler<? super T> exclude(EventHandler<T> handler, EventHandler<?> subHandler) {
        if (handler instanceof CompositeEventHandler) {
            return ((CompositeEventHandler)handler).without(subHandler);
        }
        if (handler.equals(subHandler)) {
            return EventHandlerHelper.empty();
        }
        return handler;
    }

    public static <T extends Event> void install(ObjectProperty<EventHandler<? super T>> handlerProperty, EventHandler<? super T> handler) {
        EventHandler oldHandler = (EventHandler)handlerProperty.get();
        if (oldHandler != null) {
            handlerProperty.set(EventHandlerHelper.chain(handler, oldHandler));
        } else {
            handlerProperty.set(handler);
        }
    }

    public static <T extends Event> void installAfter(ObjectProperty<EventHandler<? super T>> handlerProperty, EventHandler<? super T> handler) {
        EventHandler oldHandler = (EventHandler)handlerProperty.get();
        if (oldHandler != null) {
            handlerProperty.set(EventHandlerHelper.chain(oldHandler, handler));
        } else {
            handlerProperty.set(handler);
        }
    }

    public static <T extends Event> void remove(ObjectProperty<EventHandler<? super T>> handlerProperty, EventHandler<? super T> handler) {
        EventHandler oldHandler = (EventHandler)handlerProperty.get();
        if (oldHandler != null) {
            handlerProperty.set(EventHandlerHelper.exclude(oldHandler, handler));
        }
    }

    private EventHandlerHelper() {
    }

    public static class On<T extends Event, U extends T> {
        private final Builder<? super T> previousBuilder;
        private final EventPattern<? super T, ? extends U> eventMatcher;

        private On(Builder<? super T> previous, EventPattern<? super T, ? extends U> eventMatcher) {
            this.previousBuilder = previous;
            this.eventMatcher = eventMatcher;
        }

        public On<T, U> where(Predicate<? super U> condition) {
            return new On<T, U>(this.previousBuilder, this.eventMatcher.and(condition));
        }

        public Builder<T> act(Consumer<? super U> action) {
            return this.previousBuilder.addHandler(t -> this.eventMatcher.match(t).ifPresent(u -> {
                action.accept((Object)u);
                t.consume();
            }));
        }
    }

    private static class CompositeBuilder<T extends Event>
    extends Builder<T> {
        private final Builder<? super T> previousBuilder;
        private final EventHandler<? super T> handler;

        private CompositeBuilder(Builder<? super T> previousBuilder, EventHandler<? super T> handler) {
            this.previousBuilder = previousBuilder;
            this.handler = handler;
        }

        @Override
        <U extends T> List<EventHandler<? super U>> getHandlers(int additionalCapacity) {
            List<EventHandler<U>> handlers = this.previousBuilder.getHandlers(additionalCapacity + 1);
            handlers.add(this.handler);
            return handlers;
        }
    }

    public static abstract class Builder<T extends Event> {
        private static <T extends Event> Builder<T> empty() {
            return new Builder<T>(){

                @Override
                <U extends T> List<EventHandler<? super U>> getHandlers(int additionalCapacity) {
                    return new ArrayList<EventHandler<? super U>>(additionalCapacity);
                }
            };
        }

        private Builder() {
        }

        public <U extends T> On<T, U> on(EventPattern<? super T, ? extends U> eventMatcher) {
            return new On(this, eventMatcher);
        }

        public <U extends T> On<T, U> on(EventType<? extends U> eventType) {
            return this.on(EventPattern.eventTypePattern(eventType));
        }

        public <U extends T> Builder<U> addHandler(EventHandler<? super U> handler) {
            return new CompositeBuilder(this, handler);
        }

        public final EventHandler<T> create() {
            List handlers = this.getHandlers();
            return new CompositeEventHandler(handlers);
        }

        List<EventHandler<? super T>> getHandlers() {
            return this.getHandlers(0);
        }

        abstract <U extends T> List<EventHandler<? super U>> getHandlers(int var1);
    }
}

