/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event;

import java.util.ArrayList;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventHandler;
import org.fxmisc.wellbehaved.event.EmptyEventHandler;
import org.fxmisc.wellbehaved.event.EventHandlerHelper;

class CompositeEventHandler<T extends Event>
implements EventHandler<T> {
    private final List<EventHandler<? super T>> handlers;

    CompositeEventHandler(List<EventHandler<? super T>> handlers) {
        this.handlers = handlers;
    }

    public void handle(T event) {
        for (EventHandler<? super T> eventHandler : this.handlers) {
            eventHandler.handle(event);
            if (!event.isConsumed()) continue;
            break;
        }
    }

    public EventHandler<? super T> without(EventHandler<?> other) {
        if (this.equals(other)) {
            return EmptyEventHandler.instance();
        }
        boolean changed = false;
        ArrayList<EventHandler<T>> newHandlers = new ArrayList<EventHandler<T>>(this.handlers.size());
        for (EventHandler<? super T> eventHandler : this.handlers) {
            EventHandler<? super T> h = EventHandlerHelper.exclude(eventHandler, other);
            if (h != eventHandler) {
                changed = true;
            }
            if (h == EmptyEventHandler.instance()) continue;
            newHandlers.add(h);
        }
        if (!changed) {
            return this;
        }
        if (newHandlers.isEmpty()) {
            return EmptyEventHandler.instance();
        }
        if (newHandlers.size() == 1) {
            return (EventHandler)newHandlers.get(0);
        }
        return new CompositeEventHandler<T>(newHandlers);
    }

    public boolean equals(Object other) {
        return other instanceof CompositeEventHandler && this.handlers.equals(((CompositeEventHandler)other).handlers);
    }

    public int hashCode() {
        return this.handlers.hashCode();
    }
}

