/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.idm;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.flowable.engine.common.impl.AbstractEngineConfiguration;
import org.flowable.engine.common.impl.EngineConfigurator;
import org.flowable.engine.impl.cfg.IdmEngineConfigurator;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.spring.SpringIdmEngineConfiguration;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.AbstractEngineAutoConfiguration;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.FlowableTransactionAutoConfiguration;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnIdmEngine;
import org.flowable.spring.boot.condition.ConditionalOnProcessEngine;
import org.flowable.spring.boot.idm.FlowableIdmProperties;
import org.flowable.spring.boot.idm.SpringPasswordEncoder;
import org.flowable.spring.configurator.SpringIdmEngineConfigurator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnIdmEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableIdmProperties.class})
@AutoConfigureAfter(value={FlowableTransactionAutoConfiguration.class})
@AutoConfigureBefore(value={ProcessEngineAutoConfiguration.class})
public class IdmEngineAutoConfiguration
extends AbstractEngineAutoConfiguration {
    protected final FlowableIdmProperties idmProperties;
    protected List<EngineConfigurationConfigurer<SpringIdmEngineConfiguration>> engineConfigurers = new ArrayList<EngineConfigurationConfigurer<SpringIdmEngineConfiguration>>();

    public IdmEngineAutoConfiguration(FlowableProperties flowableProperties, FlowableIdmProperties idmProperties) {
        super(flowableProperties);
        this.idmProperties = idmProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringIdmEngineConfiguration idmEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager) {
        SpringIdmEngineConfiguration configuration = new SpringIdmEngineConfiguration();
        configuration.setTransactionManager(platformTransactionManager);
        this.configureEngine((AbstractEngineConfiguration)configuration, dataSource);
        this.engineConfigurers.forEach(configurer -> configurer.configure(configuration));
        return configuration;
    }

    @Autowired(required=false)
    public void setEngineConfigurers(List<EngineConfigurationConfigurer<SpringIdmEngineConfiguration>> engineConfigurers) {
        this.engineConfigurers = engineConfigurers;
    }

    @Configuration
    @ConditionalOnProcessEngine
    public static class IdmEngineProcessConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"idmProcessEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> idmProcessEngineConfigurationConfigurer(IdmEngineConfigurator idmEngineConfigurator) {
            return processEngineConfiguration -> processEngineConfiguration.setIdmEngineConfigurator((EngineConfigurator)idmEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public IdmEngineConfigurator idmEngineConfigurator(IdmEngineConfiguration configuration) {
            SpringIdmEngineConfigurator idmEngineConfigurator = new SpringIdmEngineConfigurator();
            idmEngineConfigurator.setIdmEngineConfiguration(configuration);
            return idmEngineConfigurator;
        }
    }

    @ConditionalOnClass(value={PasswordEncoder.class})
    @Configuration
    @ConditionalOnProperty(prefix="flowable.idm.ldap", name={"enabled"}, havingValue="false", matchIfMissing=true)
    public static class PasswordEncoderConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public PasswordEncoder passwordEncoder(FlowableIdmProperties idmProperties) {
            String encoderType = idmProperties.getPasswordEncoder();
            Object encoder = Objects.equals("spring_bcrypt", encoderType) ? new BCryptPasswordEncoder() : NoOpPasswordEncoder.getInstance();
            return encoder;
        }

        @Bean
        @ConditionalOnBean(value={PasswordEncoder.class})
        @ConditionalOnMissingBean(name={"passwordEncoderIdmEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringIdmEngineConfiguration> passwordEncoderIdmEngineConfigurationConfigurer(PasswordEncoder passwordEncoder) {
            return idmEngineConfiguration -> idmEngineConfiguration.setPasswordEncoder((org.flowable.idm.api.PasswordEncoder)new SpringPasswordEncoder(passwordEncoder));
        }
    }
}

