/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.engine.common.impl.AbstractEngineConfiguration;
import org.flowable.engine.common.impl.EngineConfigurator;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.configurator.FormEngineConfigurator;
import org.flowable.form.spring.SpringFormEngineConfiguration;
import org.flowable.form.spring.configurator.SpringFormEngineConfigurator;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.AbstractSpringEngineAutoConfiguration;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.FlowableTransactionAutoConfiguration;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnFormEngine;
import org.flowable.spring.boot.condition.ConditionalOnProcessEngine;
import org.flowable.spring.boot.form.FlowableFormProperties;
import org.flowable.spring.common.SpringEngineConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnFormEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableFormProperties.class})
@AutoConfigureAfter(value={FlowableTransactionAutoConfiguration.class})
@AutoConfigureBefore(value={ProcessEngineAutoConfiguration.class})
public class FormEngineAutoConfiguration
extends AbstractSpringEngineAutoConfiguration {
    protected final FlowableFormProperties formProperties;
    protected List<EngineConfigurationConfigurer<SpringFormEngineConfiguration>> engineConfigurers = new ArrayList<EngineConfigurationConfigurer<SpringFormEngineConfiguration>>();

    public FormEngineAutoConfiguration(FlowableProperties flowableProperties, FlowableFormProperties formProperties) {
        super(flowableProperties);
        this.formProperties = formProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringFormEngineConfiguration formEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager) throws IOException {
        SpringFormEngineConfiguration configuration = new SpringFormEngineConfiguration();
        List<Resource> resources = this.discoverDeploymentResources(this.formProperties.getResourceLocation(), this.formProperties.getResourceSuffixes(), this.formProperties.isDeployResources());
        if (resources != null && !resources.isEmpty()) {
            configuration.setDeploymentResources(resources.toArray(new Resource[0]));
            configuration.setDeploymentName(this.formProperties.getDeploymentName());
        }
        this.configureSpringEngine((SpringEngineConfiguration)configuration, platformTransactionManager);
        this.configureEngine((AbstractEngineConfiguration)configuration, dataSource);
        this.engineConfigurers.forEach(configurer -> configurer.configure(configuration));
        return configuration;
    }

    @Autowired(required=false)
    public void setEngineConfigurers(List<EngineConfigurationConfigurer<SpringFormEngineConfiguration>> engineConfigurers) {
        this.engineConfigurers = engineConfigurers;
    }

    @Configuration
    @ConditionalOnProcessEngine
    public static class FormEngineProcessConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"formProcessEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> formProcessEngineConfigurationConfigurer(FormEngineConfigurator formEngineConfigurator) {
            return processEngineConfiguration -> processEngineConfiguration.addConfigurator((EngineConfigurator)formEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public FormEngineConfigurator formEngineConfigurator(FormEngineConfiguration configuration) {
            SpringFormEngineConfigurator formEngineConfigurator = new SpringFormEngineConfigurator();
            formEngineConfigurator.setFormEngineConfiguration(configuration);
            return formEngineConfigurator;
        }
    }
}

