/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.dmn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.configurator.DmnEngineConfigurator;
import org.flowable.dmn.spring.SpringDmnEngineConfiguration;
import org.flowable.dmn.spring.configurator.SpringDmnEngineConfigurator;
import org.flowable.engine.common.impl.AbstractEngineConfiguration;
import org.flowable.engine.common.impl.EngineConfigurator;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.AbstractSpringEngineAutoConfiguration;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.FlowableTransactionAutoConfiguration;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnDmnEngine;
import org.flowable.spring.boot.condition.ConditionalOnProcessEngine;
import org.flowable.spring.boot.dmn.FlowableDmnProperties;
import org.flowable.spring.common.SpringEngineConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnDmnEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableDmnProperties.class})
@AutoConfigureAfter(value={FlowableTransactionAutoConfiguration.class})
@AutoConfigureBefore(value={ProcessEngineAutoConfiguration.class})
public class DmnEngineAutoConfiguration
extends AbstractSpringEngineAutoConfiguration {
    protected final FlowableDmnProperties dmnProperties;
    protected List<EngineConfigurationConfigurer<SpringDmnEngineConfiguration>> engineConfigurers = new ArrayList<EngineConfigurationConfigurer<SpringDmnEngineConfiguration>>();

    public DmnEngineAutoConfiguration(FlowableProperties flowableProperties, FlowableDmnProperties dmnProperties) {
        super(flowableProperties);
        this.dmnProperties = dmnProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringDmnEngineConfiguration dmnEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager) throws IOException {
        SpringDmnEngineConfiguration configuration = new SpringDmnEngineConfiguration();
        List<Resource> resources = this.discoverDeploymentResources(this.dmnProperties.getResourceLocation(), this.dmnProperties.getResourceSuffixes(), this.dmnProperties.isDeployResources());
        if (resources != null && !resources.isEmpty()) {
            configuration.setDeploymentResources(resources.toArray(new Resource[0]));
            configuration.setDeploymentName(this.dmnProperties.getDeploymentName());
        }
        this.configureSpringEngine((SpringEngineConfiguration)configuration, platformTransactionManager);
        this.configureEngine((AbstractEngineConfiguration)configuration, dataSource);
        configuration.setHistoryEnabled(this.dmnProperties.isHistoryEnabled());
        configuration.setEnableSafeDmnXml(this.dmnProperties.isEnableSafeXml());
        configuration.setStrictMode(this.dmnProperties.isStrictMode());
        this.engineConfigurers.forEach(configurer -> configurer.configure(configuration));
        return configuration;
    }

    @Autowired(required=false)
    public void setEngineConfigurers(List<EngineConfigurationConfigurer<SpringDmnEngineConfiguration>> engineConfigurers) {
        this.engineConfigurers = engineConfigurers;
    }

    @Configuration
    @ConditionalOnProcessEngine
    public static class DmnEngineProcessConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"dmnProcessEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> dmnProcessEngineConfigurationConfigurer(DmnEngineConfigurator dmnEngineConfigurator) {
            return processEngineConfiguration -> processEngineConfiguration.addConfigurator((EngineConfigurator)dmnEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public DmnEngineConfigurator dmnEngineConfigurator(DmnEngineConfiguration configuration) {
            SpringDmnEngineConfigurator dmnEngineConfigurator = new SpringDmnEngineConfigurator();
            dmnEngineConfigurator.setDmnEngineConfiguration(configuration);
            return dmnEngineConfigurator;
        }
    }
}

