/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.content;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.content.engine.ContentEngineConfiguration;
import org.flowable.content.engine.configurator.ContentEngineConfigurator;
import org.flowable.content.spring.SpringContentEngineConfiguration;
import org.flowable.content.spring.configurator.SpringContentEngineConfigurator;
import org.flowable.engine.common.impl.AbstractEngineConfiguration;
import org.flowable.engine.common.impl.EngineConfigurator;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.AbstractEngineAutoConfiguration;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.FlowableTransactionAutoConfiguration;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnContentEngine;
import org.flowable.spring.boot.condition.ConditionalOnProcessEngine;
import org.flowable.spring.boot.content.FlowableContentProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnContentEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableContentProperties.class})
@AutoConfigureAfter(value={FlowableTransactionAutoConfiguration.class})
@AutoConfigureBefore(value={ProcessEngineAutoConfiguration.class})
public class ContentEngineAutoConfiguration
extends AbstractEngineAutoConfiguration {
    protected final FlowableContentProperties contentProperties;
    protected List<EngineConfigurationConfigurer<SpringContentEngineConfiguration>> engineConfigurers = new ArrayList<EngineConfigurationConfigurer<SpringContentEngineConfiguration>>();

    public ContentEngineAutoConfiguration(FlowableProperties flowableProperties, FlowableContentProperties contentProperties) {
        super(flowableProperties);
        this.contentProperties = contentProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringContentEngineConfiguration contentEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager) {
        SpringContentEngineConfiguration configuration = new SpringContentEngineConfiguration();
        configuration.setTransactionManager(platformTransactionManager);
        this.configureEngine((AbstractEngineConfiguration)configuration, dataSource);
        FlowableContentProperties.Storage storage = this.contentProperties.getStorage();
        configuration.setContentRootFolder(storage.getRootFolder());
        configuration.setCreateContentRootFolder(storage.getCreateRoot());
        this.engineConfigurers.forEach(configurer -> configurer.configure(configuration));
        return configuration;
    }

    @Autowired(required=false)
    public void setEngineConfigurers(List<EngineConfigurationConfigurer<SpringContentEngineConfiguration>> engineConfigurers) {
        this.engineConfigurers = engineConfigurers;
    }

    @Configuration
    @ConditionalOnProcessEngine
    public static class ContentEngineProcessConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"contentProcessEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> contentProcessEngineConfigurationConfigurer(ContentEngineConfigurator contentEngineConfigurator) {
            return processEngineConfiguration -> processEngineConfiguration.addConfigurator((EngineConfigurator)contentEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public ContentEngineConfigurator contentEngineConfigurator(ContentEngineConfiguration configuration) {
            SpringContentEngineConfigurator contentEngineConfigurator = new SpringContentEngineConfigurator();
            contentEngineConfigurator.setContentEngineConfiguration(configuration);
            return contentEngineConfigurator;
        }
    }
}

