/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.rest.service.api.CmmnRestUrls;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.common.rest.resolver.DefaultContentTypeResolver;
import org.flowable.content.engine.ContentEngine;
import org.flowable.content.rest.ContentRestUrls;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.rest.service.api.DmnRestUrls;
import org.flowable.engine.ProcessEngine;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.rest.FormRestUrls;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.rest.service.api.IdmRestResponseFactory;
import org.flowable.rest.service.api.RestUrls;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.SecurityAutoConfiguration;
import org.flowable.spring.boot.cmmn.CmmnEngineRestConfiguration;
import org.flowable.spring.boot.cmmn.CmmnEngineServicesAutoConfiguration;
import org.flowable.spring.boot.cmmn.FlowableCmmnProperties;
import org.flowable.spring.boot.content.ContentEngineRestConfiguration;
import org.flowable.spring.boot.content.ContentEngineServicesAutoConfiguration;
import org.flowable.spring.boot.content.FlowableContentProperties;
import org.flowable.spring.boot.dmn.DmnEngineRestConfiguration;
import org.flowable.spring.boot.dmn.DmnEngineServicesAutoConfiguration;
import org.flowable.spring.boot.dmn.FlowableDmnProperties;
import org.flowable.spring.boot.form.FlowableFormProperties;
import org.flowable.spring.boot.form.FormEngineRestConfiguration;
import org.flowable.spring.boot.form.FormEngineServicesAutoConfiguration;
import org.flowable.spring.boot.idm.FlowableIdmProperties;
import org.flowable.spring.boot.idm.IdmEngineRestConfiguration;
import org.flowable.spring.boot.idm.IdmEngineServicesAutoConfiguration;
import org.flowable.spring.boot.process.FlowableProcessProperties;
import org.flowable.spring.boot.process.ProcessEngineRestConfiguration;
import org.flowable.spring.boot.rest.BaseRestApiConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ContentTypeResolver.class})
@ConditionalOnWebApplication
@AutoConfigureAfter(value={SecurityAutoConfiguration.class, ProcessEngineAutoConfiguration.class, CmmnEngineServicesAutoConfiguration.class, ContentEngineServicesAutoConfiguration.class, DmnEngineServicesAutoConfiguration.class, FormEngineServicesAutoConfiguration.class, IdmEngineServicesAutoConfiguration.class})
public class RestApiAutoConfiguration {
    @Bean
    public ContentTypeResolver contentTypeResolver() {
        DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
        return resolver;
    }

    @Configuration
    @ConditionalOnClass(value={IdmRestResponseFactory.class})
    @ConditionalOnBean(value={IdmEngine.class})
    public static class IdmEngineRestApiConfiguration
    extends BaseRestApiConfiguration {
        @Bean
        public ServletRegistrationBean idmServlet(FlowableIdmProperties properties) {
            return this.registerServlet(properties.getServlet(), IdmEngineRestConfiguration.class);
        }
    }

    @Configuration
    @ConditionalOnClass(value={FormRestUrls.class})
    @ConditionalOnBean(value={FormEngine.class})
    public static class FormEngineRestApiConfiguration
    extends BaseRestApiConfiguration {
        @Bean
        public ServletRegistrationBean formServlet(FlowableFormProperties properties) {
            return this.registerServlet(properties.getServlet(), FormEngineRestConfiguration.class);
        }
    }

    @Configuration
    @ConditionalOnClass(value={DmnRestUrls.class})
    @ConditionalOnBean(value={DmnEngine.class})
    public static class DmnEngineRestApiConfiguration
    extends BaseRestApiConfiguration {
        @Bean
        public ServletRegistrationBean dmnServlet(FlowableDmnProperties properties) {
            return this.registerServlet(properties.getServlet(), DmnEngineRestConfiguration.class);
        }
    }

    @Configuration
    @ConditionalOnClass(value={ContentRestUrls.class})
    @ConditionalOnBean(value={ContentEngine.class})
    public static class ContentEngineRestApiConfiguration
    extends BaseRestApiConfiguration {
        @Bean
        public ServletRegistrationBean contentServlet(FlowableContentProperties properties) {
            return this.registerServlet(properties.getServlet(), ContentEngineRestConfiguration.class);
        }
    }

    @Configuration
    @ConditionalOnClass(value={CmmnRestUrls.class})
    @ConditionalOnBean(value={CmmnEngine.class})
    public static class CmmnEngineRestApiConfiguration
    extends BaseRestApiConfiguration {
        @Bean
        public ServletRegistrationBean cmmnServlet(FlowableCmmnProperties properties) {
            return this.registerServlet(properties.getServlet(), CmmnEngineRestConfiguration.class);
        }
    }

    @Configuration
    @ConditionalOnClass(value={RestUrls.class})
    @ConditionalOnBean(value={ProcessEngine.class})
    @EnableConfigurationProperties(value={FlowableProcessProperties.class})
    public static class ProcessEngineRestApiConfiguration
    extends BaseRestApiConfiguration {
        @Bean
        public ServletRegistrationBean processService(FlowableProcessProperties properties) {
            return this.registerServlet(properties.getServlet(), ProcessEngineRestConfiguration.class);
        }
    }
}

