/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.engine.DynamicBpmnService;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.common.impl.AbstractEngineConfiguration;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.spring.ProcessEngineFactoryBean;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.AbstractSpringEngineAutoConfiguration;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.FlowableJobConfiguration;
import org.flowable.spring.boot.FlowableMailProperties;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.FlowableTransactionAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnProcessEngine;
import org.flowable.spring.boot.idm.FlowableIdmProperties;
import org.flowable.spring.boot.process.FlowableProcessProperties;
import org.flowable.spring.boot.process.Process;
import org.flowable.spring.common.SpringEngineConfiguration;
import org.flowable.spring.job.service.SpringAsyncExecutor;
import org.flowable.spring.job.service.SpringRejectedJobsHandler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.Resource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnProcessEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableMailProperties.class, FlowableProcessProperties.class, FlowableIdmProperties.class})
@AutoConfigureAfter(value={FlowableTransactionAutoConfiguration.class})
@Import(value={FlowableJobConfiguration.class})
public class ProcessEngineAutoConfiguration
extends AbstractSpringEngineAutoConfiguration {
    @Autowired(required=false)
    private List<EngineConfigurationConfigurer<SpringProcessEngineConfiguration>> processEngineConfigurationConfigurers = new ArrayList<EngineConfigurationConfigurer<SpringProcessEngineConfiguration>>();
    protected final FlowableProcessProperties processProperties;
    protected final FlowableIdmProperties idmProperties;
    protected final FlowableMailProperties mailProperties;

    public ProcessEngineAutoConfiguration(FlowableProperties flowableProperties, FlowableProcessProperties processProperties, FlowableIdmProperties idmProperties, FlowableMailProperties mailProperties) {
        super(flowableProperties);
        this.processProperties = processProperties;
        this.idmProperties = idmProperties;
        this.mailProperties = mailProperties;
    }

    @Bean
    @Process
    @ConfigurationProperties(prefix="flowable.process.async.executor")
    @ConditionalOnMissingBean(name={"processAsyncExecutor"})
    public SpringAsyncExecutor processAsyncExecutor(ObjectProvider<TaskExecutor> taskExecutor, @Process ObjectProvider<TaskExecutor> processTaskExecutor, ObjectProvider<SpringRejectedJobsHandler> rejectedJobsHandler, @Process ObjectProvider<SpringRejectedJobsHandler> processRejectedJobsHandler) {
        return new SpringAsyncExecutor(this.getIfAvailable(processTaskExecutor, taskExecutor), this.getIfAvailable(processRejectedJobsHandler, rejectedJobsHandler));
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringProcessEngineConfiguration springProcessEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager, @Process ObjectProvider<AsyncExecutor> asyncExecutorProvider) throws IOException {
        AsyncExecutor springAsyncExecutor;
        SpringProcessEngineConfiguration conf = new SpringProcessEngineConfiguration();
        List<Resource> resources = this.discoverDeploymentResources(this.flowableProperties.getProcessDefinitionLocationPrefix(), this.flowableProperties.getProcessDefinitionLocationSuffixes(), this.flowableProperties.isCheckProcessDefinitions());
        if (resources != null && !resources.isEmpty()) {
            conf.setDeploymentResources(resources.toArray(new Resource[0]));
            conf.setDeploymentName(this.flowableProperties.getDeploymentName());
        }
        if ((springAsyncExecutor = (AsyncExecutor)asyncExecutorProvider.getIfUnique()) != null) {
            conf.setAsyncExecutor(springAsyncExecutor);
        }
        this.configureSpringEngine((SpringEngineConfiguration)conf, platformTransactionManager);
        this.configureEngine((AbstractEngineConfiguration)conf, dataSource);
        conf.setDeploymentName(this.defaultText(this.flowableProperties.getDeploymentName(), conf.getDeploymentName()));
        conf.setDisableIdmEngine(!this.flowableProperties.isDbIdentityUsed() || !this.idmProperties.isEnabled());
        conf.setAsyncExecutorActivate(this.flowableProperties.isAsyncExecutorActivate());
        conf.setMailServerHost(this.mailProperties.getHost());
        conf.setMailServerPort(this.mailProperties.getPort());
        conf.setMailServerUsername(this.mailProperties.getUsername());
        conf.setMailServerPassword(this.mailProperties.getPassword());
        conf.setMailServerDefaultFrom(this.mailProperties.getDefaultFrom());
        conf.setMailServerUseSSL(this.mailProperties.isUseSsl());
        conf.setMailServerUseTLS(this.mailProperties.isUseTls());
        conf.setEnableProcessDefinitionHistoryLevel(this.processProperties.isEnableProcessDefinitionHistoryLevel());
        conf.setProcessDefinitionCacheLimit(this.processProperties.getDefinitionCacheLimit());
        conf.setEnableSafeBpmnXml(this.processProperties.isEnableSafeXml());
        conf.setHistoryLevel(this.flowableProperties.getHistoryLevel());
        this.processEngineConfigurationConfigurers.forEach(configurator -> configurator.configure(conf));
        return conf;
    }

    @Bean
    public ProcessEngineFactoryBean processEngine(SpringProcessEngineConfiguration configuration) throws Exception {
        ProcessEngineFactoryBean processEngineFactoryBean = new ProcessEngineFactoryBean();
        processEngineFactoryBean.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)configuration);
        return processEngineFactoryBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public RuntimeService runtimeServiceBean(ProcessEngine processEngine) {
        return processEngine.getRuntimeService();
    }

    @Bean
    @ConditionalOnMissingBean
    public RepositoryService repositoryServiceBean(ProcessEngine processEngine) {
        return processEngine.getRepositoryService();
    }

    @Bean
    @ConditionalOnMissingBean
    public TaskService taskServiceBean(ProcessEngine processEngine) {
        return processEngine.getTaskService();
    }

    @Bean
    @ConditionalOnMissingBean
    public HistoryService historyServiceBean(ProcessEngine processEngine) {
        return processEngine.getHistoryService();
    }

    @Bean
    @ConditionalOnMissingBean
    public ManagementService managementServiceBean(ProcessEngine processEngine) {
        return processEngine.getManagementService();
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicBpmnService dynamicBpmnServiceBean(ProcessEngine processEngine) {
        return processEngine.getDynamicBpmnService();
    }

    @Bean
    @ConditionalOnMissingBean
    public FormService formServiceBean(ProcessEngine processEngine) {
        return processEngine.getFormService();
    }

    @Bean
    @ConditionalOnMissingBean
    public IdentityService identityServiceBean(ProcessEngine processEngine) {
        return processEngine.getIdentityService();
    }
}

