/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.flowable.engine.ProcessEngine;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, TransactionAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
public class FlowableTransactionAutoConfiguration {

    @Configuration
    @ConditionalOnClass(name={"javax.persistence.EntityManagerFactory"})
    public static class JpaTransactionConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public PlatformTransactionManager transactionManager(EntityManagerFactory emf) {
            return new JpaTransactionManager(emf);
        }

        @ConditionalOnClass(value={ProcessEngine.class})
        @ConditionalOnMissingBean(name={"jpaProcessEngineConfigurer"})
        @Bean
        public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> jpaProcessEngineConfigurer(EntityManagerFactory emf) {
            return processEngineConfiguration -> {
                processEngineConfiguration.setJpaEntityManagerFactory((Object)emf);
                processEngineConfiguration.setJpaHandleTransaction(false);
                processEngineConfiguration.setJpaCloseEntityManager(false);
            };
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"javax.persistence.EntityManagerFactory"})
    public static class DataSourceConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public PlatformTransactionManager transactionManager(DataSource dataSource) {
            return new DataSourceTransactionManager(dataSource);
        }
    }
}

