/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ldap.impl;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.idm.api.Group;
import org.flowable.idm.engine.impl.GroupQueryImpl;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntityImpl;
import org.flowable.ldap.LDAPCallBack;
import org.flowable.ldap.LDAPConfiguration;
import org.flowable.ldap.LDAPGroupCache;
import org.flowable.ldap.LDAPTemplate;

public class LDAPGroupQueryImpl
extends GroupQueryImpl {
    private static final long serialVersionUID = 1L;
    protected LDAPConfiguration ldapConfigurator;
    protected LDAPGroupCache ldapGroupCache;

    public LDAPGroupQueryImpl(LDAPConfiguration ldapConfigurator, LDAPGroupCache ldapGroupCache) {
        this.ldapConfigurator = ldapConfigurator;
        this.ldapGroupCache = ldapGroupCache;
    }

    public long executeCount(CommandContext commandContext) {
        return this.executeQuery().size();
    }

    public List<Group> executeList(CommandContext commandContext) {
        return this.executeQuery();
    }

    protected List<Group> executeQuery() {
        if (this.getUserId() != null) {
            return this.findGroupsByUser(this.getUserId());
        }
        return this.findAllGroups();
    }

    protected List<Group> findGroupsByUser(String userId) {
        List<Group> groups;
        if (this.ldapGroupCache != null && (groups = this.ldapGroupCache.get(userId)) != null) {
            return groups;
        }
        String searchExpression = this.ldapConfigurator.getLdapQueryBuilder().buildQueryGroupsForUser(this.ldapConfigurator, userId);
        List<Group> groups2 = this.executeGroupQuery(searchExpression);
        if (this.ldapGroupCache != null) {
            this.ldapGroupCache.add(userId, groups2);
        }
        return groups2;
    }

    protected List<Group> findAllGroups() {
        String searchExpression = this.ldapConfigurator.getQueryAllGroups();
        List<Group> groups = this.executeGroupQuery(searchExpression);
        return groups;
    }

    protected List<Group> executeGroupQuery(final String searchExpression) {
        LDAPTemplate ldapTemplate = new LDAPTemplate(this.ldapConfigurator);
        return ldapTemplate.execute(new LDAPCallBack<List<Group>>(){

            @Override
            public List<Group> executeInContext(InitialDirContext initialDirContext) {
                ArrayList<Group> groups = new ArrayList<Group>();
                try {
                    String baseDn = LDAPGroupQueryImpl.this.ldapConfigurator.getGroupBaseDn() != null ? LDAPGroupQueryImpl.this.ldapConfigurator.getGroupBaseDn() : LDAPGroupQueryImpl.this.ldapConfigurator.getBaseDn();
                    NamingEnumeration<SearchResult> namingEnum = initialDirContext.search(baseDn, searchExpression, LDAPGroupQueryImpl.this.createSearchControls());
                    while (namingEnum.hasMore()) {
                        SearchResult result = namingEnum.next();
                        GroupEntityImpl group = new GroupEntityImpl();
                        if (LDAPGroupQueryImpl.this.ldapConfigurator.getGroupIdAttribute() != null) {
                            group.setId(result.getAttributes().get(LDAPGroupQueryImpl.this.ldapConfigurator.getGroupIdAttribute()).get().toString());
                        }
                        if (LDAPGroupQueryImpl.this.ldapConfigurator.getGroupNameAttribute() != null) {
                            group.setName(result.getAttributes().get(LDAPGroupQueryImpl.this.ldapConfigurator.getGroupNameAttribute()).get().toString());
                        }
                        if (LDAPGroupQueryImpl.this.ldapConfigurator.getGroupTypeAttribute() != null) {
                            group.setType(result.getAttributes().get(LDAPGroupQueryImpl.this.ldapConfigurator.getGroupTypeAttribute()).get().toString());
                        }
                        groups.add((Group)group);
                    }
                    namingEnum.close();
                    return groups;
                }
                catch (NamingException e) {
                    throw new FlowableException("Could not find groups " + searchExpression, (Throwable)e);
                }
            }
        });
    }

    protected SearchControls createSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setTimeLimit(this.ldapConfigurator.getSearchTimeLimit());
        return searchControls;
    }
}

