/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharDoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.map.primitive.CharDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleCharMap;
import org.eclipse.collections.api.map.primitive.MutableCharDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.CharDoublePair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedCharDoubleProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import org.eclipse.collections.impl.factory.primitive.DoubleCharMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.map.mutable.primitive.CharDoubleHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;

final class ImmutableCharDoubleHashMap
implements ImmutableCharDoubleMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableCharDoubleMap delegate;

    ImmutableCharDoubleHashMap(CharDoubleMap delegate) {
        this.delegate = new CharDoubleHashMap(delegate);
    }

    public double get(char key) {
        return this.delegate.get(key);
    }

    public double getIfAbsent(char key, double ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public double getOrThrow(char key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(char key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(double value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(DoubleProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(CharProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(CharDoubleProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyCharIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<CharDoublePair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableDoubleCharMap flipUniqueValues() {
        MutableDoubleCharMap result = DoubleCharMaps.mutable.empty();
        this.forEachKeyValue((CharDoubleProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    public ImmutableCharDoubleMap select(CharDoublePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableCharDoubleMap reject(CharDoublePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableCharDoubleMap toImmutable() {
        return this;
    }

    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator((DoubleIterator)this.delegate.doubleIterator());
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    public void each(DoubleProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(DoublePredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableDoubleBag select(DoublePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleBag reject(DoublePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(DoubleToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public double sum() {
        return this.delegate.sum();
    }

    public double max() {
        return this.delegate.max();
    }

    public double maxIfEmpty(double defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double min() {
        return this.delegate.min();
    }

    public double minIfEmpty(double defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public double[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableDoubleList toSortedList() {
        return this.delegate.toSortedList();
    }

    public double[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(double value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(double ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableDoubleList toList() {
        return this.delegate.toList();
    }

    public MutableDoubleSet toSet() {
        return this.delegate.toSet();
    }

    public MutableDoubleBag toBag() {
        return this.delegate.toBag();
    }

    public LazyDoubleIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableCharDoubleMap newWithKeyValue(char key, double value) {
        CharDoubleHashMap map = new CharDoubleHashMap(this.size() + 1);
        map.putAll((CharDoubleMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableCharDoubleMap newWithoutKey(char key) {
        CharDoubleHashMap map = new CharDoubleHashMap(this.size());
        map.putAll((CharDoubleMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableCharDoubleMap newWithoutAllKeys(CharIterable keys) {
        CharDoubleHashMap map = new CharDoubleHashMap(this.size());
        map.putAll((CharDoubleMap)this);
        CharIterator iterator = keys.charIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(this.delegate.keySet());
    }

    public MutableDoubleCollection values() {
        return UnmodifiableDoubleCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableCharDoubleMapSerializationProxy((CharDoubleMap)this);
    }

    protected static class ImmutableCharDoubleMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private CharDoubleMap map;

        public ImmutableCharDoubleMapSerializationProxy() {
        }

        protected ImmutableCharDoubleMapSerializationProxy(CharDoubleMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((CharDoubleProcedure)new CheckedCharDoubleProcedure(){

                    @Override
                    public void safeValue(char key, double value) throws IOException {
                        out.writeChar(key);
                        out.writeDouble(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            CharDoubleHashMap deserializedMap = new CharDoubleHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readChar(), in.readDouble());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

