/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.dwrp.BaseScriptConduit;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.ScriptBufferUtil;

public class HtmlScriptConduit
extends BaseScriptConduit {
    public HtmlScriptConduit(HttpServletResponse response, String batchId, ConverterManager converterManager) throws IOException {
        super(response, batchId, converterManager);
    }

    protected String getOutboundMimeType() {
        return "text/html";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginStream() {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println("<html><body>");
            this.out.println("<script type=\"text/javascript\">");
            this.out.println(EnginePrivate.remoteBeginIFrameResponse(this.batchId, true));
            this.out.println("</script>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endStream() {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println("<script type=\"text/javascript\">");
            this.out.println(EnginePrivate.remoteEndIFrameResponse(this.batchId, true));
            this.out.println("</script>");
            this.out.println("</body></html>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addScript(ScriptBuffer scriptBuffer) throws IOException, MarshallException {
        String script = ScriptBufferUtil.createOutput(scriptBuffer, this.converterManager);
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println("<script type=\"text/javascript\">");
            this.out.println(EnginePrivate.remoteEval(script));
            this.out.println("</script>");
            return this.flush();
        }
    }
}

