/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.test;

import java.util.Map;
import org.databene.commons.Named;
import org.databene.commons.collection.NameMap;
import org.databene.jdbacl.model.DBColumn;
import org.databene.jdbacl.model.DBDataType;
import org.databene.jdbacl.model.DBForeignKeyConstraint;
import org.databene.jdbacl.model.DBPrimaryKeyConstraint;
import org.databene.jdbacl.model.DBTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelTestUtil {
    public static Map<String, DBTable> createCountryStateCityWithCompositePK() {
        DBDataType INT = DBDataType.getInstance("INT");
        DBTable country = new DBTable("country");
        new DBColumn("co_id1", country, INT);
        new DBColumn("co_id2", country, INT);
        new DBPrimaryKeyConstraint(country, "COUNTRY_PK", true, "co_id1", "co_id2");
        DBTable state = new DBTable("state");
        new DBColumn("st_id1", state, INT);
        new DBColumn("st_id2", state, INT);
        new DBColumn("co_fk1", state, INT);
        new DBColumn("co_fk2", state, INT);
        new DBPrimaryKeyConstraint(state, "STATE_PK", true, "st_id1", "st_id2");
        new DBForeignKeyConstraint("ST_CO_FK", true, state, new String[]{"co_fk1", "co_fk2"}, country, new String[]{"co_id1", "co_id2"});
        DBTable city = new DBTable("city");
        new DBColumn("id", city, INT);
        new DBPrimaryKeyConstraint(state, "CITY_PK", true, "ci_id");
        new DBForeignKeyConstraint("CI_ST_FK", true, city, new String[]{"st_fk1", "st_fk2"}, state, new String[]{"st_id1", "st_id2"});
        new DBForeignKeyConstraint("CI_CO_FK", true, city, new String[]{"co_fk1", "co_fk2"}, country, new String[]{"co_id1", "co_id2"});
        return new NameMap((Named[])new DBTable[]{country, state, city});
    }
}

