/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import org.databene.commons.ConnectFailedException;
import org.databene.commons.ImportFailedException;
import org.databene.commons.ui.swing.SwingTreeModelAdapter;
import org.databene.jdbacl.DatabaseTreeModel;
import org.databene.jdbacl.model.DBMetaDataImporter;
import org.databene.jdbacl.model.Database;
import org.databene.jdbacl.model.jdbc.JDBCMetaDataUtil;
import org.databene.jdbacl.swing.DatabaseTree;
import org.databene.jdbacl.swing.TextFieldValueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePane
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabasePane.class);
    private JScrollPane scrollPane;
    private DatabaseTree tree;
    private DBMetaDataImporter importer;
    private TextFieldValueProvider exclusionPatternProvider;

    public DatabasePane(TextFieldValueProvider exclusionPatternProvider) {
        super(new BorderLayout());
        this.exclusionPatternProvider = exclusionPatternProvider;
        this.scrollPane = new JScrollPane();
        this.add((Component)this.scrollPane, "Center");
    }

    public void setEnvironment(String environment) throws ConnectFailedException, ImportFailedException {
        if (this.importer != null) {
            try {
                this.importer.close();
            }
            catch (IOException e) {
                LOGGER.error("Error closing " + this.getClass().getName(), (Throwable)e);
            }
            if (this.tree != null) {
                this.scrollPane.remove(this.tree);
            }
        }
        new Thread(new Importer(environment)).start();
    }

    class Importer
    implements Runnable {
        String environment;

        public Importer(String environment) {
            this.environment = environment;
        }

        public void run() {
            try {
                Database database = JDBCMetaDataUtil.getMetaData(this.environment, true, true, true, true, ".*", DatabasePane.this.exclusionPatternProvider.getValue(), true, true);
                DatabasePane.this.importer = DatabasePane.this.importer;
                SwingTreeModelAdapter model = new SwingTreeModelAdapter((org.databene.commons.TreeModel)new DatabaseTreeModel(database));
                SwingUtilities.invokeLater(new Runnable((TreeModel)model){
                    final /* synthetic */ TreeModel val$model;
                    {
                        this.val$model = treeModel;
                    }

                    public void run() {
                        DatabasePane.this.tree = new DatabaseTree(this.val$model);
                        DatabasePane.this.scrollPane.setViewportView(DatabasePane.this.tree);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

