/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model.xml;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Set;
import org.databene.commons.IOUtil;
import org.databene.commons.xml.SimpleXMLWriter;
import org.databene.jdbacl.SQLUtil;
import org.databene.jdbacl.model.DBCatalog;
import org.databene.jdbacl.model.DBCheckConstraint;
import org.databene.jdbacl.model.DBColumn;
import org.databene.jdbacl.model.DBForeignKeyConstraint;
import org.databene.jdbacl.model.DBIndex;
import org.databene.jdbacl.model.DBMetaDataExporter;
import org.databene.jdbacl.model.DBPackage;
import org.databene.jdbacl.model.DBPrimaryKeyConstraint;
import org.databene.jdbacl.model.DBProcedure;
import org.databene.jdbacl.model.DBSchema;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.DBTrigger;
import org.databene.jdbacl.model.DBUniqueConstraint;
import org.databene.jdbacl.model.Database;
import org.databene.jdbacl.model.FKChangeRule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLModelExporter
implements DBMetaDataExporter {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private File file;
    private String encoding;
    private boolean lazy;

    public XMLModelExporter(File file) {
        this(file, true);
    }

    public XMLModelExporter(File file, boolean lazy) {
        this(file, "UTF-8", lazy);
    }

    public XMLModelExporter(File file, String encoding, boolean lazy) {
        this.file = file;
        this.encoding = encoding;
        this.lazy = lazy;
    }

    @Override
    public void export(Database database) throws IOException, SQLException {
        FileOutputStream out = new FileOutputStream(this.file);
        SimpleXMLWriter writer = null;
        try {
            writer = new SimpleXMLWriter((OutputStream)out, this.encoding, true);
            writer.startDocument();
            this.exportDatabase(database, writer);
            writer.endDocument();
        }
        catch (SAXException e) {
            try {
                throw new RuntimeException("Error exporting database " + database, e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)writer);
    }

    private void exportDatabase(Database database, SimpleXMLWriter writer) throws SAXException {
        AttributesImpl attribs = SimpleXMLWriter.createAttributes((String)"environment", (String)database.getName());
        if (database.getDatabaseProductName() != null) {
            SimpleXMLWriter.addAttribute((String)"databaseProductName", (String)database.getDatabaseProductName(), (AttributesImpl)attribs);
        }
        if (database.getDatabaseProductVersion() != null) {
            SimpleXMLWriter.addAttribute((String)"databaseProductVersion", (String)database.getDatabaseProductVersion().toString(), (AttributesImpl)attribs);
        }
        if (database.getImportDate() != null) {
            SimpleXMLWriter.addAttribute((String)"importDate", (String)this.sdf.format(database.getImportDate()), (AttributesImpl)attribs);
        }
        SimpleXMLWriter.addAttribute((String)"user", (String)database.getUser(), (AttributesImpl)attribs);
        SimpleXMLWriter.addAttribute((String)"tableInclusionPattern", (String)database.getTableInclusionPattern(), (AttributesImpl)attribs);
        SimpleXMLWriter.addAttribute((String)"tableExclusionPattern", (String)database.getTableExclusionPattern(), (AttributesImpl)attribs);
        SimpleXMLWriter.addAttribute((String)"checksImported", (String)String.valueOf(database.isChecksImported()), (AttributesImpl)attribs);
        SimpleXMLWriter.addAttribute((String)"sequencesImported", (String)String.valueOf(database.isSequencesImported()), (AttributesImpl)attribs);
        SimpleXMLWriter.addAttribute((String)"triggersImported", (String)String.valueOf(database.isTriggersImported()), (AttributesImpl)attribs);
        SimpleXMLWriter.addAttribute((String)"packagesImported", (String)String.valueOf(database.isSequencesImported()), (AttributesImpl)attribs);
        writer.startElement("database", (Attributes)attribs);
        for (DBCatalog catalog : database.getCatalogs()) {
            this.exportCatalog(catalog, writer);
        }
        writer.endElement("database");
    }

    private void exportCatalog(DBCatalog catalog, SimpleXMLWriter writer) throws SAXException {
        writer.startElement("catalog", (Attributes)SimpleXMLWriter.createAttributes((String)"name", (String)catalog.getName()));
        for (DBSchema schema : catalog.getSchemas()) {
            this.exportSchema(schema, writer);
        }
        writer.endElement("catalog");
    }

    private void exportSchema(DBSchema schema, SimpleXMLWriter writer) throws SAXException {
        Database db = schema.getDatabase();
        AttributesImpl atts = SimpleXMLWriter.createAttributes((String)"name", (String)schema.getName());
        writer.startElement("schema", (Attributes)atts);
        for (DBTable table : schema.getTables()) {
            this.exportTable(table, writer);
        }
        if (db.isSequencesImported()) {
            for (DBSequence sequence : schema.getSequences(true)) {
                this.exportSequence(sequence, writer);
            }
        }
        if (db.isTriggersImported()) {
            for (DBTrigger trigger : schema.getTriggers()) {
                this.exportTrigger(trigger, writer);
            }
        }
        if (db.isPackagesImported()) {
            for (DBPackage pkg : schema.getPackages()) {
                this.exportPackage(pkg, writer);
            }
        }
        writer.endElement("schema");
    }

    private void exportTable(DBTable table, SimpleXMLWriter writer) throws SAXException {
        AttributesImpl atts = SimpleXMLWriter.createAttributes((String)"name", (String)table.getName());
        if (this.lazy && !table.isPKImported()) {
            SimpleXMLWriter.addAttribute((String)"pkImported", (String)"false", (AttributesImpl)atts);
        }
        if (this.lazy && !table.areFKsImported()) {
            SimpleXMLWriter.addAttribute((String)"fksImported", (String)"false", (AttributesImpl)atts);
        }
        if (this.lazy && !table.areIndexesImported()) {
            SimpleXMLWriter.addAttribute((String)"indexesImported", (String)"false", (AttributesImpl)atts);
        }
        if (this.lazy && !table.areChecksImported()) {
            SimpleXMLWriter.addAttribute((String)"checksImported", (String)"false", (AttributesImpl)atts);
        }
        writer.startElement("table", (Attributes)atts);
        for (DBColumn column : table.getColumns()) {
            this.exportColumn(column, writer);
        }
        this.exportPK(table, writer);
        this.exportFKs(table, writer);
        this.exportUKsAndIndexes(table, writer);
        this.exportChecks(table, writer);
        writer.endElement("table");
    }

    private void exportColumn(DBColumn column, SimpleXMLWriter writer) throws SAXException {
        AttributesImpl atts = SimpleXMLWriter.createAttributes((String)"name", (String)column.getName());
        SimpleXMLWriter.addAttribute((String)"default", (String)column.getDefaultValue(), (AttributesImpl)atts);
        SimpleXMLWriter.addAttribute((String)"jdbcType", (String)String.valueOf(column.getType().getJdbcType()), (AttributesImpl)atts);
        SimpleXMLWriter.addAttribute((String)"type", (String)SQLUtil.renderColumnTypeWithSize(column), (AttributesImpl)atts);
        SimpleXMLWriter.addAttribute((String)"nullable", (String)(column.isNullable() ? null : "false"), (AttributesImpl)atts);
        writer.startElement("column", (Attributes)atts);
        writer.endElement("column");
    }

    private void exportPK(DBTable table, SimpleXMLWriter writer) throws SAXException {
        DBPrimaryKeyConstraint pk;
        if (!this.lazy) {
            table.havePKImported();
        }
        if (table.isPKImported() && (pk = table.getPrimaryKeyConstraint()) != null) {
            this.exportPK(pk, writer);
        }
    }

    private void exportPK(DBPrimaryKeyConstraint pk, SimpleXMLWriter writer) throws SAXException {
        AttributesImpl pkAtts = SimpleXMLWriter.createAttributes((String)"name", (String)pk.getName());
        String[] pkColumnNames = pk.getColumnNames();
        if (pkColumnNames.length == 1) {
            SimpleXMLWriter.addAttribute((String)"column", (String)pkColumnNames[0], (AttributesImpl)pkAtts);
        }
        writer.startElement("pk", (Attributes)pkAtts);
        if (pkColumnNames.length > 1) {
            this.writeColumnGroup(pkColumnNames, writer);
        }
        writer.endElement("pk");
    }

    public void exportFKs(DBTable table, SimpleXMLWriter writer) throws SAXException {
        if (!this.lazy || table.areFKsImported()) {
            this.exportFks(table.getForeignKeyConstraints(), writer);
        }
    }

    public void exportUKsAndIndexes(DBTable table, SimpleXMLWriter writer) throws SAXException {
        if (!this.lazy || table.areIndexesImported()) {
            this.exportUKs(table.getUniqueConstraints(false), writer);
            this.exportIndexes(table.getIndexes(), writer);
        }
    }

    private void exportUKs(Set<DBUniqueConstraint> uks, SimpleXMLWriter writer) throws SAXException {
        for (DBUniqueConstraint uk : uks) {
            if (uk instanceof DBPrimaryKeyConstraint) continue;
            AttributesImpl atts = SimpleXMLWriter.createAttributes((String)"name", (String)uk.getName());
            String[] columnNames = uk.getColumnNames();
            if (columnNames.length == 1) {
                SimpleXMLWriter.addAttribute((String)"column", (String)columnNames[0], (AttributesImpl)atts);
            }
            writer.startElement("uk", (Attributes)atts);
            if (columnNames.length > 1) {
                this.writeColumnGroup(columnNames, writer);
            }
            writer.endElement("uk");
        }
    }

    public void exportChecks(DBTable table, SimpleXMLWriter writer) throws SAXException {
        if (!this.lazy || table.areChecksImported()) {
            this.exportChecks(table.getCheckConstraints(), writer);
        }
    }

    private void exportChecks(List<DBCheckConstraint> checks, SimpleXMLWriter writer) throws SAXException {
        for (DBCheckConstraint check : checks) {
            AttributesImpl atts = SimpleXMLWriter.createAttributes((String)"name", (String)check.getName());
            SimpleXMLWriter.addAttribute((String)"definition", (String)check.getConditionText(), (AttributesImpl)atts);
            writer.startElement("check", (Attributes)atts);
            writer.endElement("check");
        }
    }

    private void exportFks(Set<DBForeignKeyConstraint> fks, SimpleXMLWriter writer) throws SAXException {
        for (DBForeignKeyConstraint fk : fks) {
            AttributesImpl atts = SimpleXMLWriter.createAttributes((String)"name", (String)fk.getName());
            String[] columnNames = fk.getColumnNames();
            if (columnNames.length == 1) {
                SimpleXMLWriter.addAttribute((String)"column", (String)columnNames[0], (AttributesImpl)atts);
            }
            SimpleXMLWriter.addAttribute((String)"refereeTable", (String)fk.getRefereeTable().getName(), (AttributesImpl)atts);
            String[] refereeColumns = fk.getRefereeColumnNames();
            if (refereeColumns.length == 1) {
                SimpleXMLWriter.addAttribute((String)"refereeColumn", (String)refereeColumns[0], (AttributesImpl)atts);
            }
            if (fk.getUpdateRule() != FKChangeRule.NO_ACTION) {
                SimpleXMLWriter.addAttribute((String)"updateRule", (String)fk.getUpdateRule().name(), (AttributesImpl)atts);
            }
            if (fk.getDeleteRule() != FKChangeRule.NO_ACTION) {
                SimpleXMLWriter.addAttribute((String)"deleteRule", (String)fk.getDeleteRule().name(), (AttributesImpl)atts);
            }
            writer.startElement("fk", (Attributes)atts);
            if (columnNames.length > 1) {
                writer.startElement("columns", new String[0]);
                for (String columnName : columnNames) {
                    AttributesImpl colAtts = SimpleXMLWriter.createAttributes((String)"name", (String)columnName);
                    SimpleXMLWriter.addAttribute((String)"refereeColumn", (String)fk.columnReferencedBy(columnName), (AttributesImpl)colAtts);
                    writer.startElement("column", (Attributes)colAtts);
                    writer.endElement("column");
                }
                writer.endElement("columns");
            }
            writer.endElement("fk");
        }
    }

    private void exportIndexes(List<DBIndex> indexes, SimpleXMLWriter writer) throws SAXException {
        for (DBIndex index : indexes) {
            AttributesImpl atts = SimpleXMLWriter.createAttributes((String)"name", (String)index.getName());
            SimpleXMLWriter.addAttribute((String)"unique", (String)(index.isUnique() ? "true" : null), (AttributesImpl)atts);
            SimpleXMLWriter.addAttribute((String)"nameDeterministic", (String)(index.isNameDeterministic() ? null : "false"), (AttributesImpl)atts);
            String[] columnNames = index.getColumnNames();
            if (columnNames.length == 1) {
                SimpleXMLWriter.addAttribute((String)"column", (String)columnNames[0], (AttributesImpl)atts);
            }
            writer.startElement("index", (Attributes)atts);
            if (columnNames.length > 1) {
                this.writeColumnGroup(columnNames, writer);
            }
            writer.endElement("index");
        }
    }

    public void writeColumnGroup(String[] pkColumnNames, SimpleXMLWriter writer) throws SAXException {
        writer.startElement("columns", new String[0]);
        for (String pkColumnName : pkColumnNames) {
            AttributesImpl colAtts = SimpleXMLWriter.createAttributes((String)"name", (String)pkColumnName);
            writer.startElement("column", (Attributes)colAtts);
            writer.endElement("column");
        }
        writer.endElement("columns");
    }

    private void exportSequence(DBSequence sequence, SimpleXMLWriter writer) throws SAXException {
        AttributesImpl atts = SimpleXMLWriter.createAttributes((String)"name", (String)sequence.getName());
        this.addIfNotNull("start", sequence.getStartIfNotDefault(), atts);
        this.addIfNotNull("increment", sequence.getIncrementIfNotDefault(), atts);
        this.addIfNotNull("maxValue", sequence.getMaxValueIfNotDefault(), atts);
        this.addIfNotNull("minValue", sequence.getMinValueIfNotDefault(), atts);
        this.addIfNotNull("cycle", sequence.isCycle(), atts);
        this.addIfNotNull("cache", sequence.getCache(), atts);
        this.addIfNotNull("order", sequence.isOrder(), atts);
        writer.startElement("sequence", (Attributes)atts);
        writer.endElement("sequence");
    }

    private void exportTrigger(DBTrigger trigger, SimpleXMLWriter writer) throws SAXException {
        AttributesImpl atts = SimpleXMLWriter.createAttributes((String)"name", (String)trigger.getName());
        this.addIfNotNull("triggerType", trigger.getTriggerType(), atts);
        this.addIfNotNull("triggeringEvent", trigger.getTriggeringEvent(), atts);
        this.addIfNotNull("tableOwner", trigger.getTableOwner(), atts);
        this.addIfNotNull("baseObjectType", trigger.getBaseObjectType(), atts);
        this.addIfNotNull("tableName", trigger.getTableName(), atts);
        this.addIfNotNull("columnName", trigger.getColumnName(), atts);
        this.addIfNotNull("referencingNames", trigger.getReferencingNames(), atts);
        this.addIfNotNull("whenClause", trigger.getWhenClause(), atts);
        this.addIfNotNull("status", trigger.getStatus(), atts);
        this.addIfNotNull("description", trigger.getDescription(), atts);
        this.addIfNotNull("actionType", trigger.getActionType(), atts);
        this.addIfNotNull("triggerBody", trigger.getTriggerBody(), atts);
        writer.startElement("trigger", (Attributes)atts);
        writer.endElement("trigger");
    }

    private void exportPackage(DBPackage pkg, SimpleXMLWriter writer) throws SAXException {
        AttributesImpl atts = SimpleXMLWriter.createAttributes((String)"name", (String)pkg.getName());
        this.addIfNotNull("subObjectName", pkg.getSubObjectName(), atts);
        this.addIfNotNull("objectId", pkg.getObjectId(), atts);
        this.addIfNotNull("dataObjectId", pkg.getDataObjectId(), atts);
        this.addIfNotNull("objectType", pkg.getObjectType(), atts);
        this.addIfNotNull("status", pkg.getStatus(), atts);
        writer.startElement("package", (Attributes)atts);
        this.exportPackageProcedures(pkg, writer);
        writer.endElement("package");
    }

    private void exportPackageProcedures(DBPackage pkg, SimpleXMLWriter writer) throws SAXException {
        for (DBProcedure procedure : pkg.getProcedures()) {
            AttributesImpl atts = SimpleXMLWriter.createAttributes((String)"name", (String)procedure.getName());
            this.addIfNotNull("objectId", procedure.getObjectId(), atts);
            this.addIfNotNull("subProgramId", procedure.getSubProgramId(), atts);
            this.addIfNotNull("overload", procedure.getOverload(), atts);
            writer.startElement("procedure", (Attributes)atts);
            writer.endElement("procedure");
        }
    }

    private void addIfNotNull(String name, Object value, AttributesImpl atts) {
        if (value != null) {
            SimpleXMLWriter.addAttribute((String)name, (String)value.toString(), (AttributesImpl)atts);
        }
    }
}

