/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model.jdbc;

import java.util.regex.Pattern;
import org.databene.commons.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableNameFilter
implements Filter<String> {
    private Pattern tableInclusionPattern;
    private Pattern tableExclusionPattern;

    public TableNameFilter(String tableInclusionPattern, String tableExclusionPattern) {
        this.tableInclusionPattern = Pattern.compile(tableInclusionPattern != null ? tableInclusionPattern : ".*");
        this.tableExclusionPattern = tableExclusionPattern != null ? Pattern.compile(tableExclusionPattern) : null;
    }

    public boolean accept(String tableName) {
        if (tableName.contains("$") || this.tableExclusionPattern != null && this.tableExclusionPattern.matcher(tableName).matches()) {
            return false;
        }
        return this.tableInclusionPattern == null || this.tableInclusionPattern.matcher(tableName).matches();
    }
}

