/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.databene.commons.ConnectFailedException;
import org.databene.commons.ErrorHandler;
import org.databene.commons.Escalator;
import org.databene.commons.Filter;
import org.databene.commons.ImportFailedException;
import org.databene.commons.Level;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.ProgrammerError;
import org.databene.commons.StringUtil;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.commons.version.VersionNumber;
import org.databene.contiperf.StopWatch;
import org.databene.jdbacl.DBUtil;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.DatabaseDialectManager;
import org.databene.jdbacl.JDBCConnectData;
import org.databene.jdbacl.dialect.OracleDialect;
import org.databene.jdbacl.model.DBCatalog;
import org.databene.jdbacl.model.DBCheckConstraint;
import org.databene.jdbacl.model.DBDataType;
import org.databene.jdbacl.model.DBForeignKeyConstraint;
import org.databene.jdbacl.model.DBMetaDataImporter;
import org.databene.jdbacl.model.DBPackage;
import org.databene.jdbacl.model.DBSchema;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.Database;
import org.databene.jdbacl.model.FKChangeRule;
import org.databene.jdbacl.model.TableType;
import org.databene.jdbacl.model.jdbc.DBIndexInfo;
import org.databene.jdbacl.model.jdbc.ImportedKey;
import org.databene.jdbacl.model.jdbc.TableNameFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCDBImporter
implements DBMetaDataImporter {
    private static final String TEMPORARY_ENVIRONMENT = "___temp";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String environment;
    protected String url;
    protected String driver;
    protected String password;
    protected String user;
    protected String catalogName;
    protected String schemaName;
    protected String tableInclusionPattern;
    protected String tableExclusionPattern;
    Connection _connection;
    DatabaseDialect dialect;
    String databaseProductName;
    private VersionNumber databaseProductVersion;
    Escalator escalator = new LoggerEscalator();
    ErrorHandler errorHandler;
    TableNameFilter tableNameFilter;
    DatabaseMetaData metaData;

    public JDBCDBImporter(String environment) {
        this._connection = null;
        this.environment = environment;
        this.tableInclusionPattern = ".*";
        this.tableExclusionPattern = null;
        this.errorHandler = new ErrorHandler(this.getClass().getName(), Level.error);
        this.init();
    }

    public JDBCDBImporter(String url, String driver, String user, String password, String catalog, String schema) {
        this._connection = null;
        this.environment = TEMPORARY_ENVIRONMENT;
        this.url = url;
        this.driver = driver;
        this.user = user;
        this.password = password;
        this.catalogName = catalog;
        this.schemaName = schema;
        this.tableInclusionPattern = ".*";
        this.errorHandler = new ErrorHandler(this.getClass().getName(), Level.error);
        this.init();
    }

    public JDBCDBImporter(Connection connection, String user, String schemaName) {
        this.environment = TEMPORARY_ENVIRONMENT;
        this._connection = connection;
        this.user = user;
        this.schemaName = schemaName;
        this.errorHandler = new ErrorHandler(this.getClass().getName(), Level.error);
        this.init();
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public VersionNumber getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setFaultTolerant(boolean faultTolerant) {
        this.errorHandler = new ErrorHandler(this.getClass().getName(), faultTolerant ? Level.warn : Level.error);
    }

    public Connection getConnection() throws ConnectFailedException {
        if (this._connection == null) {
            StopWatch watch = new StopWatch("connect");
            this._connection = DBUtil.connect(this.url, this.driver, this.user, this.password, true);
            watch.stop();
        }
        return this._connection;
    }

    @Deprecated
    public void setTablePattern(String tablePattern) {
        this.tableInclusionPattern = tablePattern;
    }

    public void setTableInclusionPattern(String tableInclusionPattern) {
        this.tableInclusionPattern = tableInclusionPattern;
    }

    public void setTableExclusionPattern(String tableExclusionPattern) {
        this.tableExclusionPattern = tableExclusionPattern;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    private boolean isOracle() {
        return this.databaseProductName.toLowerCase().startsWith("oracle");
    }

    @Override
    public Database importDatabase() throws ConnectFailedException, ImportFailedException {
        return new Database(this.environment, this, true);
    }

    protected void init() {
        try {
            if (!TEMPORARY_ENVIRONMENT.equals(this.environment)) {
                JDBCConnectData cd = DBUtil.getConnectData(this.environment);
                if (this.url == null) {
                    this.url = cd.url;
                }
                if (this.driver == null) {
                    this.driver = cd.driver;
                }
                if (this.user == null) {
                    this.user = cd.user;
                }
                if (this.password == null) {
                    this.password = cd.password;
                }
                if (this.catalogName == null) {
                    this.catalogName = cd.catalog;
                }
                if (this.schemaName == null) {
                    this.schemaName = cd.schema;
                }
            }
            this.tableNameFilter = new TableNameFilter(this.tableInclusionPattern, this.tableExclusionPattern);
            StopWatch watch = new StopWatch("getMetaData");
            this.metaData = this.getConnection().getMetaData();
            watch.stop();
            this.databaseProductName = this.metaData.getDatabaseProductName();
            this.databaseProductVersion = VersionNumber.valueOf((String)this.metaData.getDatabaseProductVersion());
            this.logger.debug("Product: {} {}", (Object)this.databaseProductName, (Object)this.databaseProductVersion);
            this.dialect = DatabaseDialectManager.getDialectForProduct(this.databaseProductName, this.databaseProductVersion);
            if (this.isOracle()) {
                DBUtil.executeUpdate("ALTER SESSION SET NLS_LENGTH_SEMANTICS=CHAR", this.getConnection());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing " + this.getClass(), e);
        }
    }

    @Override
    public void close() {
        DBUtil.close(this._connection);
    }

    public void importCatalogs(Database database) throws SQLException, ConnectFailedException {
        this.logger.debug("Importing catalogs from " + database.getEnvironment());
        StopWatch watch = new StopWatch("importCatalogs");
        ResultSet catalogSet = this.metaData.getCatalogs();
        int catalogCount = 0;
        while (catalogSet.next()) {
            String foundCatalog = catalogSet.getString(1);
            this.logger.debug("found catalog '" + foundCatalog + "'");
            if (!StringUtil.equalsIgnoreCase((String)foundCatalog, (String)this.catalogName) && (!StringUtil.isEmpty((CharSequence)this.catalogName) || !this.dialect.isDefaultCatalog(foundCatalog, this.user) && !foundCatalog.equalsIgnoreCase(this.getConnection().getCatalog()))) continue;
            this.catalogName = foundCatalog;
            database.addCatalog(new DBCatalog(foundCatalog));
            ++catalogCount;
        }
        if (catalogCount == 0) {
            database.addCatalog(new DBCatalog(null));
        }
        catalogSet.close();
        watch.stop();
    }

    public void importSchemas(Database database) throws SQLException {
        this.logger.debug("Importing schemas from " + database.getEnvironment());
        StopWatch watch = new StopWatch("importSchemas");
        int schemaCount = 0;
        ResultSet schemaSet = this.metaData.getSchemas();
        while (schemaSet.next()) {
            String schemaName = schemaSet.getString(1);
            String catalogName = null;
            int columnCount = schemaSet.getMetaData().getColumnCount();
            if (columnCount >= 2) {
                catalogName = schemaSet.getString(2);
            }
            if (schemaName.equalsIgnoreCase(this.schemaName) || this.schemaName == null && this.dialect.isDefaultSchema(schemaName, this.user)) {
                this.logger.debug("importing schema '{}'", (Object)schemaName);
                this.schemaName = schemaName;
                String catalogNameOfSchema = columnCount >= 2 && catalogName != null ? catalogName : this.catalogName;
                DBCatalog catalogOfSchema = database.getCatalog(catalogNameOfSchema);
                if (catalogOfSchema == null) {
                    throw new ObjectNotFoundException("Catalog not found: " + catalogOfSchema);
                }
                new DBSchema(schemaName, catalogOfSchema);
                ++schemaCount;
                continue;
            }
            this.logger.debug("ignoring schema {}", (Object)schemaName);
        }
        if (schemaCount == 0) {
            DBCatalog catalogToUse = database.getCatalog(this.catalogName);
            if (catalogToUse == null) {
                catalogToUse = database.getCatalogs().get(0);
            }
            catalogToUse.addSchema(new DBSchema(null));
        }
        schemaSet.close();
        watch.stop();
    }

    public void importAllTables(Database database) throws SQLException {
        this.logger.info("Importing tables from " + database.getEnvironment());
        if (this.tableExclusionPattern != null) {
            this.logger.debug("excluding tables: {}", (Object)this.tableExclusionPattern);
        }
        if (this.tableInclusionPattern != null && !".*".equals(this.tableInclusionPattern)) {
            this.logger.debug("including tables: {}", (Object)this.tableInclusionPattern);
        }
        StopWatch watch = new StopWatch("importAllTables");
        ResultSet tableSet = this.metaData.getTables(this.catalogName, this.schemaName, null, new String[]{"TABLE", "VIEW"});
        while (tableSet.next()) {
            String tCatalogName = tableSet.getString(1);
            String tSchemaName = tableSet.getString(2);
            String tableName = tableSet.getString(3);
            if (tableName.startsWith("BIN$")) {
                if (!this.isOracle() || !tableName.startsWith("BIN$")) continue;
                this.escalator.escalate("BIN$ table found (for improved performance execute 'PURGE RECYCLEBIN;')", (Object)this, (Object)tableName);
                continue;
            }
            if (!this.tableSupported(tableName)) {
                this.logger.debug("ignoring table: {}, {}, {}", new Object[]{tCatalogName, tSchemaName, tableName});
                continue;
            }
            String tableTypeSpec = tableSet.getString(4);
            String tableRemarks = tableSet.getString(5);
            if (database.isReservedWord(tableName)) {
                this.logger.warn("Table name is a reserved word: {}", (Object)tableName);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("importing table: {}, {}, {}, {}, {}", new Object[]{tCatalogName, tSchemaName, tableName, tableTypeSpec, tableRemarks});
            }
            TableType tableType = this.tableType(tableTypeSpec, tableName);
            DBCatalog catalog = database.getCatalog(tCatalogName);
            DBSchema schema = catalog != null ? catalog.getSchema(tSchemaName) : database.getSchema(tSchemaName);
            if (schema != null) {
                DBTable table = new DBTable(tableName, tableType, tableRemarks, schema, this);
                table.setDoc(tableRemarks);
                continue;
            }
            this.logger.warn("No schema specified. Ignoring table {}", (Object)tableName);
        }
        tableSet.close();
        watch.stop();
    }

    private TableType tableType(String tableTypeSpec, String tableName) {
        if (StringUtil.isEmpty((CharSequence)tableTypeSpec)) {
            return TableType.TABLE;
        }
        try {
            return TableType.valueOf(tableTypeSpec.replace(' ', '_'));
        }
        catch (Exception e) {
            this.escalator.escalate("Unknown table type '" + tableTypeSpec + "', assuming standard table", (Object)this, (Object)tableName);
            return TableType.TABLE;
        }
    }

    public void importColumnsOfTable(DBTable table, ColumnReceiver receiver) {
        this.importColumns(table.getCatalog(), table.getSchema().getName(), table.getName(), this.tableNameFilter, receiver, this.errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importColumns(DBCatalog catalog, String schemaName, String tablePattern, Filter<String> tableFilter, ColumnReceiver receiver, ErrorHandler errorHandler) {
        ResultSet columnSet;
        String catalogName;
        StopWatch watch;
        block15: {
            String schemaPattern;
            watch = new StopWatch("importColumns");
            catalogName = catalog.getName();
            String string = schemaName != null ? schemaName : (schemaPattern = catalog.getSchemas().size() == 1 ? catalog.getSchemas().get(0).getName() : null);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Importing columns for catalog " + StringUtil.quoteIfNotNull((String)catalogName) + ", " + "schemaPattern " + StringUtil.quoteIfNotNull((String)schemaName) + ", " + "tablePattern '" + StringUtil.quoteIfNotNull((String)tablePattern) + "'");
            }
            columnSet = null;
            columnSet = this.metaData.getColumns(catalogName, schemaPattern, tablePattern, null);
            ResultSetMetaData setMetaData = columnSet.getMetaData();
            if (setMetaData.getColumnCount() != 0) break block15;
            DBUtil.close(columnSet);
            return;
        }
        try {
            while (columnSet.next()) {
                String colSchemaName = columnSet.getString(2);
                String tableName = columnSet.getString(3);
                String columnName = columnSet.getString(4);
                if (tableName.startsWith("BIN$") || tableFilter != null && !tableFilter.accept((Object)tableName)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("ignoring column " + catalogName + "." + colSchemaName + "." + tableName + "." + columnName);
                    continue;
                }
                int sqlType = columnSet.getInt(5);
                String columnType = columnSet.getString(6);
                Integer columnSize = columnSet.getInt(7);
                if (columnSize == 0) {
                    columnSize = null;
                }
                int decimalDigits = columnSet.getInt(9);
                boolean nullable = columnSet.getBoolean(11);
                String comment = columnSet.getString(12);
                String defaultValue = columnSet.getString(13);
                if (sqlType == -7 && "bool".equals(columnType.toLowerCase()) && this.databaseProductName.toLowerCase().startsWith("postgres")) {
                    sqlType = 16;
                }
                this.logger.debug("found column: {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}", new Object[]{catalogName, colSchemaName, tableName, columnName, sqlType, columnType, columnSize, decimalDigits, nullable, comment, defaultValue});
                DBTable table = catalog.getTable(tableName, false);
                if (table == null) {
                    this.logger.debug("Ignoring column {}.{}", (Object)tableName, (Object)columnName);
                    continue;
                }
                DBSchema schema = catalog.getSchema(schemaName);
                if (schema != null) {
                    table = schema.getTable(tableName);
                }
                Integer fractionDigits = decimalDigits > 0 ? Integer.valueOf(decimalDigits) : null;
                DBDataType dataType = DBDataType.getInstance(sqlType, columnType);
                if (!StringUtil.isEmpty((CharSequence)defaultValue)) {
                    if (!dataType.isAlpha()) {
                        defaultValue = JDBCDBImporter.removeBrackets(defaultValue);
                    }
                    defaultValue = defaultValue.trim();
                }
                receiver.receiveColumn(columnName, dataType, columnSize, fractionDigits, nullable, defaultValue, comment, table);
            }
        }
        catch (SQLException e) {
            try {
                if (errorHandler == null) {
                    errorHandler = new ErrorHandler(this.getClass());
                }
                errorHandler.handleError("Error in parsing columns for table pattern " + tablePattern, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(columnSet);
                throw throwable;
            }
            DBUtil.close(columnSet);
        }
        DBUtil.close(columnSet);
        watch.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importPrimaryKeyOfTable(DBTable table, PKReceiver receiver) {
        ResultSet pkset;
        StopWatch watch;
        block5: {
            this.logger.debug("Importing primary keys for table {}", (Object)table);
            watch = new StopWatch("importPrimaryKeyOfTable");
            pkset = null;
            try {
                pkset = this.metaData.getPrimaryKeys(this.catalogName, this.schemaName, table.getName());
                TreeMap<Short, String> pkComponents = new TreeMap<Short, String>();
                String pkName = null;
                while (pkset.next()) {
                    String tableName = pkset.getString(3);
                    if (!tableName.equals(table.getName())) continue;
                    String columnName = pkset.getString(4);
                    short keySeq = pkset.getShort(5);
                    pkComponents.put(keySeq, columnName);
                    pkName = pkset.getString(6);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("found pk column " + columnName + ", " + keySeq + ", " + pkName);
                }
                if (pkComponents.size() <= 0) break block5;
                String[] columnNames = pkComponents.values().toArray(new String[pkComponents.size()]);
                receiver.receivePK(pkName, this.dialect.isDeterministicPKName(pkName), columnNames, table);
            }
            catch (SQLException e) {
                try {
                    this.errorHandler.handleError("Error importing primary key of table " + table.getName());
                }
                catch (Throwable throwable) {
                    DBUtil.close(pkset);
                    throw throwable;
                }
                DBUtil.close(pkset);
            }
        }
        DBUtil.close(pkset);
        watch.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet importIndexesOfTable(DBTable table, boolean uniquesOnly, IndexReceiver receiver) {
        StopWatch watch = new StopWatch("importIndexesOfTable");
        if (table.getTableType() == TableType.TABLE) {
            this.logger.debug("Importing indexes of table '{}'", (Object)table.getName());
        } else {
            this.logger.debug("Skipping indexes of table '{}' with type '{}'", (Object)table.getName(), (Object)table.getTableType());
        }
        ResultSet indexSet = null;
        try {
            indexSet = this.metaData.getIndexInfo(table.getCatalog().getName(), table.getSchema().getName(), table.getName(), uniquesOnly, true);
            this.parseIndexSet(indexSet, table.getSchema(), table, receiver);
        }
        catch (SQLException e) {
            try {
                this.errorHandler.handleError("Error parsing index data of table " + table.getName(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(indexSet);
                throw throwable;
            }
            DBUtil.close(indexSet);
        }
        DBUtil.close(indexSet);
        watch.stop();
        return indexSet;
    }

    public void parseIndexSet(ResultSet indexSet, DBSchema schema, DBTable queriedTable, IndexReceiver receiver) throws SQLException {
        StopWatch watch = new StopWatch("parseIndexSet");
        OrderedNameMap indexes = new OrderedNameMap();
        while (indexSet.next()) {
            String indexName = null;
            try {
                DBIndexInfo index;
                String tableName = indexSet.getString(3);
                if (!this.tableSupported(tableName) || queriedTable != null && !queriedTable.getName().equalsIgnoreCase(tableName)) continue;
                boolean unique = !indexSet.getBoolean(4);
                String indexCatalogName = indexSet.getString(5);
                indexName = indexSet.getString(6);
                short indexType = indexSet.getShort(7);
                short ordinalPosition = indexSet.getShort(8);
                if (ordinalPosition == 0) continue;
                String columnName = indexSet.getString(9);
                String ascOrDesc = indexSet.getString(10);
                Boolean ascending = ascOrDesc != null ? Boolean.valueOf(ascOrDesc.charAt(0) == 'A') : null;
                int cardinality = indexSet.getInt(11);
                int pages = indexSet.getInt(12);
                String filterCondition = indexSet.getString(13);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("found " + (unique ? "unique index " : "index ") + indexName + ", " + indexCatalogName + ", " + indexType + ", " + ordinalPosition + ", " + columnName + ", " + ascOrDesc + ", " + cardinality + ", " + pages + ", " + filterCondition);
                }
                if ((index = (DBIndexInfo)indexes.get(indexName)) == null) {
                    index = new DBIndexInfo(indexName, tableName, indexType, indexCatalogName, unique, ordinalPosition, columnName, ascending, cardinality, pages, filterCondition);
                    indexes.put(indexName, (Object)index);
                    continue;
                }
                index.addColumn(ordinalPosition, columnName);
            }
            catch (Exception e) {
                this.errorHandler.handleError("Error importing index " + indexName);
            }
        }
        for (DBIndexInfo indexInfo : indexes.values()) {
            DBTable table = queriedTable != null ? queriedTable : schema.getTable(indexInfo.tableName);
            boolean deterministicName = this.dialect.isDeterministicIndexName(indexInfo.name);
            receiver.receiveIndex(indexInfo, deterministicName, table, schema);
        }
        watch.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importImportedKeys(DBTable table, FKReceiver receiver) {
        this.logger.debug("Importing imported keys for table {}", (Object)table.getName());
        StopWatch watch = new StopWatch("importImportedKeys");
        DBCatalog catalog = table.getCatalog();
        DBSchema schema = table.getSchema();
        String catalogName = catalog != null ? catalog.getName() : null;
        String tableName = table.getName();
        String schemaName = schema != null ? schema.getName() : null;
        ResultSet resultSet = null;
        try {
            resultSet = this.metaData.getImportedKeys(catalogName, schemaName, tableName);
            ArrayList<ImportedKey> keyList = new ArrayList<ImportedKey>();
            OrderedNameMap keysByName = OrderedNameMap.createCaseIgnorantMap();
            ImportedKey recent = null;
            while (resultSet.next()) {
                ImportedKey cursor = ImportedKey.parse(resultSet, catalog, schema, table);
                if (cursor == null) continue;
                if (cursor.key_seq == 1) {
                    if (cursor.fk_name != null) {
                        keysByName.put(cursor.fk_name, cursor);
                    }
                    keyList.add(cursor);
                } else if (cursor.fk_name != null) {
                    ((ImportedKey)keysByName.get(cursor.fk_name)).addForeignKeyColumn(cursor.fkcolumn_name, cursor.pkcolumn_name);
                } else {
                    recent.addForeignKeyColumn(cursor.fkcolumn_name, cursor.pkcolumn_name);
                }
                recent = cursor;
            }
            for (ImportedKey key : keyList) {
                int n = key.getForeignKeyColumnNames().size();
                String[] columnNames = new String[n];
                String[] refereeColumnNames = new String[n];
                for (int i = 0; i < n; ++i) {
                    columnNames[i] = key.getForeignKeyColumnNames().get(i);
                    refereeColumnNames[i] = key.getRefereeColumnNames().get(i);
                }
                DBForeignKeyConstraint foreignKeyConstraint = new DBForeignKeyConstraint(key.fk_name, this.dialect.isDeterministicFKName(key.fk_name), null, columnNames, key.getPkTable(), refereeColumnNames);
                foreignKeyConstraint.setUpdateRule(this.parseRule(key.update_rule));
                foreignKeyConstraint.setDeleteRule(this.parseRule(key.delete_rule));
                receiver.receiveFK(foreignKeyConstraint, table);
                this.logger.debug("Imported foreign key {}", (Object)foreignKeyConstraint);
            }
        }
        catch (SQLException e) {
            try {
                this.errorHandler.handleError("Error importing foreign key constraints", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                throw throwable;
            }
            DBUtil.close(resultSet);
        }
        DBUtil.close(resultSet);
        watch.stop();
    }

    private FKChangeRule parseRule(short rule) {
        switch (rule) {
            case 3: {
                return FKChangeRule.NO_ACTION;
            }
            case 0: {
                return FKChangeRule.CASCADE;
            }
            case 2: {
                return FKChangeRule.SET_NULL;
            }
            case 4: {
                return FKChangeRule.SET_DEFAULT;
            }
            case 1: {
                return FKChangeRule.NO_ACTION;
            }
        }
        throw new ProgrammerError("Not a supported rule: " + rule);
    }

    public final void importAllChecks(Database database) {
        this.logger.info("Importing checks from " + database.getEnvironment());
        StopWatch watch = new StopWatch("importAllChecks");
        try {
            int count = 0;
            database.setChecksImported(true);
            if (this.dialect instanceof OracleDialect) {
                for (DBCatalog catalog : database.getCatalogs()) {
                    for (DBSchema schema : catalog.getSchemas()) {
                        DBCheckConstraint[] newChecks;
                        OracleDialect oraDialect = (OracleDialect)this.dialect;
                        for (DBCheckConstraint newCheck : newChecks = oraDialect.queryCheckConstraints(this.getConnection(), schema.getName())) {
                            if (!this.tableSupported(newCheck.getTableName())) continue;
                            DBTable table = schema.getTable(newCheck.getTableName());
                            table.receiveCheckConstraint(newCheck);
                            newCheck.setTable(table);
                        }
                        ++count;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error importing checks from " + database.getEnvironment(), e);
        }
        watch.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRefererTables(DBTable table, ReferrerReceiver receiver) {
        StopWatch watch = new StopWatch("importRefererTables");
        this.logger.debug("Importing exported keys for table {}", (Object)table);
        DBCatalog catalog = table.getCatalog();
        DBSchema schema = table.getSchema();
        String catalogName = catalog != null ? catalog.getName() : null;
        String tableName = table.getName();
        String schemaName = schema != null ? schema.getName() : null;
        ResultSet resultSet = null;
        try {
            resultSet = this.metaData.getExportedKeys(catalogName, schemaName, tableName);
            while (resultSet.next()) {
                String fktable_cat = resultSet.getString(5);
                String fktable_schem = resultSet.getString(6);
                String fktable_name = resultSet.getString(7);
                if (!this.tableSupported(fktable_name)) continue;
                this.logger.debug("Importing referrer: {}", (Object)fktable_name);
                receiver.receiveReferrer(fktable_name, table);
            }
        }
        catch (SQLException e) {
            try {
                this.errorHandler.handleError("Error importing foreign key constraints for table " + table, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                throw throwable;
            }
            DBUtil.close(resultSet);
        }
        DBUtil.close(resultSet);
        watch.stop();
    }

    public void importSequences(Database database) {
        this.logger.info("Importing sequences from " + database.getEnvironment());
        StopWatch watch = new StopWatch("importSequences");
        try {
            if (this.dialect.isSequenceSupported()) {
                DBSequence[] sequences;
                for (DBSequence sequence : sequences = this.dialect.querySequences(this.getConnection())) {
                    DBCatalog catalog = database.getCatalog(sequence.getCatalogName());
                    if (catalog == null) continue;
                    DBSchema schema = catalog.getSchema(sequence.getSchemaName());
                    if (schema == null) {
                        schema = catalog.getSchema(this.schemaName);
                    }
                    schema.receiveSequence(sequence);
                    sequence.setOwner(schema);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error importing sequences from " + database.getEnvironment(), (Throwable)e);
        }
        watch.stop();
    }

    public void importTriggers(Database database) throws SQLException {
        for (DBCatalog catalog : database.getCatalogs()) {
            for (DBSchema schema : catalog.getSchemas()) {
                this.importTriggersForSchema(schema);
            }
        }
    }

    private void importTriggersForSchema(DBSchema schema) throws SQLException {
        StopWatch watch = new StopWatch("importTriggersForSchema");
        this.dialect.queryTriggers(schema, this._connection);
        watch.stop();
    }

    public void importPackages(Database database) throws SQLException {
        for (DBCatalog catalog : database.getCatalogs()) {
            for (DBSchema schema : catalog.getSchemas()) {
                this.importPackagesOfSchema(schema);
            }
        }
    }

    private void importPackagesOfSchema(DBSchema schema) throws SQLException {
        StopWatch watch = new StopWatch("importPackagesOfSchema");
        List<DBPackage> packages = this.dialect.queryPackages(schema, this._connection);
        for (DBPackage pkg : packages) {
            schema.receivePackage(pkg);
            pkg.setSchema(schema);
        }
        watch.stop();
    }

    protected static String removeBrackets(String defaultValue) {
        if (StringUtil.isEmpty((CharSequence)defaultValue)) {
            return defaultValue;
        }
        if (!defaultValue.startsWith("(") || !defaultValue.endsWith(")")) {
            return defaultValue;
        }
        return JDBCDBImporter.removeBrackets(defaultValue.substring(1, defaultValue.length() - 1));
    }

    protected boolean tableSupported(String tableName) {
        return this.tableNameFilter.accept(tableName);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static interface IndexReceiver {
        public void receiveIndex(DBIndexInfo var1, boolean var2, DBTable var3, DBSchema var4);
    }

    public static interface ReferrerReceiver {
        public void receiveReferrer(String var1, DBTable var2);
    }

    public static interface FKReceiver {
        public void receiveFK(DBForeignKeyConstraint var1, DBTable var2);
    }

    public static interface PKReceiver {
        public void receivePK(String var1, boolean var2, String[] var3, DBTable var4);
    }

    public static interface ColumnReceiver {
        public void receiveColumn(String var1, DBDataType var2, Integer var3, Integer var4, boolean var5, String var6, String var7, DBTable var8);
    }
}

