/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.databene.commons.ObjectNotFoundException;
import org.databene.jdbacl.model.DBCatalog;
import org.databene.jdbacl.model.DBSchema;
import org.databene.jdbacl.model.DBTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportedKey {
    private static final Logger logger = LoggerFactory.getLogger(ImportedKey.class);
    private DBTable pkTable;
    public String pktable_cat;
    public String pktable_schem;
    public String pktable_name;
    public String pkcolumn_name;
    public String fktable_cat;
    public String fktable_schem;
    public String fktable_name;
    public String fkcolumn_name;
    public short key_seq;
    public short update_rule;
    public short delete_rule;
    public String fk_name;
    public String pk_name;
    public short deferrablibity;
    private List<String> foreignKeyColumnNames = new ArrayList<String>();
    private List<String> refereeColumnNames = new ArrayList<String>();

    ImportedKey() {
    }

    public void addForeignKeyColumn(String foreignKeyColumnName, String targetColumnName) {
        this.foreignKeyColumnNames.add(foreignKeyColumnName);
        this.refereeColumnNames.add(targetColumnName);
    }

    public List<String> getForeignKeyColumnNames() {
        return this.foreignKeyColumnNames;
    }

    public List<String> getRefereeColumnNames() {
        return this.refereeColumnNames;
    }

    public static ImportedKey parse(ResultSet resultSet, DBCatalog catalog, DBSchema schema, DBTable fkTable) throws SQLException {
        ImportedKey key = new ImportedKey();
        key.pktable_cat = resultSet.getString(1);
        key.pktable_schem = resultSet.getString(2);
        key.pktable_name = resultSet.getString(3);
        key.pkcolumn_name = resultSet.getString(4);
        key.fktable_cat = resultSet.getString(5);
        key.fktable_schem = resultSet.getString(6);
        key.fktable_name = resultSet.getString(7);
        assert (key.fktable_name.equals(fkTable.getName()));
        key.fkcolumn_name = resultSet.getString(8);
        key.key_seq = resultSet.getShort(9);
        key.update_rule = resultSet.getShort(10);
        key.delete_rule = resultSet.getShort(11);
        key.fk_name = resultSet.getString(12);
        key.pk_name = resultSet.getString(13);
        key.deferrablibity = resultSet.getShort(14);
        if (logger.isDebugEnabled()) {
            logger.debug("found imported key " + key.pktable_cat + ", " + key.pktable_schem + ", " + key.pktable_name + ", " + key.pkcolumn_name + ", " + key.fktable_cat + ", " + key.fktable_schem + ", " + key.fktable_name + ", " + key.fkcolumn_name + ", " + key.key_seq + ", " + key.update_rule + ", " + key.delete_rule + ", " + key.fk_name + ", " + key.pk_name + ", " + key.deferrablibity);
        }
        if (!key.fktable_name.equalsIgnoreCase(fkTable.getName())) {
            return null;
        }
        key.pkTable = null;
        try {
            key.pkTable = catalog != null ? catalog.getTable(key.pktable_name) : schema.getTable(key.pktable_name);
        }
        catch (ObjectNotFoundException e) {
            throw new ObjectNotFoundException("Table " + key.pktable_name + " is referenced by table " + key.fktable_name + " but not found in the database. Possibly it was filtered out?");
        }
        key.addForeignKeyColumn(key.fkcolumn_name, key.pkcolumn_name);
        return key;
    }

    public DBTable getPkTable() {
        return this.pkTable;
    }

    public String toString() {
        return this.fktable_cat + "." + this.fktable_schem + "." + this.fktable_name + "." + this.fkcolumn_name + " -> " + this.pktable_cat + "." + this.pktable_schem + "." + this.pktable_name + "." + this.pkcolumn_name;
    }
}

