/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model.csv;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import org.databene.commons.FileUtil;
import org.databene.commons.IOUtil;
import org.databene.document.csv.CSVUtil;
import org.databene.jdbacl.SQLUtil;
import org.databene.jdbacl.model.DBCheckConstraint;
import org.databene.jdbacl.model.DBColumn;
import org.databene.jdbacl.model.DBForeignKeyConstraint;
import org.databene.jdbacl.model.DBIndex;
import org.databene.jdbacl.model.DBMetaDataExporter;
import org.databene.jdbacl.model.DBPrimaryKeyConstraint;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.DBUniqueConstraint;
import org.databene.jdbacl.model.Database;
import org.databene.jdbacl.model.FKChangeRule;

public class CSVModelExporter
implements DBMetaDataExporter {
    File rootDirectory;

    public CSVModelExporter(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public void export(Database database) throws IOException, SQLException {
        FileUtil.ensureDirectoryExists((File)this.rootDirectory);
        this.exportColumns(database);
        this.exportPrimaryKeys(database);
        this.exportUniqueKeys(database);
        this.exportForeignKeys(database);
        this.exportChecks(database);
        this.exportIndexes(database);
        this.exportSequences(database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportColumns(Database database) throws IOException {
        File file = new File(this.rootDirectory, "colums.csv");
        PrintWriter out = null;
        try {
            out = this.createPrintWriter(file);
            out.print(CSVUtil.formatHeaderWithLineFeed((char)',', (String[])new String[]{"catalog", "schema", "table", "column_name", "type", "jdbc_type", "nullable", "defaultValue"}));
            for (DBTable table : database.getTables()) {
                for (DBColumn column : table.getColumns()) {
                    CSVUtil.writeRow((Writer)out, (char)',', (String[])new String[]{table.getCatalog().getName(), table.getSchema().getName(), table.getName(), column.getName(), SQLUtil.renderColumnTypeWithSize(column), String.valueOf(column.getType().getJdbcType()), String.valueOf(column.isNullable()), column.getDefaultValue()});
                }
            }
        }
        finally {
            IOUtil.close((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportPrimaryKeys(Database database) throws IOException {
        File file = new File(this.rootDirectory, "primary_keys.csv");
        PrintWriter out = null;
        try {
            out = this.createPrintWriter(file);
            out.print(CSVUtil.formatHeaderWithLineFeed((char)',', (String[])new String[]{"catalog", "schema", "table", "pk_name", "column_name"}));
            for (DBTable table : database.getTables()) {
                DBPrimaryKeyConstraint pk = table.getPrimaryKeyConstraint();
                if (pk == null) continue;
                for (String columnName : pk.getColumnNames()) {
                    CSVUtil.writeRow((Writer)out, (char)',', (String[])new String[]{table.getCatalog().getName(), table.getSchema().getName(), table.getName(), pk.getName(), columnName});
                }
            }
        }
        finally {
            IOUtil.close((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportUniqueKeys(Database database) throws IOException {
        File file = new File(this.rootDirectory, "unique_keys.csv");
        PrintWriter out = null;
        try {
            out = this.createPrintWriter(file);
            out.print(CSVUtil.formatHeaderWithLineFeed((char)',', (String[])new String[]{"catalog", "schema", "table", "uk_name", "column_name"}));
            for (DBTable table : database.getTables()) {
                for (DBUniqueConstraint uk : table.getUniqueConstraints(false)) {
                    for (String columnName : uk.getColumnNames()) {
                        CSVUtil.writeRow((Writer)out, (char)',', (String[])new String[]{table.getCatalog().getName(), table.getSchema().getName(), table.getName(), uk.getName(), columnName});
                    }
                }
            }
        }
        finally {
            IOUtil.close((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportForeignKeys(Database database) throws IOException {
        File file = new File(this.rootDirectory, "foreign_keys.csv");
        PrintWriter out = null;
        try {
            out = this.createPrintWriter(file);
            out.print(CSVUtil.formatHeaderWithLineFeed((char)',', (String[])new String[]{"catalog", "schema", "table", "fk_name", "column", "refereeCatalog", "refereeSchema", "refereeTable", "refereeColumn", "updateRule", "deleteRule"}));
            for (DBTable table : database.getTables()) {
                for (DBForeignKeyConstraint fk : table.getForeignKeyConstraints()) {
                    String[] columnNames = fk.getColumnNames();
                    DBTable refereeTable = fk.getRefereeTable();
                    String[] refereeColumnNames = fk.getRefereeColumnNames();
                    for (int i = 0; i < columnNames.length; ++i) {
                        String columnName = columnNames[i];
                        String refereeColumnName = refereeColumnNames[i];
                        CSVUtil.writeRow((Writer)out, (char)',', (String[])new String[]{table.getCatalog().getName(), table.getSchema().getName(), table.getName(), fk.getName(), columnName, refereeTable.getCatalog().getName(), refereeTable.getSchema().getName(), refereeTable.getName(), refereeColumnName, this.renderChangeRule(fk.getUpdateRule()), this.renderChangeRule(fk.getDeleteRule())});
                    }
                }
            }
        }
        finally {
            IOUtil.close((Closeable)out);
        }
    }

    private String renderChangeRule(FKChangeRule rule) {
        switch (rule) {
            case NO_ACTION: {
                return "";
            }
            case CASCADE: {
                return "CASCADE";
            }
            case SET_NULL: {
                return "SET NULL";
            }
            case SET_DEFAULT: {
                return "SET DEFAULT";
            }
        }
        throw new IllegalArgumentException("Not a supported change rule: " + (Object)((Object)rule));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportChecks(Database database) throws IOException {
        File file = new File(this.rootDirectory, "checks.csv");
        PrintWriter out = null;
        try {
            out = this.createPrintWriter(file);
            out.print(CSVUtil.formatHeaderWithLineFeed((char)',', (String[])new String[]{"catalog", "schema", "table", "check"}));
            for (DBTable table : database.getTables()) {
                for (DBCheckConstraint check : table.getCheckConstraints()) {
                    CSVUtil.writeRow((Writer)out, (char)',', (String[])new String[]{table.getCatalog().getName(), table.getSchema().getName(), table.getName(), check.getName(), SQLUtil.normalize(check.getConditionText(), true)});
                }
            }
        }
        finally {
            IOUtil.close((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportIndexes(Database database) throws IOException {
        File file = new File(this.rootDirectory, "indexes.csv");
        PrintWriter out = null;
        try {
            out = this.createPrintWriter(file);
            out.print(CSVUtil.formatHeaderWithLineFeed((char)',', (String[])new String[]{"catalog", "schema", "table", "index_name", "index_unique", "column_name"}));
            for (DBTable table : database.getTables()) {
                for (DBIndex index : table.getIndexes()) {
                    for (String columnName : index.getColumnNames()) {
                        CSVUtil.writeRow((Writer)out, (char)',', (String[])new String[]{table.getCatalog().getName(), table.getSchema().getName(), table.getName(), index.getName(), String.valueOf(index.isUnique()), columnName});
                    }
                }
            }
        }
        finally {
            IOUtil.close((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportSequences(Database database) throws IOException {
        File file = new File(this.rootDirectory, "sequences.csv");
        PrintWriter out = null;
        try {
            out = this.createPrintWriter(file);
            out.print(CSVUtil.formatHeaderWithLineFeed((char)',', (String[])new String[]{"catalog", "schema", "name", "start", "increment", "maxValue", "minValue", "cycle", "cache", "order", "lastNumber"}));
            for (DBSequence sequence : database.getSequences()) {
                CSVUtil.writeRow((Writer)out, (char)',', (String[])new String[]{sequence.getCatalogName(), sequence.getSchemaName(), sequence.getName(), String.valueOf(sequence.getStart()), String.valueOf(sequence.getIncrement()), String.valueOf(sequence.getMaxValue()), String.valueOf(sequence.getMinValue()), String.valueOf(sequence.isCycle()), String.valueOf(sequence.getCache()), String.valueOf(sequence.isOrder()), String.valueOf(sequence.getLastNumber())});
            }
        }
        finally {
            IOUtil.close((Closeable)out);
        }
    }

    private PrintWriter createPrintWriter(File file) throws IOException {
        return new PrintWriter(new BufferedWriter(new FileWriter(file)));
    }
}

