/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.jdbacl.model.ContainerComponent;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.SequenceHolder;
import org.databene.jdbacl.model.TableContainer;
import org.databene.jdbacl.model.TableHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableContainerSupport
implements TableHolder,
SequenceHolder {
    private OrderedNameMap<TableContainer> subContainers = OrderedNameMap.createCaseIgnorantMap();
    private OrderedNameMap<DBTable> tables = OrderedNameMap.createCaseIgnorantMap();
    private OrderedNameMap<DBSequence> sequences = OrderedNameMap.createCaseIgnorantMap();

    public void addSubContainer(TableContainer subContainer) {
        this.subContainers.put(subContainer.getName(), (Object)subContainer);
    }

    public Collection<TableContainer> getSubContainers() {
        return this.subContainers.values();
    }

    @Override
    public List<DBTable> getTables() {
        return this.getTables(false);
    }

    @Override
    public List<DBTable> getTables(boolean recursive) {
        return this.getTables(recursive, new ArrayList<DBTable>());
    }

    public List<DBTable> getTables(boolean recursive, List<DBTable> result) {
        result.addAll(this.tables.values());
        if (recursive) {
            for (TableContainer subContainer : this.subContainers.values()) {
                subContainer.getTables(recursive, result);
            }
        }
        return result;
    }

    @Override
    public DBTable getTable(String tableName) {
        return (DBTable)this.tables.get(tableName);
    }

    public void addTable(DBTable table) {
        this.tables.put(table.getName(), (Object)table);
    }

    public void removeTable(DBTable table) {
        this.tables.remove(table.getName());
    }

    public void addSequence(DBSequence sequence) {
        this.sequences.put(sequence.getName(), (Object)sequence);
    }

    @Override
    public List<DBSequence> getSequences(boolean recursive) {
        return this.getSequences(recursive, new ArrayList<DBSequence>());
    }

    public List<DBSequence> getSequences(boolean recursive, List<DBSequence> result) {
        result.addAll(this.sequences.values());
        if (recursive) {
            for (TableContainer subContainer : this.subContainers.values()) {
                subContainer.getSequences(recursive, result);
            }
        }
        return result;
    }

    public List<ContainerComponent> getComponents() {
        ArrayList<ContainerComponent> result = new ArrayList<ContainerComponent>();
        result.addAll(this.getTables(false));
        result.addAll(this.getSubContainers());
        result.addAll(this.getSequences(false));
        return result;
    }
}

