/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.util.ArrayList;
import java.util.List;
import org.databene.jdbacl.model.AbstractCompositeDBObject;
import org.databene.jdbacl.model.CompositeDBObject;
import org.databene.jdbacl.model.ContainerComponent;
import org.databene.jdbacl.model.DBCatalog;
import org.databene.jdbacl.model.DBObject;
import org.databene.jdbacl.model.DBSchema;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.SequenceHolder;
import org.databene.jdbacl.model.TableContainerSupport;
import org.databene.jdbacl.model.TableHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableContainer
extends AbstractCompositeDBObject<ContainerComponent>
implements ContainerComponent,
TableHolder,
SequenceHolder {
    private static final long serialVersionUID = 5890222751656809426L;
    TableContainerSupport support;

    public TableContainer(String name) {
        this(name, (CompositeDBObject<? extends DBObject>)null);
    }

    public TableContainer(String name, CompositeDBObject<? extends DBObject> parent) {
        super(name, "container");
        if (parent instanceof TableContainer) {
            ((TableContainer)parent).addSubContainer(this);
        }
        this.support = new TableContainerSupport();
    }

    private void addSubContainer(TableContainer subContainer) {
        this.support.addSubContainer(subContainer);
    }

    public DBSchema getSchema() {
        CompositeDBObject<?> parent;
        for (parent = this.getOwner(); parent != null && !(parent instanceof DBSchema); parent = parent.getOwner()) {
        }
        return (DBSchema)parent;
    }

    public DBCatalog getCatalog() {
        return this.getSchema().getCatalog();
    }

    @Override
    public List<ContainerComponent> getComponents() {
        ArrayList<ContainerComponent> result = new ArrayList<ContainerComponent>();
        result.addAll(this.support.getTables());
        result.addAll(this.support.getSubContainers());
        return result;
    }

    @Override
    public List<DBTable> getTables() {
        return this.support.getTables();
    }

    @Override
    public List<DBTable> getTables(boolean recursive) {
        return this.support.getTables(recursive);
    }

    public List<DBTable> getTables(boolean recursive, List<DBTable> result) {
        return this.support.getTables(recursive, result);
    }

    @Override
    public DBTable getTable(String tableName) {
        return this.support.getTable(tableName);
    }

    public void addTable(DBTable table) {
        this.support.addTable(table);
    }

    public void removeTable(DBTable table) {
        this.support.removeTable(table);
    }

    @Override
    public List<DBSequence> getSequences(boolean recursive) {
        return this.support.getSequences(recursive);
    }

    public List<DBSequence> getSequences(boolean recursive, List<DBSequence> result) {
        return this.support.getSequences(recursive, result);
    }
}

