/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.util.ArrayList;
import java.util.List;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ArrayUtil;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.StringUtil;
import org.databene.jdbacl.SQLUtil;
import org.databene.jdbacl.model.DBForeignKeyConstraint;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKeyPath {
    private String startTable;
    private List<DBForeignKeyConstraint> edges;

    public ForeignKeyPath(DBForeignKeyConstraint ... edges) {
        this.startTable = ArrayUtil.isEmpty((Object)edges) ? null : edges[0].getTable().getName();
        this.edges = CollectionUtil.toList((Object[])edges);
    }

    public ForeignKeyPath(String startTable) {
        this.startTable = startTable;
        this.edges = new ArrayList<DBForeignKeyConstraint>();
    }

    public ForeignKeyPath(ForeignKeyPath prototype) {
        this.startTable = prototype.startTable;
        this.edges = new ArrayList<DBForeignKeyConstraint>(prototype.edges);
    }

    public String getStartTable() {
        return this.startTable;
    }

    public List<DBForeignKeyConstraint> getEdges() {
        return this.edges;
    }

    public void addEdge(DBForeignKeyConstraint fk) {
        if (this.edges.size() == 0) {
            if (this.startTable == null) {
                this.startTable = fk.getTable().getName();
            } else if (!this.startTable.equals(fk.getTable().getName())) {
                throw new IllegalArgumentException("Expected reference from " + this.startTable + ", " + "but found one to " + fk.getTable());
            }
        }
        this.edges.add(fk);
    }

    public String getTargetTable() {
        if (this.edges.size() > 0) {
            return this.edges.get(this.edges.size() - 1).getRefereeTable().getName();
        }
        return this.startTable;
    }

    public ForeignKeyPath derivePath(DBForeignKeyConstraint fk) {
        ForeignKeyPath result = new ForeignKeyPath(this);
        result.addEdge(fk);
        return result;
    }

    public List<DBTable> getIntermediates() {
        ArrayList<DBTable> result = new ArrayList<DBTable>(this.edges.size() - 1);
        for (int i = 0; i < this.edges.size() - 1; ++i) {
            result.add(this.edges.get(i).getRefereeTable());
        }
        return result;
    }

    public boolean hasIntermediate(DBTable intermediate) {
        for (int i = 0; i < this.edges.size() - 1; ++i) {
            if (!this.edges.get(i).getRefereeTable().equals(intermediate)) continue;
            return true;
        }
        return false;
    }

    public String[] getEndColumnNames() {
        return ((DBForeignKeyConstraint)CollectionUtil.lastElement(this.edges)).getRefereeColumnNames();
    }

    public static ForeignKeyPath parse(String spec, Database database) {
        String[] nodes = spec.split(" \\->");
        ForeignKeyPath path = new ForeignKeyPath(new DBForeignKeyConstraint[0]);
        for (int i = 0; i < nodes.length - 1; ++i) {
            path.addEdge(ForeignKeyPath.parseFK(nodes[i], database));
        }
        return path;
    }

    private static DBForeignKeyConstraint parseFK(String spec, Database database) {
        spec = spec.trim();
        int iBracket = spec.indexOf(40);
        String tableName = spec.substring(0, iBracket);
        String columnList = spec.substring(iBracket + 1, spec.length() - 1);
        Object[] columns = StringUtil.splitAndTrim((String)columnList, (char)',');
        DBTable refererTable = database.getTable(tableName, true);
        DBForeignKeyConstraint fk = refererTable.getForeignKeyConstraint((String[])columns);
        if (fk == null) {
            throw new ObjectNotFoundException("Foreign ke constraint not found: " + tableName + '(' + ArrayFormat.format((Object[])columns) + ')');
        }
        return fk;
    }

    public String getTablePath() {
        StringBuilder builder = new StringBuilder();
        for (DBForeignKeyConstraint edge : this.edges) {
            builder.append(edge.getTable().getName()).append(", ");
        }
        if (this.edges.size() > 0) {
            DBForeignKeyConstraint endEdge = (DBForeignKeyConstraint)CollectionUtil.lastElement(this.edges);
            builder.append(endEdge.getRefereeTable().getName());
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (DBForeignKeyConstraint edge : this.edges) {
            builder.append(edge.getTable().getName()).append(SQLUtil.renderColumnNames(edge.getColumnNames())).append(" -> ");
        }
        if (this.edges.size() > 0) {
            DBForeignKeyConstraint endEdge = (DBForeignKeyConstraint)CollectionUtil.lastElement(this.edges);
            builder.append(endEdge.getRefereeTable().getName()).append(SQLUtil.renderColumnNames(endEdge.getRefereeColumnNames()));
        }
        return builder.toString();
    }
}

