/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.StringUtil;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.commons.version.VersionNumber;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.DatabaseDialectManager;
import org.databene.jdbacl.model.AbstractCompositeDBObject;
import org.databene.jdbacl.model.DBCatalog;
import org.databene.jdbacl.model.DBPackage;
import org.databene.jdbacl.model.DBSchema;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.DBTrigger;
import org.databene.jdbacl.model.SequenceHolder;
import org.databene.jdbacl.model.TableHolder;
import org.databene.jdbacl.model.jdbc.JDBCDBImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
extends AbstractCompositeDBObject<DBCatalog>
implements TableHolder,
SequenceHolder {
    private static final long serialVersionUID = -1975619615948817919L;
    private String environment;
    private String productName;
    private VersionNumber productVersion;
    private Date importDate;
    private String user;
    private String tableInclusionPattern;
    private String tableExclusionPattern;
    private Set<String> reservedWords;
    private OrderedNameMap<DBCatalog> catalogs;
    private JDBCDBImporter importer;
    private boolean sequencesImported;
    private boolean triggersImported;
    private boolean packagesImported;
    private boolean checksImported;

    public Database(String environment) {
        this(environment, new JDBCDBImporter(environment), true);
    }

    public Database(String environment, String productName, String productVersion, Date importDate) {
        this(environment, null, false);
        this.productName = productName;
        this.productVersion = VersionNumber.valueOf((String)productVersion);
        this.importDate = importDate;
    }

    public Database(String environment, JDBCDBImporter importer, boolean prepopulate) {
        super(environment, "database");
        try {
            this.environment = environment;
            this.reservedWords = null;
            this.catalogs = OrderedNameMap.createCaseIgnorantMap();
            this.sequencesImported = false;
            this.triggersImported = false;
            this.packagesImported = false;
            this.checksImported = false;
            this.importer = importer;
            if (importer != null) {
                this.productName = importer.getDatabaseProductName();
                this.productVersion = importer.getDatabaseProductVersion();
                this.importDate = new Date();
                if (prepopulate) {
                    importer.importCatalogs(this);
                    importer.importSchemas(this);
                    importer.importAllTables(this);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Database import failed for environment " + environment, e);
        }
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getDatabaseProductName() {
        return this.productName;
    }

    public VersionNumber getDatabaseProductVersion() {
        return this.productVersion;
    }

    public Date getImportDate() {
        return this.importDate;
    }

    public void setImportDate(Date importDate) {
        this.importDate = importDate;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getTableInclusionPattern() {
        return this.tableInclusionPattern;
    }

    public void setTableInclusionPattern(String tableInclusionPattern) {
        this.tableInclusionPattern = tableInclusionPattern;
    }

    public String getTableExclusionPattern() {
        return this.tableExclusionPattern;
    }

    public void setTableExclusionPattern(String tableExclusionPattern) {
        this.tableExclusionPattern = tableExclusionPattern;
    }

    public boolean isReservedWord(String word) {
        return this.getReservedWords().contains(word);
    }

    private Set<String> getReservedWords() {
        if (this.reservedWords == null) {
            try {
                Connection connection = this.importer != null ? this.importer.getConnection() : null;
                DatabaseDialect dialect = DatabaseDialectManager.getDialectForProduct(this.productName, this.productVersion);
                this.reservedWords = dialect.getReservedWords(connection);
            }
            catch (Exception e) {
                throw new RuntimeException("Error fetching reserved words", e);
            }
        }
        return this.reservedWords;
    }

    public JDBCDBImporter getImporter() {
        return this.importer;
    }

    @Override
    public List<DBCatalog> getComponents() {
        return this.catalogs.values();
    }

    public List<DBCatalog> getCatalogs() {
        return this.getComponents();
    }

    public DBCatalog getCatalog(String catalogName) {
        return (DBCatalog)this.catalogs.get(catalogName);
    }

    public void addCatalog(DBCatalog catalog) {
        catalog.setDatabase(this);
        this.catalogs.put(catalog.getName(), (Object)catalog);
    }

    public void removeCatalog(DBCatalog catalog) {
        this.catalogs.remove(catalog.getName());
        catalog.setOwner(null);
    }

    public DBSchema getSchema(String schemaName) {
        for (DBCatalog catalog : this.getCatalogs()) {
            DBSchema schema = catalog.getSchema(schemaName);
            if (schema == null) continue;
            return schema;
        }
        throw new ObjectNotFoundException("Table '" + this.name + "'");
    }

    @Override
    public List<DBTable> getTables() {
        return this.getTables(true);
    }

    @Override
    public List<DBTable> getTables(boolean recursive) {
        if (!recursive) {
            return new ArrayList<DBTable>();
        }
        ArrayList<DBTable> tables = new ArrayList<DBTable>();
        for (DBCatalog catalog : this.getCatalogs()) {
            for (DBTable table : catalog.getTables()) {
                tables.add(table);
            }
        }
        return tables;
    }

    @Override
    public DBTable getTable(String name) {
        return this.getTable(name, true);
    }

    public DBTable getTable(String name, boolean required) {
        for (DBCatalog catalog : this.getCatalogs()) {
            for (DBTable table : catalog.getTables()) {
                if (!StringUtil.equalsIgnoreCase((String)table.getName(), (String)name)) continue;
                return table;
            }
        }
        if (required) {
            throw new ObjectNotFoundException("Table '" + name + "'");
        }
        return null;
    }

    public void removeTable(String tableName) {
        DBTable table = this.getTable(tableName, true);
        table.getSchema().removeTable(table);
    }

    public List<DBSequence> getSequences() {
        this.haveSequencesImported();
        return this.getSequences(true);
    }

    @Override
    public List<DBSequence> getSequences(boolean recursive) {
        this.haveSequencesImported();
        if (!recursive) {
            return new ArrayList<DBSequence>();
        }
        ArrayList<DBSequence> sequences = new ArrayList<DBSequence>();
        for (DBCatalog catalog : this.getCatalogs()) {
            for (DBSequence table : catalog.getSequences()) {
                sequences.add(table);
            }
        }
        return sequences;
    }

    public synchronized void haveSequencesImported() {
        if (!this.sequencesImported) {
            if (this.importer != null) {
                this.importer.importSequences(this);
            }
            this.sequencesImported = true;
        }
    }

    public boolean isSequencesImported() {
        return this.sequencesImported;
    }

    public void setSequencesImported(boolean sequencesImported) {
        this.sequencesImported = sequencesImported;
    }

    public List<DBTrigger> getTriggers() {
        this.haveTriggersImported();
        ArrayList<DBTrigger> triggers = new ArrayList<DBTrigger>();
        for (DBCatalog catalog : this.getCatalogs()) {
            for (DBSchema schema : catalog.getSchemas()) {
                triggers.addAll(schema.getTriggers());
            }
        }
        return triggers;
    }

    public synchronized void haveTriggersImported() {
        if (!this.triggersImported) {
            try {
                if (this.importer != null) {
                    this.importer.importTriggers(this);
                }
                this.triggersImported = true;
            }
            catch (SQLException e) {
                throw new RuntimeException("Import of database triggers failed: " + this.getName(), e);
            }
        }
    }

    public boolean isTriggersImported() {
        return this.triggersImported;
    }

    public void setTriggersImported(boolean triggersImported) {
        this.triggersImported = triggersImported;
    }

    public List<DBPackage> getPackages() {
        this.havePackagesImported();
        ArrayList<DBPackage> packages = new ArrayList<DBPackage>();
        for (DBCatalog catalog : this.getCatalogs()) {
            for (DBSchema schema : catalog.getSchemas()) {
                packages.addAll(schema.getPackages());
            }
        }
        return packages;
    }

    public synchronized void havePackagesImported() {
        if (!this.packagesImported) {
            try {
                this.packagesImported = true;
                if (this.importer != null) {
                    this.importer.importPackages(this);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Import of database packages failed: " + this.getName(), e);
            }
        }
    }

    public boolean isPackagesImported() {
        return this.packagesImported;
    }

    public void setPackagesImported(boolean packagesImported) {
        this.packagesImported = packagesImported;
    }

    public boolean isChecksImported() {
        return this.checksImported;
    }

    public void setChecksImported(boolean checksImported) {
        this.checksImported = checksImported;
    }

    public synchronized void haveChecksImported() {
        if (!this.isChecksImported() && this.importer != null) {
            this.importer.importAllChecks(this);
        }
    }
}

