/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import org.databene.commons.NullSafeComparator;
import org.databene.jdbacl.model.AbstractDBObject;
import org.databene.jdbacl.model.ContainerComponent;
import org.databene.jdbacl.model.DBObject;
import org.databene.jdbacl.model.DBSchema;

public class DBTrigger
extends AbstractDBObject
implements ContainerComponent {
    private static final long serialVersionUID = -183721433730785529L;
    private String triggerType;
    private String triggeringEvent;
    private String tableOwner;
    private String baseObjectType;
    private String tableName;
    private String columnName;
    private String referencingNames;
    private String whenClause;
    private String status;
    private String description;
    private String actionType;
    private String triggerBody;
    private Double priority;
    private Boolean staticColumn;
    private String conditionTime;

    public DBTrigger(String name, DBSchema owner) {
        super(name, "trigger", owner);
        if (owner != null) {
            DBSchema schema = owner;
            schema.addTrigger(this);
        }
    }

    public String getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(String triggerType) {
        this.triggerType = triggerType;
    }

    public String getTriggeringEvent() {
        return this.triggeringEvent;
    }

    public void setTriggeringEvent(String triggeringEvent) {
        this.triggeringEvent = triggeringEvent;
    }

    public String getTableOwner() {
        return this.tableOwner;
    }

    public void setTableOwner(String tableOwner) {
        this.tableOwner = tableOwner;
    }

    public String getBaseObjectType() {
        return this.baseObjectType;
    }

    public void setBaseObjectType(String baseObjectType) {
        this.baseObjectType = baseObjectType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getReferencingNames() {
        return this.referencingNames;
    }

    public void setReferencingNames(String referencingNames) {
        this.referencingNames = referencingNames;
    }

    public String getWhenClause() {
        return this.whenClause;
    }

    public void setWhenClause(String whenClause) {
        this.whenClause = whenClause;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getTriggerBody() {
        return this.triggerBody;
    }

    public void setTriggerBody(String triggerBody) {
        this.triggerBody = triggerBody;
    }

    public double getPriority() {
        return this.priority;
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    public Boolean getStaticColumn() {
        return this.staticColumn;
    }

    public void setStaticColumn(Boolean staticColumn) {
        this.staticColumn = staticColumn;
    }

    public String getConditionTime() {
        return this.conditionTime;
    }

    public void setConditionTime(String conditionTime) {
        this.conditionTime = conditionTime;
    }

    public String getNormalizedDescription() {
        String defaultPrefix;
        String result = this.description.trim();
        if (this.owner != null && result.startsWith(defaultPrefix = '\"' + this.owner.getName().toUpperCase() + "\".")) {
            result = result.substring(defaultPrefix.length());
        }
        return result;
    }

    public boolean isIdentical(DBObject object) {
        if (!(object instanceof DBTrigger)) {
            return false;
        }
        DBTrigger that = (DBTrigger)object;
        return NullSafeComparator.equals((Object)this.triggerType, (Object)that.triggerType) && NullSafeComparator.equals((Object)this.triggeringEvent, (Object)that.triggeringEvent) && NullSafeComparator.equals((Object)this.baseObjectType, (Object)that.baseObjectType) && NullSafeComparator.equals((Object)this.tableName, (Object)that.tableName) && NullSafeComparator.equals((Object)this.columnName, (Object)that.columnName) && NullSafeComparator.equals((Object)this.referencingNames, (Object)that.referencingNames) && NullSafeComparator.equals((Object)this.whenClause, (Object)that.whenClause) && NullSafeComparator.equals((Object)this.status, (Object)that.status) && NullSafeComparator.equals((Object)this.actionType, (Object)that.actionType) && NullSafeComparator.equals((Object)this.triggerBody.trim(), (Object)that.triggerBody.trim());
    }
}

