/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.math.BigInteger;
import org.databene.commons.NullSafeComparator;
import org.databene.jdbacl.model.AbstractDBObject;
import org.databene.jdbacl.model.CompositeDBObject;
import org.databene.jdbacl.model.ContainerComponent;
import org.databene.jdbacl.model.DBObject;
import org.databene.jdbacl.model.DBSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSequence
extends AbstractDBObject
implements ContainerComponent {
    private static final long serialVersionUID = 8602052311285255364L;
    private String catalogName;
    private String schemaName;
    private BigInteger start = BigInteger.ONE;
    private BigInteger increment = BigInteger.ONE;
    private BigInteger maxValue = null;
    private BigInteger minValue = null;
    private Boolean cycle;
    private Long cache;
    private Boolean order;
    private BigInteger lastNumber = BigInteger.ZERO;

    public DBSequence(String name, DBSchema owner) {
        super(name, "sequence", owner);
        if (owner != null) {
            owner.addSequence(this);
        }
    }

    public DBSequence(String name, String catalogName, String schemaName) {
        super(name, "sequence", null);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    @Override
    public void setOwner(CompositeDBObject<?> owner) {
        super.setOwner(owner);
        if (owner != null) {
            DBSchema schema = (DBSchema)owner;
            this.catalogName = schema.getCatalog().getName();
            this.schemaName = schema.getName();
        }
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public BigInteger getStart() {
        return this.start;
    }

    public BigInteger getStartIfNotDefault() {
        return BigInteger.ONE.equals(this.start) ? null : this.start;
    }

    public void setStart(BigInteger start) {
        this.start = start;
    }

    public BigInteger getIncrement() {
        return this.increment;
    }

    public BigInteger getIncrementIfNotDefault() {
        return BigInteger.ONE.equals(this.increment) ? null : this.increment;
    }

    public void setIncrement(BigInteger increment) {
        this.increment = increment;
    }

    public BigInteger getMaxValue() {
        return this.maxValue;
    }

    public BigInteger getMaxValueIfNotDefault() {
        return this.maxValue;
    }

    public void setMaxValue(BigInteger maxValue) {
        this.maxValue = maxValue;
    }

    public BigInteger getMinValue() {
        return this.minValue;
    }

    public BigInteger getMinValueIfNotDefault() {
        return this.minValue;
    }

    public void setMinValue(BigInteger minValue) {
        this.minValue = minValue;
    }

    public Boolean isCycle() {
        return this.cycle;
    }

    public void setCycle(Boolean cycle) {
        this.cycle = cycle;
    }

    public Long getCache() {
        return this.cache;
    }

    public void setCache(Long cache) {
        this.cache = cache;
    }

    public Boolean isOrder() {
        return this.order;
    }

    public void setOrder(Boolean order) {
        this.order = order;
    }

    public BigInteger getLastNumber() {
        return this.lastNumber;
    }

    public void setLastNumber(BigInteger lastNumber) {
        this.lastNumber = lastNumber;
    }

    @Override
    public boolean isIdentical(DBObject other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DBSequence)) {
            return false;
        }
        DBSequence that = (DBSequence)other;
        return this.name.equals(that.getName()) && this.start == that.getStart() && this.increment == that.getIncrement() && NullSafeComparator.equals((Object)this.maxValue, (Object)that.getMaxValue()) && NullSafeComparator.equals((Object)this.minValue, (Object)that.getMinValue()) && this.cycle == that.isCycle() && this.cache == that.getCache() && this.order == that.isOrder();
    }

    public String dropDDL() {
        return "drop sequence " + this.name;
    }
}

