/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.jdbacl.model.AbstractCompositeDBObject;
import org.databene.jdbacl.model.DBCatalog;
import org.databene.jdbacl.model.DBObject;
import org.databene.jdbacl.model.DBPackage;
import org.databene.jdbacl.model.DBSequence;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.DBTrigger;
import org.databene.jdbacl.model.Database;
import org.databene.jdbacl.model.SequenceHolder;
import org.databene.jdbacl.model.TableHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSchema
extends AbstractCompositeDBObject<DBObject>
implements TableHolder,
SequenceHolder,
Serializable {
    private static final long serialVersionUID = -8481832064630225273L;
    private List<DBObject> components;
    private OrderedNameMap<DBTable> tables;
    private OrderedNameMap<DBSequence> sequences;
    private OrderedNameMap<DBTrigger> triggers;
    private OrderedNameMap<DBPackage> packages;

    public DBSchema(String name) {
        this(name, (DBCatalog)null);
    }

    public DBSchema(String name, DBCatalog catalog) {
        super(name, "schema");
        if (catalog != null) {
            catalog.addSchema(this);
        }
        this.components = new ArrayList<DBObject>();
        this.tables = OrderedNameMap.createCaseIgnorantMap();
        this.sequences = OrderedNameMap.createCaseIgnorantMap();
        this.triggers = OrderedNameMap.createCaseIgnorantMap();
        this.packages = OrderedNameMap.createCaseIgnorantMap();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Database getDatabase() {
        return this.getCatalog().getDatabase();
    }

    public DBCatalog getCatalog() {
        return (DBCatalog)this.owner;
    }

    public void setCatalog(DBCatalog catalog) {
        this.owner = catalog;
    }

    @Override
    public List<DBObject> getComponents() {
        return this.components;
    }

    @Override
    public List<DBTable> getTables() {
        return this.tables.values();
    }

    @Override
    public List<DBTable> getTables(boolean recursive) {
        return this.getTables();
    }

    @Override
    public DBTable getTable(String tableName) {
        return (DBTable)this.tables.get(tableName);
    }

    public void addTable(DBTable table) {
        this.tables.put(table.getName(), (Object)table);
        this.components.add(table);
    }

    public void removeTable(DBTable table) {
        this.tables.remove(table.getName());
        this.components.remove(table);
    }

    @Override
    public List<DBSequence> getSequences(boolean recursive) {
        this.getDatabase().haveSequencesImported();
        return this.sequences.values();
    }

    public void addSequence(DBSequence sequence) {
        this.getDatabase().haveSequencesImported();
        this.receiveSequence(sequence);
    }

    public void receiveSequence(DBSequence sequence) {
        this.sequences.put(sequence.getName(), (Object)sequence);
        this.components.add(sequence);
    }

    public List<DBTrigger> getTriggers() {
        this.getDatabase().haveTriggersImported();
        return this.triggers.values();
    }

    public void addTrigger(DBTrigger trigger) {
        this.getDatabase().haveTriggersImported();
        this.receiveTrigger(trigger);
    }

    public void receiveTrigger(DBTrigger trigger) {
        this.triggers.put(trigger.getName(), (Object)trigger);
        this.components.add(trigger);
    }

    public List<DBPackage> getPackages() {
        this.getDatabase().havePackagesImported();
        return this.packages.values();
    }

    public void addPackage(DBPackage pkg) {
        this.getDatabase().havePackagesImported();
        this.receivePackage(pkg);
    }

    public void receivePackage(DBPackage pkg) {
        this.packages.put(pkg.getName(), (Object)pkg);
        this.components.add(pkg);
    }
}

