/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import org.databene.commons.Assert;
import org.databene.commons.NullSafeComparator;
import org.databene.jdbacl.model.DBConstraint;
import org.databene.jdbacl.model.DBObject;
import org.databene.jdbacl.model.DBTable;

public class DBNotNullConstraint
extends DBConstraint {
    private static final long serialVersionUID = 5087538327994954133L;
    private String columnName;

    public DBNotNullConstraint(DBTable owner, String name, boolean nameDeterministic, String columnName) {
        super(name, nameDeterministic, "not null constraint", owner);
        Assert.notNull((Object)owner, (String)"owner");
        Assert.notNull((Object)columnName, (String)"column name");
        this.columnName = columnName;
        if (owner != null) {
            owner.getColumn(columnName).setNotNullConstraint(this);
        }
    }

    public String[] getColumnNames() {
        return new String[]{this.columnName};
    }

    public boolean isIdentical(DBObject other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DBNotNullConstraint)) {
            return false;
        }
        DBNotNullConstraint that = (DBNotNullConstraint)other;
        return NullSafeComparator.equals((Object)this.name, (Object)that.name) && this.columnName.equals(that.columnName) && NullSafeComparator.equals((Object)this.getTable().getName(), (Object)that.getTable().getName());
    }
}

