/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.util.Arrays;
import org.databene.commons.ArrayUtil;
import org.databene.commons.Assert;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.bean.HashCodeBuilder;
import org.databene.jdbacl.NameSpec;
import org.databene.jdbacl.SQLUtil;
import org.databene.jdbacl.model.DBConstraint;
import org.databene.jdbacl.model.DBObject;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.FKChangeRule;
import org.databene.jdbacl.model.MultiColumnObject;

public class DBForeignKeyConstraint
extends DBConstraint
implements MultiColumnObject {
    private static final long serialVersionUID = -7488054587082654132L;
    private final String[] fkColumnNames;
    private final DBTable refereeTable;
    private final String[] refereeColumnNames;
    private FKChangeRule updateRule;
    private FKChangeRule deleteRule;

    public DBForeignKeyConstraint(String name, boolean nameDeterministic, DBTable owner, String fkColumnName, DBTable refereeTable, String refereeColumnName) {
        this(name, nameDeterministic, owner, new String[]{fkColumnName}, refereeTable, new String[]{refereeColumnName});
    }

    public DBForeignKeyConstraint(String name, boolean nameDeterministic, DBTable owner, String[] fkColumnNames, DBTable refereeTable, String[] refereeColumnNames) {
        super(name, nameDeterministic, "foreign key constraint", owner);
        Assert.notNull((Object)refereeTable, (String)"refereeTable");
        this.fkColumnNames = fkColumnNames;
        this.refereeTable = refereeTable;
        this.refereeColumnNames = refereeColumnNames;
        this.updateRule = FKChangeRule.NO_ACTION;
        this.deleteRule = FKChangeRule.NO_ACTION;
        if (owner != null) {
            owner.addForeignKey(this);
        }
    }

    public String[] getForeignKeyColumnNames() {
        return this.fkColumnNames;
    }

    public String columnReferencedBy(String fkColumnName) {
        return this.columnReferencedBy(fkColumnName, true);
    }

    public String columnReferencedBy(String fkColumnName, boolean required) {
        int index = ArrayUtil.indexOf((Object)fkColumnName, (Object[])this.fkColumnNames);
        if (index < 0) {
            if (required) {
                throw new ObjectNotFoundException("foreign key '" + this.name + "' does not have a column '" + fkColumnName + "'");
            }
            return null;
        }
        return this.refereeColumnNames[index];
    }

    public DBTable getRefereeTable() {
        return this.refereeTable;
    }

    public String[] getColumnNames() {
        return this.fkColumnNames;
    }

    public String[] getRefereeColumnNames() {
        return this.refereeColumnNames;
    }

    public boolean isIdentical(DBObject other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DBForeignKeyConstraint)) {
            return false;
        }
        DBForeignKeyConstraint that = (DBForeignKeyConstraint)other;
        return NullSafeComparator.equals((Object)this.name, (Object)that.name) && Arrays.equals(this.fkColumnNames, that.fkColumnNames) && Arrays.equals(this.refereeColumnNames, that.refereeColumnNames) && NullSafeComparator.equals((Object)this.refereeTable.getName(), (Object)that.refereeTable.getName());
    }

    public FKChangeRule getUpdateRule() {
        return this.updateRule;
    }

    public void setUpdateRule(FKChangeRule updateRule) {
        this.updateRule = updateRule;
    }

    public FKChangeRule getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(FKChangeRule deleteRule) {
        this.deleteRule = deleteRule;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DBForeignKeyConstraint that = (DBForeignKeyConstraint)other;
        return this.isIdentical(that) && NullSafeComparator.equals((Object)this.refereeTable, (Object)that.refereeTable);
    }

    public int hashCode() {
        return HashCodeBuilder.hashCode((Object[])new Object[]{super.hashCode(), Arrays.hashCode(this.fkColumnNames), Arrays.hashCode(this.refereeColumnNames), this.refereeTable.hashCode()});
    }

    public String toString() {
        return SQLUtil.fkSpec(this, NameSpec.ALWAYS);
    }
}

