/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.util.Arrays;
import org.databene.commons.ArrayFormat;
import org.databene.commons.bean.HashCodeBuilder;
import org.databene.jdbacl.model.AbstractDBTableComponent;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.MultiColumnObject;

public abstract class DBConstraint
extends AbstractDBTableComponent
implements MultiColumnObject {
    private static final long serialVersionUID = 3768329019450975632L;
    private boolean nameDeterministic;

    public DBConstraint(String name, boolean nameDeterministic, String objectType, DBTable owner) {
        super(name, objectType, owner);
        this.nameDeterministic = nameDeterministic;
    }

    public abstract String[] getColumnNames();

    public DBTable getTable() {
        return (DBTable)this.getOwner();
    }

    public boolean isNameDeterministic() {
        return this.nameDeterministic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBConstraint that = (DBConstraint)o;
        return this.getOwner().equals(that.getOwner()) && Arrays.equals(this.getColumnNames(), that.getColumnNames());
    }

    public int hashCode() {
        return HashCodeBuilder.hashCode((Object[])new Object[]{this.getOwner(), this.getColumnNames()});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append('[').append(this.getOwner().getName()).append('[');
        builder.append(ArrayFormat.format((Object[])this.getColumnNames()));
        builder.append("]]");
        return builder.toString();
    }
}

