/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.util.ArrayList;
import java.util.List;
import org.databene.commons.ArrayUtil;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.bean.HashCodeBuilder;
import org.databene.jdbacl.SQLUtil;
import org.databene.jdbacl.model.AbstractDBTableComponent;
import org.databene.jdbacl.model.DBDataType;
import org.databene.jdbacl.model.DBForeignKeyConstraint;
import org.databene.jdbacl.model.DBNotNullConstraint;
import org.databene.jdbacl.model.DBObject;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.DBUniqueConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBColumn
extends AbstractDBTableComponent {
    private static final long serialVersionUID = 130665821777405940L;
    protected DBDataType type;
    protected Integer size;
    protected Integer fractionDigits;
    protected String defaultValue;
    protected boolean versionColumn;
    protected List<DBUniqueConstraint> ukConstraints;
    protected DBNotNullConstraint notNullConstraint;

    public DBColumn(String name, DBTable table, DBDataType type) {
        this(name, table, type, null);
    }

    public DBColumn(String name, DBTable table, int jdbcType, String typeAndSize) {
        this(name, table, null, null);
        Object[] tokens = SQLUtil.parseColumnTypeAndSize(typeAndSize);
        if (tokens.length > 0) {
            this.type = DBDataType.getInstance(jdbcType, (String)tokens[0]);
        }
        if (tokens.length > 1) {
            this.size = (Integer)tokens[1];
        }
        if (tokens.length > 2) {
            this.fractionDigits = (Integer)tokens[2];
        }
    }

    public DBColumn(String name, DBTable table, DBDataType type, Integer size) {
        this(name, table, type, size, null);
    }

    public DBColumn(String name, DBTable table, DBDataType type, Integer size, Integer fractionDigits) {
        super(name, "column");
        if (table != null) {
            table.receiveColumn(this);
        }
        this.name = name;
        this.type = type;
        this.size = size;
        this.fractionDigits = fractionDigits;
        this.doc = null;
        this.defaultValue = null;
        this.ukConstraints = new ArrayList<DBUniqueConstraint>();
        this.notNullConstraint = null;
        this.versionColumn = false;
    }

    public DBDataType getType() {
        return this.type;
    }

    public void setType(DBDataType type) {
        this.type = type;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getFractionDigits() {
        return this.fractionDigits;
    }

    public void setFractionDigits(Integer fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isUnique() {
        this.getTable().getUniqueConstraints(true);
        for (DBUniqueConstraint constraint : this.ukConstraints) {
            if (constraint.getColumnNames().length != 1) continue;
            return true;
        }
        return false;
    }

    public boolean isPKComponent() {
        for (String candidate : this.getTable().getPKColumnNames()) {
            if (!this.name.equals(candidate)) continue;
            return true;
        }
        return false;
    }

    public List<DBUniqueConstraint> getUkConstraints() {
        return this.ukConstraints;
    }

    public void addUkConstraint(DBUniqueConstraint constraint) {
        this.ukConstraints.add(constraint);
    }

    public DBNotNullConstraint getNotNullConstraint() {
        return this.notNullConstraint;
    }

    public void setNotNullConstraint(DBNotNullConstraint notNullConstraint) {
        this.notNullConstraint = notNullConstraint;
    }

    public boolean isNullable() {
        return this.notNullConstraint == null;
    }

    public void setNullable(boolean nullable) {
        if (nullable) {
            this.notNullConstraint = null;
        } else if (this.isNullable()) {
            String constraintName = (this.getTable() != null ? this.getTable().getName() : "_") + '_' + this.name + "_NOT_NULL";
            this.notNullConstraint = new DBNotNullConstraint(this.getTable(), constraintName, true, this.name);
        }
    }

    public boolean isVersionColumn() {
        return this.versionColumn;
    }

    public void setVersionColumn(boolean versionColumn) {
        this.versionColumn = versionColumn;
    }

    public boolean isIntegerType() {
        return this.type.isInteger() || this.type.isDecimal() && (this.fractionDigits == null || this.fractionDigits == 0);
    }

    public DBForeignKeyConstraint getForeignKeyConstraint() {
        for (DBForeignKeyConstraint fk : this.getTable().getForeignKeyConstraints()) {
            if (!ArrayUtil.contains((Object)this.name, (Object)fk.getColumnNames())) continue;
            return fk;
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !DBColumn.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        DBColumn that = (DBColumn)obj;
        return NullSafeComparator.equals((Object)this.name, (Object)that.getName()) && this.type.equals(that.getType()) && NullSafeComparator.equals((Object)this.size, (Object)that.getSize()) && NullSafeComparator.equals((Object)this.fractionDigits, (Object)that.getFractionDigits()) && NullSafeComparator.equals((Object)this.defaultValue, (Object)that.getDefaultValue()) && this.versionColumn == that.isVersionColumn() && ((Object)this.ukConstraints).equals(that.getUkConstraints()) && NullSafeComparator.equals((Object)this.notNullConstraint, (Object)that.getNotNullConstraint());
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.hashCode((Object[])new Object[]{this.name, this.type, this.size, this.fractionDigits, this.defaultValue, this.versionColumn, this.ukConstraints, this.notNullConstraint});
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.name).append(" : ");
        SQLUtil.renderColumnTypeWithSize(this, builder);
        if (!this.isNullable()) {
            builder.append(" NOT NULL");
        }
        return builder.toString();
    }

    @Override
    public boolean isIdentical(DBObject other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DBColumn)) {
            return false;
        }
        return this.name.equals(other.getName()) && this.isEquivalent(other);
    }

    public boolean isEquivalent(DBObject other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DBColumn)) {
            return false;
        }
        DBColumn that = (DBColumn)other;
        return this.type.equals(that.getType()) && NullSafeComparator.equals((Object)this.size, (Object)that.getSize()) && NullSafeComparator.equals((Object)this.fractionDigits, (Object)that.getFractionDigits());
    }
}

