/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.util.HashSet;
import java.util.Set;
import org.antlr.runtime.CharStream;
import org.databene.commons.CollectionUtil;
import org.databene.commons.StringUtil;
import org.databene.jdbacl.model.DBConstraint;
import org.databene.jdbacl.model.DBObject;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.sql.ColumnExpression;
import org.databene.jdbacl.sql.SQLParserUtil;
import org.databene.jdbacl.sql.parser.ANTLRNoCaseStringStream;
import org.databene.script.Expression;
import org.databene.script.expression.WrapperExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCheckConstraint
extends DBConstraint {
    private static final long serialVersionUID = 3766067048212751458L;
    private String tableName;
    private String conditionText;
    private Expression<?> condition;
    private String[] columnNames;

    public DBCheckConstraint(String name, boolean nameDeterministic, DBTable owner, String conditionText) {
        this(name, nameDeterministic, owner.getName(), conditionText);
        owner.addCheckConstraint(this);
    }

    public DBCheckConstraint(String name, boolean nameDeterministic, String tableName, String conditionText) {
        super(name, nameDeterministic, "check constraint", null);
        this.tableName = tableName;
        this.conditionText = conditionText;
        this.condition = SQLParserUtil.parseExpression((CharStream)new ANTLRNoCaseStringStream(conditionText));
        this.columnNames = this.getColumnNames(this.condition);
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public boolean isIdentical(DBObject other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DBCheckConstraint)) {
            return false;
        }
        DBCheckConstraint that = (DBCheckConstraint)other;
        return this.name.equals(that.getName()) && this.conditionText.equals(that.getConditionText());
    }

    public boolean isEquivalent(DBCheckConstraint that) {
        return this.tableName.equals(that.tableName) && StringUtil.normalizeSpace((String)this.conditionText).equals(StringUtil.normalizeSpace((String)that.getConditionText()));
    }

    public String getConditionText() {
        return this.conditionText;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public String toString() {
        return (this.name != null ? "CONSTRAINT " + this.name : "") + "CHECK " + this.conditionText;
    }

    private String[] getColumnNames(Expression<?> condition) {
        return (String[])CollectionUtil.toArray(this.scanForColumns(condition, new HashSet<String>()), String.class);
    }

    private Set<String> scanForColumns(Expression<?> expression, Set<String> result) {
        if (expression instanceof ColumnExpression) {
            result.add(((ColumnExpression)expression).getColumnName());
        } else if (expression instanceof WrapperExpression) {
            for (Expression sourceExpression : ((WrapperExpression)expression).getSourceExpressions()) {
                this.scanForColumns(sourceExpression, result);
            }
        }
        return result;
    }
}

