/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.model;

import java.util.Iterator;
import java.util.List;
import org.databene.jdbacl.model.AbstractDBObject;
import org.databene.jdbacl.model.CompositeDBObject;
import org.databene.jdbacl.model.DBObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompositeDBObject<C extends DBObject>
extends AbstractDBObject
implements CompositeDBObject<C> {
    private static final long serialVersionUID = 4823482587175647368L;

    public AbstractCompositeDBObject(String name, String type) {
        this(name, type, null);
    }

    public AbstractCompositeDBObject(String name, String type, CompositeDBObject<?> owner) {
        super(name, type, owner);
    }

    @Override
    public boolean isIdentical(DBObject other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getObjectType().equals(other.getObjectType())) {
            return false;
        }
        List thisComponents = this.getComponents();
        List otherComponents = ((CompositeDBObject)other).getComponents();
        if (thisComponents.size() != otherComponents.size()) {
            return false;
        }
        Iterator componentIterator = this.getComponents().iterator();
        for (int i = 0; i < thisComponents.size(); ++i) {
            DBObject otherComponent;
            DBObject component = (DBObject)componentIterator.next();
            if (component.isIdentical(otherComponent = (DBObject)otherComponents.get(i))) continue;
            return false;
        }
        return true;
    }
}

