/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl.identity.xml;

import java.util.Set;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.StringUtil;
import org.databene.commons.xml.XMLUtil;
import org.databene.jdbacl.identity.IdentityModel;
import org.databene.jdbacl.identity.IdentityProvider;
import org.databene.jdbacl.identity.NaturalPkIdentity;
import org.databene.jdbacl.identity.NkPkQueryIdentity;
import org.databene.jdbacl.identity.SubNkPkQueryIdentity;
import org.databene.jdbacl.identity.UniqueKeyIdentity;
import org.databene.jdbacl.identity.xml.IdentityParseContext;
import org.databene.webdecs.xml.AbstractXMLElementParser;
import org.databene.webdecs.xml.ParseContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityParser
extends AbstractXMLElementParser<Object> {
    public static final String IDENTITY = "identity";
    public static final Set<String> REQUIRED_ATTRIBUTES = CollectionUtil.toSet((Object[])new String[]{"type", "table"});
    public static final Set<String> OPTIONAL_ATTRIBUTES = CollectionUtil.toSet((Object[])new String[]{"nk-pk-query", "sub-nk-pk-query", "parents", "unique-key", "natural-pk", "columns"});

    public IdentityParser() {
        super(IDENTITY, REQUIRED_ATTRIBUTES, OPTIONAL_ATTRIBUTES, new Class[]{Object.class});
    }

    public IdentityModel doParse(Element element, Object[] parentPath, ParseContext<Object> context) {
        IdentityModel identity;
        String type = IdentityParser.getRequiredAttribute((String)"type", (Element)element);
        String tableName = IdentityParser.getRequiredAttribute((String)"table", (Element)element);
        IdentityProvider identityProvider = ((IdentityParseContext)context).getIdentityProvider();
        if ("nk-pk-query".equals(type)) {
            identity = this.parseNkPkQuery(element, tableName);
        } else if ("sub-nk-pk-query".equals(type)) {
            identity = this.parseSubNkPkQuery(element, identityProvider, tableName);
        } else if ("unique-key".equals(type)) {
            identity = this.parseUniqueKey(element, tableName);
        } else if ("natural-pk".equals(type)) {
            identity = this.parseNaturalPk(element, tableName);
        } else {
            throw new ConfigurationError("Not a supported <identity> type: " + type);
        }
        identityProvider.registerIdentity(identity, identity.getTableName());
        return identity;
    }

    public static String createCheckName(String tableName, String type) {
        return tableName + "-identity-" + type;
    }

    private IdentityModel parseNkPkQuery(Element element, String tableName) {
        String nkPkQuery = XMLUtil.getWholeText((Element)element);
        return new NkPkQueryIdentity(tableName, nkPkQuery);
    }

    private IdentityModel parseNaturalPk(Element element, String tableName) {
        return new NaturalPkIdentity(tableName);
    }

    private IdentityModel parseUniqueKey(Element element, String tableName) {
        String[] columnNames = IdentityParser.getRequiredAttribute((String)"columns", (Element)element).split(",");
        columnNames = StringUtil.trimAll((String[])columnNames);
        UniqueKeyIdentity identity = new UniqueKeyIdentity(tableName, columnNames);
        return identity;
    }

    private IdentityModel parseSubNkPkQuery(Element element, IdentityProvider identityProvider, String tableName) {
        String[] parentTableNames = IdentityParser.getRequiredAttribute((String)"parents", (Element)element).split(",");
        SubNkPkQueryIdentity identity = new SubNkPkQueryIdentity(tableName, parentTableNames, identityProvider);
        identity.setSubNkPkQuery(XMLUtil.getWholeText((Element)element));
        return identity;
    }
}

